/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.localization;

import com.opensymphony.webwork.views.jsp.TagUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.localization.I18nResourceProvider;
import org.displaytag.localization.LocaleResolver;

public class I18nWebworkAdapter
implements LocaleResolver,
I18nResourceProvider {
    public static final String UNDEFINED_KEY = "???";
    private static Log log = LogFactory.getLog((Class)I18nWebworkAdapter.class);

    public Locale resolveLocale(HttpServletRequest request) {
        Locale result = null;
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        Iterator iterator = stack.getRoot().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof LocaleProvider)) continue;
            LocaleProvider lp = (LocaleProvider)o;
            result = lp.getLocale();
            break;
        }
        if (result == null) {
            log.debug((Object)"Missing LocalProvider actions, init locale to default");
            result = Locale.getDefault();
        }
        return result;
    }

    public String getResource(String resourceKey, String defaultValue, Tag tag, PageContext pageContext) {
        String key = resourceKey != null ? resourceKey : defaultValue;
        String message = null;
        OgnlValueStack stack = TagUtils.getStack((PageContext)pageContext);
        Iterator iterator = stack.getRoot().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof TextProvider)) continue;
            TextProvider tp = (TextProvider)o;
            message = tp.getText(key, null, null);
            break;
        }
        if (message == null && resourceKey != null) {
            log.debug((Object)Messages.getString("Localization.missingkey", resourceKey));
            message = UNDEFINED_KEY + resourceKey + UNDEFINED_KEY;
        }
        return message;
    }
}

