/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.notification.NotificationContract;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.ken.api.notification.NotificationSender;
import org.kuali.rice.ken.bo.Lockable;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.bo.NotificationPriorityBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientBo;
import org.kuali.rice.ken.bo.NotificationSenderBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KREN_NTFCTN_T")
public class NotificationBo
extends PersistableBusinessObjectBase
implements NotificationContract,
Lockable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Id
    @GeneratedValue(generator="KREN_NTFCTN_S")
    @PortableSequenceGenerator(name="KREN_NTFCTN_S")
    @Column(name="NTFCTN_ID", nullable=false)
    private Long id;
    @Column(name="DELIV_TYP", nullable=false)
    private String deliveryType;
    @Column(name="CRTE_DTTM", nullable=false)
    private Timestamp creationDateTimeValue;
    @Column(name="SND_DTTM", nullable=true)
    private Timestamp sendDateTimeValue;
    @Column(name="AUTO_RMV_DTTM", nullable=true)
    private Timestamp autoRemoveDateTimeValue;
    @Column(name="TTL", nullable=true)
    private String title;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="CNTNT", nullable=false)
    private String content;
    @Column(name="PROCESSING_FLAG", nullable=false)
    private String processingFlag;
    @Column(name="LOCKD_DTTM", nullable=true)
    private Timestamp lockedDateValue;
    @Column(name="DOC_TYP_NM", nullable=true)
    private String docTypeName;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="PRIO_ID")
    private NotificationPriorityBo priority;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="CNTNT_TYP_ID", nullable=false)
    private NotificationContentTypeBo contentType;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="CHNL_ID")
    private NotificationChannelBo channel;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="PRODCR_ID")
    private NotificationProducerBo producer;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=NotificationRecipientBo.class, mappedBy="notification")
    @OrderBy(value="id ASC")
    private List<NotificationRecipientBo> recipients;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=NotificationSenderBo.class, mappedBy="notification")
    @OrderBy(value="id ASC")
    private List<NotificationSenderBo> senders;
    static final long serialVersionUID = -504000067299137480L;

    public NotificationBo() {
        this.recipients = new ArrayList<NotificationRecipientBo>();
        this.senders = new ArrayList<NotificationSenderBo>();
        this.processingFlag = "UNRESOLVED";
    }

    public Timestamp getCreationDateTimeValue() {
        return this._persistence_get_creationDateTimeValue();
    }

    public DateTime getCreationDateTime() {
        return this._persistence_get_creationDateTimeValue() == null ? null : new DateTime((Object)this._persistence_get_creationDateTimeValue());
    }

    public void setCreationDateTimeValue(Timestamp created) {
        this._persistence_set_creationDateTimeValue(created);
    }

    public Integer getLockVerNbr() {
        return super.getVersionNumber().intValue();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        super.setVersionNumber(Long.valueOf(lockVerNbr.longValue()));
    }

    public List<NotificationRecipientBo> getRecipients() {
        return this._persistence_get_recipients();
    }

    public void setRecipients(List<NotificationRecipientBo> recipients) {
        this._persistence_set_recipients(recipients);
    }

    public NotificationRecipientBo getRecipient(int index) {
        return (NotificationRecipientBo)((Object)this._persistence_get_recipients().get(index));
    }

    public void addRecipient(NotificationRecipientBo recipient) {
        this._persistence_get_recipients().add(recipient);
    }

    public List<NotificationSenderBo> getSenders() {
        return this._persistence_get_senders();
    }

    public void setSenders(List<NotificationSenderBo> senders) {
        this._persistence_set_senders(senders);
    }

    public NotificationSenderBo getSender(int index) {
        return (NotificationSenderBo)((Object)this._persistence_get_senders().get(index));
    }

    public void addSender(NotificationSenderBo sender) {
        this._persistence_get_senders().add(sender);
    }

    public Timestamp getAutoRemoveDateTimeValue() {
        return this._persistence_get_autoRemoveDateTimeValue();
    }

    public DateTime getAutoRemoveDateTime() {
        return this._persistence_get_autoRemoveDateTimeValue() == null ? null : new DateTime((Object)this._persistence_get_autoRemoveDateTimeValue());
    }

    public void setAutoRemoveDateTimeValue(Timestamp autoRemoveDateTimeValue) {
        this._persistence_set_autoRemoveDateTimeValue(autoRemoveDateTimeValue);
    }

    public NotificationChannelBo getChannel() {
        return this._persistence_get_channel();
    }

    public void setChannel(NotificationChannelBo channel) {
        this._persistence_set_channel(channel);
    }

    public String getContent() {
        return this._persistence_get_content();
    }

    public void setContent(String content) {
        this._persistence_set_content(content);
    }

    public NotificationContentTypeBo getContentType() {
        return this._persistence_get_contentType();
    }

    public void setContentType(NotificationContentTypeBo contentType) {
        this._persistence_set_contentType(contentType);
    }

    public String getDeliveryType() {
        return this._persistence_get_deliveryType();
    }

    public void setDeliveryType(String deliveryType) {
        this._persistence_set_deliveryType(deliveryType.toUpperCase());
    }

    public Long getId() {
        return this._persistence_get_id();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public NotificationPriorityBo getPriority() {
        return this._persistence_get_priority();
    }

    public void setPriority(NotificationPriorityBo priority) {
        this._persistence_set_priority(priority);
    }

    public NotificationProducerBo getProducer() {
        return this._persistence_get_producer();
    }

    public void setProducer(NotificationProducerBo producer) {
        this._persistence_set_producer(producer);
    }

    public Timestamp getSendDateTimeValue() {
        return this._persistence_get_sendDateTimeValue();
    }

    public DateTime getSendDateTime() {
        return this._persistence_get_sendDateTimeValue() == null ? null : new DateTime((Object)this._persistence_get_sendDateTimeValue());
    }

    public void setSendDateTimeValue(Timestamp sendDateTimeValue) {
        this._persistence_set_sendDateTimeValue(sendDateTimeValue);
    }

    public String getProcessingFlag() {
        return this._persistence_get_processingFlag();
    }

    public void setProcessingFlag(String processingFlag) {
        this._persistence_set_processingFlag(processingFlag);
    }

    @Override
    public Timestamp getLockedDateValue() {
        return this._persistence_get_lockedDateValue();
    }

    public DateTime getLockedDate() {
        return this._persistence_get_lockedDateValue() == null ? null : new DateTime((Object)this._persistence_get_lockedDateValue());
    }

    @Override
    public void setLockedDateValue(Timestamp lockedDateValue) {
        this._persistence_set_lockedDateValue(lockedDateValue);
    }

    public String getTitle() {
        return this._persistence_get_title();
    }

    public void setTitle(String title) {
        this._persistence_set_title(title);
    }

    public String getContentMessage() {
        return StringUtils.substringBetween((String)this._persistence_get_content(), (String)"<message><![CDATA[", (String)"]]></message>");
    }

    public String getDocTypeName() {
        return this._persistence_get_docTypeName();
    }

    public void setDocTypeName(String docTypeName) {
        this._persistence_set_docTypeName(docTypeName);
    }

    public static Notification to(NotificationBo bo) {
        if (bo == null) {
            return null;
        }
        return Notification.Builder.create((NotificationContract)bo).build();
    }

    public static NotificationBo from(Notification im) {
        if (im == null) {
            return null;
        }
        NotificationBo bo = new NotificationBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setDeliveryType(im.getDeliveryType());
        bo.setCreationDateTimeValue(im.getCreationDateTime() == null ? null : new Timestamp(im.getCreationDateTime().getMillis()));
        bo.setSendDateTimeValue(im.getSendDateTime() == null ? null : new Timestamp(im.getSendDateTime().getMillis()));
        bo.setAutoRemoveDateTimeValue(im.getAutoRemoveDateTime() == null ? null : new Timestamp(im.getAutoRemoveDateTime().getMillis()));
        bo.setTitle(im.getTitle());
        bo.setContent(im.getContent());
        bo.setLockedDateValue(im.getLockedDate() == null ? null : new Timestamp(im.getLockedDate().getMillis()));
        bo.setDocTypeName(im.getDocTypeName());
        bo.setPriority(NotificationPriorityBo.from(im.getPriority()));
        bo.setContentType(NotificationContentTypeBo.from(im.getContentType()));
        bo.setChannel(NotificationChannelBo.from(im.getChannel()));
        bo.setProducer(NotificationProducerBo.from(im.getProducer()));
        ArrayList<NotificationRecipientBo> tempRecipients = new ArrayList<NotificationRecipientBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getRecipients())) {
            for (NotificationRecipient recipient : im.getRecipients()) {
                tempRecipients.add(NotificationRecipientBo.from(recipient));
            }
            bo.setRecipients(tempRecipients);
        }
        ArrayList<NotificationSenderBo> tempSenders = new ArrayList<NotificationSenderBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getSenders())) {
            for (NotificationSender sender : im.getSenders()) {
                tempSenders.add(NotificationSenderBo.from(sender));
            }
            bo.setSenders(tempSenders);
        }
        return bo;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NotificationBo(persistenceObject);
    }

    public NotificationBo(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "deliveryType") {
            return this.deliveryType;
        }
        if (string == "channel") {
            return this.channel;
        }
        if (string == "title") {
            return this.title;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "autoRemoveDateTimeValue") {
            return this.autoRemoveDateTimeValue;
        }
        if (string == "content") {
            return this.content;
        }
        if (string == "creationDateTimeValue") {
            return this.creationDateTimeValue;
        }
        if (string == "docTypeName") {
            return this.docTypeName;
        }
        if (string == "recipients") {
            return this.recipients;
        }
        if (string == "processingFlag") {
            return this.processingFlag;
        }
        if (string == "sendDateTimeValue") {
            return this.sendDateTimeValue;
        }
        if (string == "producer") {
            return this.producer;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "contentType") {
            return this.contentType;
        }
        if (string == "senders") {
            return this.senders;
        }
        if (string == "lockedDateValue") {
            return this.lockedDateValue;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "deliveryType") {
            this.deliveryType = (String)object;
            return;
        }
        if (string == "channel") {
            this.channel = (NotificationChannelBo)((Object)object);
            return;
        }
        if (string == "title") {
            this.title = (String)object;
            return;
        }
        if (string == "priority") {
            this.priority = (NotificationPriorityBo)((Object)object);
            return;
        }
        if (string == "autoRemoveDateTimeValue") {
            this.autoRemoveDateTimeValue = (Timestamp)object;
            return;
        }
        if (string == "content") {
            this.content = (String)object;
            return;
        }
        if (string == "creationDateTimeValue") {
            this.creationDateTimeValue = (Timestamp)object;
            return;
        }
        if (string == "docTypeName") {
            this.docTypeName = (String)object;
            return;
        }
        if (string == "recipients") {
            this.recipients = (List)object;
            return;
        }
        if (string == "processingFlag") {
            this.processingFlag = (String)object;
            return;
        }
        if (string == "sendDateTimeValue") {
            this.sendDateTimeValue = (Timestamp)object;
            return;
        }
        if (string == "producer") {
            this.producer = (NotificationProducerBo)((Object)object);
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "contentType") {
            this.contentType = (NotificationContentTypeBo)((Object)object);
            return;
        }
        if (string == "senders") {
            this.senders = (List)object;
            return;
        }
        if (string == "lockedDateValue") {
            this.lockedDateValue = (Timestamp)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_deliveryType() {
        this._persistence_checkFetched("deliveryType");
        return this.deliveryType;
    }

    public void _persistence_set_deliveryType(String string) {
        this._persistence_checkFetchedForSet("deliveryType");
        this._persistence_propertyChange("deliveryType", this.deliveryType, string);
        this.deliveryType = string;
    }

    public NotificationChannelBo _persistence_get_channel() {
        this._persistence_checkFetched("channel");
        return this.channel;
    }

    public void _persistence_set_channel(NotificationChannelBo notificationChannelBo) {
        this._persistence_checkFetchedForSet("channel");
        this._persistence_propertyChange("channel", (Object)this.channel, (Object)notificationChannelBo);
        this.channel = notificationChannelBo;
    }

    public String _persistence_get_title() {
        this._persistence_checkFetched("title");
        return this.title;
    }

    public void _persistence_set_title(String string) {
        this._persistence_checkFetchedForSet("title");
        this._persistence_propertyChange("title", this.title, string);
        this.title = string;
    }

    public NotificationPriorityBo _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(NotificationPriorityBo notificationPriorityBo) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", (Object)this.priority, (Object)notificationPriorityBo);
        this.priority = notificationPriorityBo;
    }

    public Timestamp _persistence_get_autoRemoveDateTimeValue() {
        this._persistence_checkFetched("autoRemoveDateTimeValue");
        return this.autoRemoveDateTimeValue;
    }

    public void _persistence_set_autoRemoveDateTimeValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("autoRemoveDateTimeValue");
        this._persistence_propertyChange("autoRemoveDateTimeValue", this.autoRemoveDateTimeValue, timestamp);
        this.autoRemoveDateTimeValue = timestamp;
    }

    public String _persistence_get_content() {
        this._persistence_checkFetched("content");
        return this.content;
    }

    public void _persistence_set_content(String string) {
        this._persistence_checkFetchedForSet("content");
        this._persistence_propertyChange("content", this.content, string);
        this.content = string;
    }

    public Timestamp _persistence_get_creationDateTimeValue() {
        this._persistence_checkFetched("creationDateTimeValue");
        return this.creationDateTimeValue;
    }

    public void _persistence_set_creationDateTimeValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("creationDateTimeValue");
        this._persistence_propertyChange("creationDateTimeValue", this.creationDateTimeValue, timestamp);
        this.creationDateTimeValue = timestamp;
    }

    public String _persistence_get_docTypeName() {
        this._persistence_checkFetched("docTypeName");
        return this.docTypeName;
    }

    public void _persistence_set_docTypeName(String string) {
        this._persistence_checkFetchedForSet("docTypeName");
        this._persistence_propertyChange("docTypeName", this.docTypeName, string);
        this.docTypeName = string;
    }

    public List _persistence_get_recipients() {
        this._persistence_checkFetched("recipients");
        return this.recipients;
    }

    public void _persistence_set_recipients(List list) {
        this._persistence_checkFetchedForSet("recipients");
        this._persistence_propertyChange("recipients", this.recipients, list);
        this.recipients = list;
    }

    public String _persistence_get_processingFlag() {
        this._persistence_checkFetched("processingFlag");
        return this.processingFlag;
    }

    public void _persistence_set_processingFlag(String string) {
        this._persistence_checkFetchedForSet("processingFlag");
        this._persistence_propertyChange("processingFlag", this.processingFlag, string);
        this.processingFlag = string;
    }

    public Timestamp _persistence_get_sendDateTimeValue() {
        this._persistence_checkFetched("sendDateTimeValue");
        return this.sendDateTimeValue;
    }

    public void _persistence_set_sendDateTimeValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("sendDateTimeValue");
        this._persistence_propertyChange("sendDateTimeValue", this.sendDateTimeValue, timestamp);
        this.sendDateTimeValue = timestamp;
    }

    public NotificationProducerBo _persistence_get_producer() {
        this._persistence_checkFetched("producer");
        return this.producer;
    }

    public void _persistence_set_producer(NotificationProducerBo notificationProducerBo) {
        this._persistence_checkFetchedForSet("producer");
        this._persistence_propertyChange("producer", (Object)this.producer, (Object)notificationProducerBo);
        this.producer = notificationProducerBo;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public NotificationContentTypeBo _persistence_get_contentType() {
        this._persistence_checkFetched("contentType");
        return this.contentType;
    }

    public void _persistence_set_contentType(NotificationContentTypeBo notificationContentTypeBo) {
        this._persistence_checkFetchedForSet("contentType");
        this._persistence_propertyChange("contentType", (Object)this.contentType, (Object)notificationContentTypeBo);
        this.contentType = notificationContentTypeBo;
    }

    public List _persistence_get_senders() {
        this._persistence_checkFetched("senders");
        return this.senders;
    }

    public void _persistence_set_senders(List list) {
        this._persistence_checkFetchedForSet("senders");
        this._persistence_propertyChange("senders", this.senders, list);
        this.senders = list;
    }

    public Timestamp _persistence_get_lockedDateValue() {
        this._persistence_checkFetched("lockedDateValue");
        return this.lockedDateValue;
    }

    public void _persistence_set_lockedDateValue(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("lockedDateValue");
        this._persistence_propertyChange("lockedDateValue", this.lockedDateValue, timestamp);
        this.lockedDateValue = timestamp;
    }
}

