/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.compliance.exemption.ExemptionType;
import org.kuali.coeus.common.framework.compliance.exemption.SpecialReviewExemption;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewExemption;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_SPECIAL_REVIEW")
public class ProposalSpecialReview
extends SpecialReview<ProposalSpecialReviewExemption>
implements HierarchyMaintainable,
ProposalSpecialReviewContract {
    private static final long serialVersionUID = 4616138222389685155L;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @PortableSequenceGenerator(name="SEQ_EPS_PROP_SPECIAL_REVIEW_ID")
    @GeneratedValue(generator="SEQ_EPS_PROP_SPECIAL_REVIEW_ID")
    @Id
    @Column(name="PROPOSAL_SPECIAL_REVIEW_ID")
    private Long id;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @OneToMany(mappedBy="proposalSpecialReview", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalSpecialReviewExemption> specialReviewExemptions;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="PROPOSAL_SPECIAL_REVIEW_ATT_ID", unique=true, nullable=true, insertable=true, updatable=true)
    private ProposalSpecialReviewAttachment specialReviewAttachment;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    @Override
    public ProposalSpecialReviewExemption createSpecialReviewExemption(String exemptionTypeCode) {
        ProposalSpecialReviewExemption proposalSpecialReviewExemption = new ProposalSpecialReviewExemption();
        proposalSpecialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
        proposalSpecialReviewExemption.setProposalSpecialReview(this);
        return proposalSpecialReviewExemption;
    }

    public ProposalSpecialReviewAttachment getSpecialReviewAttachment() {
        return this.specialReviewAttachment;
    }

    public void setSpecialReviewAttachment(ProposalSpecialReviewAttachment specialReviewAttachment) {
        this.specialReviewAttachment = specialReviewAttachment;
    }

    public int hierarchyHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSpecialReviewNumber() == null ? 0 : this.getSpecialReviewNumber().hashCode());
        result = 31 * result + (this.getSpecialReviewTypeCode() == null ? 0 : this.getSpecialReviewTypeCode().hashCode());
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hiddenInHierarchy ? 1231 : 1237);
        result = 31 * result + (this.hierarchyProposalNumber == null ? 0 : this.hierarchyProposalNumber.hashCode());
        result = 31 * result + (this.getDevelopmentProposal() == null || this.getDevelopmentProposal().getProposalNumber() == null ? 0 : this.getDevelopmentProposal().getProposalNumber().hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProposalSpecialReview other = (ProposalSpecialReview)obj;
        if (this.hiddenInHierarchy != other.hiddenInHierarchy) {
            return false;
        }
        if (this.hierarchyProposalNumber == null ? other.hierarchyProposalNumber != null : !this.hierarchyProposalNumber.equals(other.hierarchyProposalNumber)) {
            return false;
        }
        if (this.getDevelopmentProposal() != null && this.getDevelopmentProposal().getProposalNumber() == null ? other.getDevelopmentProposal() == null || other.getDevelopmentProposal().getProposalNumber() != null : this.getDevelopmentProposal() != null && other.getDevelopmentProposal() != null && !this.getDevelopmentProposal().getProposalNumber().equals(other.getDevelopmentProposal().getProposalNumber())) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void resetPersistenceState() {
        this.id = null;
        for (ProposalSpecialReviewExemption exemption : this.getSpecialReviewExemptions()) {
            exemption.setId(null);
            exemption.setProposalSpecialReview(null);
        }
    }

    @Override
    public List<ProposalSpecialReviewExemption> getSpecialReviewExemptions() {
        return this.specialReviewExemptions;
    }

    public String getSpecialReviewExemptionsForDisplay() {
        return CollectionUtils.isEmpty(this.specialReviewExemptions) ? " " : this.specialReviewExemptions.stream().map(SpecialReviewExemption::getExemptionType).map(ExemptionType::getDescription).collect(Collectors.joining(", "));
    }

    @Override
    public void setSpecialReviewExemptions(List<ProposalSpecialReviewExemption> specialReviewExemptions) {
        if (specialReviewExemptions != null) {
            this.specialReviewExemptions = specialReviewExemptions;
        } else {
            this.specialReviewExemptions.clear();
        }
        for (ProposalSpecialReviewExemption proposalSpecialReviewExemption : specialReviewExemptions) {
            proposalSpecialReviewExemption.setProposalSpecialReview(this);
        }
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }
}

