/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAssociate;
import org.kuali.kra.excon.project.ExconProjectEventType;

public class ExconProjectEvent
extends ExconProjectAssociate
implements Comparable<ExconProjectEvent> {
    private static final long serialVersionUID = 1652888833758069217L;
    private Long exconProjectEventId;
    private Long projectId;
    private String projectEventTypeCode;
    private ExconProjectEventType projectEventType;
    private Date eventDate;
    private String eventComment;

    public Long getExconProjectEventId() {
        return this.exconProjectEventId;
    }

    public void setExconProjectEventId(Long exconProjectEventId) {
        this.exconProjectEventId = exconProjectEventId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectEventTypeCode() {
        return this.projectEventTypeCode;
    }

    public void setProjectEventTypeCode(String projectEventTypeCode) {
        this.projectEventTypeCode = projectEventTypeCode;
    }

    public ExconProjectEventType getProjectEventType() {
        if (!StringUtils.isEmpty((CharSequence)this.projectEventTypeCode)) {
            this.refreshReferenceObject("projectEventType");
        }
        return this.projectEventType;
    }

    public void setProjectEventType(ExconProjectEventType projectEventType) {
        this.projectEventType = projectEventType;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventDateStr() {
        return ExconProject.formattedDate(this.eventDate);
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public String getEventComment() {
        return this.eventComment;
    }

    public void setEventComment(String eventComment) {
        this.eventComment = eventComment;
    }

    @Override
    public void resetPersistenceState() {
        this.exconProjectEventId = null;
        this.versionNumber = null;
    }

    @Override
    public int compareTo(ExconProjectEvent exconProjectEventArg) {
        return exconProjectEventArg.getEventDate().compareTo(this.getEventDate());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventComment == null ? 0 : this.eventComment.hashCode());
        result = 31 * result + (this.eventDate == null ? 0 : this.eventDate.hashCode());
        result = 31 * result + (this.exconProjectEventId == null ? 0 : this.exconProjectEventId.hashCode());
        result = 31 * result + (this.projectEventTypeCode == null ? 0 : this.projectEventTypeCode.hashCode());
        result = 31 * result + (this.projectId == null ? 0 : this.projectId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExconProjectEvent other = (ExconProjectEvent)obj;
        return !(this.exconProjectEventId == null ? other.exconProjectEventId != null : !this.exconProjectEventId.equals(other.exconProjectEventId));
    }
}

