/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kew.api.action.ActionTakenContract;
import org.kuali.rice.kew.api.action.ActionType;
import org.w3c.dom.Element;

@XmlRootElement(name="actionTaken")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ActionTakenType", propOrder={"id", "documentId", "principalId", "delegatorPrincipalId", "delegatorGroupId", "actionTakenCode", "actionDate", "annotation", "current", "_futureElements"})
public final class ActionTaken
extends AbstractDataTransferObject
implements ActionTakenContract {
    private static final long serialVersionUID = 8411150332911080837L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="principalId", required=true)
    private final String principalId;
    @XmlElement(name="delegatorPrincipalId", required=false)
    private final String delegatorPrincipalId;
    @XmlElement(name="delegatorGroupId", required=false)
    private final String delegatorGroupId;
    @XmlElement(name="actionTakenCode", required=true)
    private final String actionTakenCode;
    @XmlElement(name="actionDate", required=true)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime actionDate;
    @XmlElement(name="annotation", required=false)
    private final String annotation;
    @XmlElement(name="current", required=true)
    private final boolean current;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ActionTaken() {
        this.id = null;
        this.documentId = null;
        this.principalId = null;
        this.delegatorPrincipalId = null;
        this.delegatorGroupId = null;
        this.actionTakenCode = null;
        this.actionDate = null;
        this.annotation = null;
        this.current = false;
    }

    private ActionTaken(Builder builder) {
        this.annotation = builder.getAnnotation();
        this.id = builder.getId();
        this.documentId = builder.getDocumentId();
        this.principalId = builder.getPrincipalId();
        this.delegatorPrincipalId = builder.getDelegatorPrincipalId();
        this.delegatorGroupId = builder.getDelegatorGroupId();
        this.actionTakenCode = builder.getActionTaken().getCode();
        this.actionDate = builder.getActionDate();
        this.current = builder.isCurrent();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    @Override
    public String getDelegatorPrincipalId() {
        return this.delegatorPrincipalId;
    }

    @Override
    public String getDelegatorGroupId() {
        return this.delegatorGroupId;
    }

    @Override
    public ActionType getActionTaken() {
        return ActionType.fromCode(this.actionTakenCode);
    }

    @Override
    public DateTime getActionDate() {
        return this.actionDate;
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean isCurrent() {
        return this.current;
    }

    static class Elements {
        static final String ID = "id";
        static final String DOCUMENT_ID = "documentId";
        static final String PRINCIPAL_ID = "principalId";
        static final String DELEGATOR_PRINCIPAL_ID = "delegatorPrincipalId";
        static final String DELEGATOR_GROUP_ID = "delegatorGroupId";
        static final String ACTION_TAKEN_CODE = "actionTakenCode";
        static final String ACTION_DATE = "actionDate";
        static final String ANNOTATION = "annotation";
        static final String CURRENT = "current";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "actionTaken";
        static final String TYPE_NAME = "ActionTakenType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ActionTakenContract {
        private static final long serialVersionUID = -1226075070994810756L;
        private String id;
        private String documentId;
        private String principalId;
        private String delegatorPrincipalId;
        private String delegatorGroupId;
        private ActionType actionTaken;
        private DateTime actionDate;
        private String annotation;
        private boolean current;

        private Builder(String id, String documentId, String principalId, ActionType actionTaken) {
            this.setId(id);
            this.setDocumentId(documentId);
            this.setPrincipalId(principalId);
            this.setActionTaken(actionTaken);
            this.setActionDate(new DateTime());
            this.setCurrent(true);
        }

        public static Builder create(String id, String documentId, String principalId, ActionType actionTaken) {
            return new Builder(id, documentId, principalId, actionTaken);
        }

        public static Builder create(ActionTakenContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getId(), contract.getDocumentId(), contract.getPrincipalId(), contract.getActionTaken());
            builder.setDelegatorPrincipalId(contract.getDelegatorPrincipalId());
            builder.setDelegatorGroupId(contract.getDelegatorGroupId());
            builder.setActionDate(contract.getActionDate());
            builder.setAnnotation(contract.getAnnotation());
            builder.setCurrent(contract.isCurrent());
            return builder;
        }

        public ActionTaken build() {
            return new ActionTaken(this);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public String getDelegatorPrincipalId() {
            return this.delegatorPrincipalId;
        }

        @Override
        public String getDelegatorGroupId() {
            return this.delegatorGroupId;
        }

        @Override
        public ActionType getActionTaken() {
            return this.actionTaken;
        }

        @Override
        public DateTime getActionDate() {
            return this.actionDate;
        }

        @Override
        public String getAnnotation() {
            return this.annotation;
        }

        @Override
        public boolean isCurrent() {
            return this.current;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id was blank");
            }
            this.id = id;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setPrincipalId(String principalId) {
            if (StringUtils.isBlank((String)principalId)) {
                throw new IllegalArgumentException("principalId was null or blank");
            }
            this.principalId = principalId;
        }

        public void setDelegatorPrincipalId(String delegatorPrincipalId) {
            this.delegatorPrincipalId = delegatorPrincipalId;
        }

        public void setDelegatorGroupId(String delegatorGroupId) {
            this.delegatorGroupId = delegatorGroupId;
        }

        public void setActionTaken(ActionType actionTaken) {
            if (actionTaken == null) {
                throw new IllegalArgumentException("actionTaken was null");
            }
            this.actionTaken = actionTaken;
        }

        public void setActionDate(DateTime actionDate) {
            if (actionDate == null) {
                throw new IllegalArgumentException("actionDate was null");
            }
            this.actionDate = actionDate;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public void setCurrent(boolean current) {
            this.current = current;
        }
    }
}

