/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeInfoService;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.type.KimTypeAttributesHelper;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class KimDocumentRoleMemberLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private transient UiDocumentService uiDocumentService;
    private transient RoleService roleService;
    private transient KimTypeInfoService kimTypeInfoService;

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        List<Object> searchResults = new ArrayList();
        IdentityManagementRoleDocument roleDocument = (IdentityManagementRoleDocument)((Object)GlobalVariables.getUserSession().retrieveObject("IMRD"));
        if (roleDocument != null) {
            String memberId = fieldValues.get("memberId");
            String string = fieldValues.get("typeCode");
            String memberName = fieldValues.get("memberName");
            String memberNamespaceCode = fieldValues.get("memberNamespaceCode");
            String activeFromDate = fieldValues.get("activeFromDate");
            String activeToDate = fieldValues.get("activeToDate");
            List<KimDocumentRoleMember> currentRoleMembers = roleDocument.getMembers();
            if (currentRoleMembers != null && !currentRoleMembers.isEmpty()) {
                for (KimDocumentRoleMember currentRoleMember : currentRoleMembers) {
                    if (!StringUtils.isEmpty((String)memberId) && (!StringUtils.isNotEmpty((String)memberId) || !memberId.equals(currentRoleMember.getMemberId())) || !StringUtils.isEmpty((String)string) && (!StringUtils.isNotEmpty((String)string) || !string.equals(currentRoleMember.getMemberTypeCode())) || !StringUtils.isEmpty((String)memberName) && (!StringUtils.isNotEmpty((String)memberName) || !memberName.equals(currentRoleMember.getMemberName())) || !StringUtils.isEmpty((String)memberNamespaceCode) && (!StringUtils.isNotEmpty((String)memberNamespaceCode) || !memberNamespaceCode.equals(currentRoleMember.getMemberNamespaceCode())) || !StringUtils.isEmpty((String)activeFromDate) && (!StringUtils.isNotEmpty((String)activeFromDate) || !activeFromDate.equals(currentRoleMember.getActiveFromDate())) || !StringUtils.isEmpty((String)activeToDate) && (!StringUtils.isNotEmpty((String)activeToDate) || !activeToDate.equals(currentRoleMember.getActiveToDate()))) continue;
                    searchResults.add((Object)currentRoleMember);
                }
            }
        } else {
            searchResults = this.getUiDocumentService().getRoleMembers(fieldValues);
        }
        if (searchResults != null) {
            for (KimDocumentRoleMember kimDocumentRoleMember : searchResults) {
                kimDocumentRoleMember.setQualifiersToDisplay(this.getQualifiersToDisplay(kimDocumentRoleMember));
            }
        }
        return searchResults;
    }

    public String getQualifiersToDisplay(KimDocumentRoleMember roleMember) {
        if (roleMember != null && StringUtils.isNotEmpty((String)roleMember.getRoleId()) && roleMember.getQualifiers() != null && !roleMember.getQualifiers().isEmpty()) {
            Role role = this.getRoleService().getRole(roleMember.getRoleId());
            KimType kimType = null;
            if (role != null) {
                kimType = this.getKimTypeInfoService().getKimType(role.getKimTypeId());
            }
            if (kimType != null) {
                KimTypeAttributesHelper attributesHelper = new KimTypeAttributesHelper(kimType);
                StringBuffer attributesToDisplay = new StringBuffer();
                for (KimDocumentRoleQualifier attribute : roleMember.getQualifiers()) {
                    if (attribute.getKimAttribute() == null) continue;
                    KimAttributeField attribDefn = attributesHelper.getAttributeDefinition(attribute.getKimAttribute().getAttributeName());
                    attributesToDisplay.append(attribDefn != null ? attribDefn.getAttributeField().getLongLabel() : "");
                    attributesToDisplay.append(" : ");
                    attributesToDisplay.append(attribute.getAttrVal());
                    attributesToDisplay.append(", ");
                }
                return KimDocumentRoleMemberLookupableHelperServiceImpl.stripEnd(attributesToDisplay.toString(), ", ");
            }
        }
        return "";
    }

    private static String stripEnd(String toStripFrom, String toStrip) {
        String stripped;
        if (toStripFrom == null) {
            return null;
        }
        if (toStrip == null) {
            return toStripFrom;
        }
        if (toStrip.length() > toStripFrom.length()) {
            return toStripFrom;
        }
        if (toStripFrom.endsWith(toStrip)) {
            StringBuffer buffer = new StringBuffer(toStripFrom);
            buffer.delete(buffer.length() - toStrip.length(), buffer.length());
            stripped = buffer.toString();
        } else {
            stripped = toStripFrom;
        }
        return stripped;
    }

    public RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    public KimTypeInfoService getKimTypeInfoService() {
        if (this.kimTypeInfoService == null) {
            this.kimTypeInfoService = KimApiServiceLocator.getKimTypeInfoService();
        }
        return this.kimTypeInfoService;
    }

    public UiDocumentService getUiDocumentService() {
        if (this.uiDocumentService == null) {
            this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
        }
        return this.uiDocumentService;
    }
}

