/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.filter.BufferedResponseWrapper;
import org.displaytag.filter.SimpleServletOutputStream;

public class BufferedResponseWrapper13Impl
extends HttpServletResponseWrapper
implements BufferedResponseWrapper {
    private static Log log = LogFactory.getLog((Class)BufferedResponseWrapper13Impl.class);
    private CharArrayWriter outputWriter = new CharArrayWriter();
    private SimpleServletOutputStream servletOutputStream = new SimpleServletOutputStream();
    private String contentType;
    private boolean state;
    private boolean outRequested;

    public BufferedResponseWrapper13Impl(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String theContentType) {
        if (this.state) {
            log.debug((Object)"Allowing content type");
            if (this.contentType != null && this.contentType.indexOf("charset") > -1) {
                String charset = this.contentType.substring(this.contentType.indexOf("charset"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding charset: [" + charset + "]"));
                }
                this.getResponse().setContentType(StringUtils.substringBefore((String)theContentType, (String)"charset") + '=' + charset);
            } else {
                this.getResponse().setContentType(theContentType);
            }
        }
        this.contentType = theContentType;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug((Object)"getWriter() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getWriter();
        }
        return new PrintWriter(this.outputWriter);
    }

    public void flushBuffer() throws IOException {
        if (this.outputWriter != null) {
            this.outputWriter.flush();
            this.servletOutputStream.outputStream.reset();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.state && !this.outRequested) {
            log.debug((Object)"getOutputStream() returned");
            this.servletOutputStream.reset();
            this.outputWriter.reset();
            this.outRequested = true;
            return ((HttpServletResponse)this.getResponse()).getOutputStream();
        }
        return this.servletOutputStream;
    }

    public void addHeader(String name, String value) {
        if ("6578706f7274".equals(name)) {
            log.debug((Object)"Magic header received, real response is now accessible");
            this.state = true;
        } else if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addHeader(name, value);
        }
    }

    public boolean isOutRequested() {
        return this.outRequested;
    }

    public String getContentAsString() {
        return this.outputWriter.toString() + this.servletOutputStream.toString();
    }

    public void setDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!ArrayUtils.contains((Object[])FILTERED_HEADERS, (Object)StringUtils.lowerCase((String)name))) {
            ((HttpServletResponse)this.getResponse()).addIntHeader(name, value);
        }
    }
}

