/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BreakupIntervalService;
import org.kuali.coeus.common.budget.framework.calculator.ValidCalcType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryEngine;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.GreaterThan;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.NotEquals;
import org.kuali.coeus.common.budget.framework.query.operator.Operator;
import org.kuali.coeus.common.budget.framework.query.operator.Or;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.common.budget.impl.calculator.Boundary;
import org.kuali.coeus.common.budget.impl.calculator.BreakUpInterval;
import org.kuali.coeus.common.budget.impl.calculator.RateAndCost;
import org.kuali.coeus.common.budget.impl.calculator.SalaryCalculator;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.LegacyDataAdapter;

public abstract class AbstractBudgetCalculator {
    public static final String RATE_CLASS_CODE = "rateClassCode";
    public static final String ON_OFF_CAMPUS_FLAG = "onOffCampusFlag";
    public static final String RATE_TYPE_CODE = "rateTypeCode";
    public static final String START_DATE = "startDate";
    public static final String RATE_CLASS = "rateClass";
    public static final String RATE_CLASS_TYPE = "rateClassType";
    public static final String CALCULATED_COST_SHARING = "calculatedCostSharing";
    public static final String ACTIVITY_TYPE_CODE = "activityTypeCode";
    public static final String VALID_CE_RATE_TYPES = "validCeRateTypes";
    public static final String CALCULATED_COST = "calculatedCost";
    private static final Logger LOG = LogManager.getLogger(AbstractBudgetCalculator.class);
    private LegacyDataAdapter legacyDataAdapter;
    private DateTimeService dateTimeService;
    protected Budget budget;
    protected BudgetLineItemBase budgetLineItem;
    private QueryList<BudgetLaRate> lineItemPropLaRates;
    private QueryList<BudgetRate> lineItemPropRates;
    private List<BreakUpInterval> breakupIntervals;
    private QueryList<ValidCeRateType> infltionValidCalcCeRates;
    private QueryList<BudgetRate> underrecoveryRates;
    private QueryList<BudgetRate> inflationRates;
    private ParameterService parameterService;

    public AbstractBudgetCalculator(Budget budget, BudgetLineItemBase budgetLineItem) {
        this.budget = budget;
        this.budgetLineItem = budgetLineItem;
        this.legacyDataAdapter = KcServiceLocator.getService(LegacyDataAdapter.class);
        this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        this.breakupIntervals = new ArrayList<BreakUpInterval>();
    }

    public abstract void populateApplicableCosts(Boundary var1);

    protected abstract void populateBudgetRateBaseList();

    public QueryList filterRates(List rates) {
        if (!rates.isEmpty() && rates.get(0) instanceof BudgetRate) {
            QueryList qList = this.filterRates(rates, this.budgetLineItem.getEndDate(), this.getActivityTypeCodeFromParent());
            if (qList.isEmpty() && !this.budget.getActivityTypeCode().equals(this.getActivityTypeCodeFromParent())) {
                qList = this.filterRates(rates, this.budgetLineItem.getEndDate(), this.budget.getActivityTypeCode());
            }
            return qList;
        }
        return this.filterRates(rates, this.budgetLineItem.getEndDate(), null);
    }

    protected String getActivityTypeCodeFromParent() {
        return this.budget.getBudgetParent().getActivityTypeCode();
    }

    protected QueryList filterRates(List rates, Date lineItemEndDate, String activityTypeCode) {
        List lineItemCalcAmts = this.budgetLineItem.getBudgetCalculatedAmounts();
        QueryList unfilteredRates = new QueryList(rates);
        QueryList budgetProposalRates = new QueryList();
        this.filterBasedOnCalculatedAmounts(lineItemCalcAmts, unfilteredRates, budgetProposalRates);
        if (activityTypeCode != null) {
            this.addInflationRates(activityTypeCode, unfilteredRates, budgetProposalRates);
            this.addUnderrecoveryRates(unfilteredRates, budgetProposalRates);
            budgetProposalRates = budgetProposalRates.filter(new Equals(ACTIVITY_TYPE_CODE, (Comparable)((Object)activityTypeCode)));
        }
        budgetProposalRates = this.filterBasedOnDate(lineItemEndDate, budgetProposalRates);
        return budgetProposalRates;
    }

    protected void filterBasedOnCalculatedAmounts(List<AbstractBudgetCalculatedAmount> lineItemCalcAmts, QueryList unfilteredRates, QueryList budgetProposalRates) {
        for (AbstractBudgetCalculatedAmount calAmtsBean : lineItemCalcAmts) {
            Equals equalsOnOff;
            String rateTypeCode;
            Equals equalsRT;
            String rateClassCode = calAmtsBean.getRateClassCode();
            Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassCode));
            And RCandRT = new And(equalsRC, equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)(rateTypeCode = calAmtsBean.getRateTypeCode()))));
            And RCRTandOnOff = new And(RCandRT, equalsOnOff = new Equals(ON_OFF_CAMPUS_FLAG, this.budgetLineItem.getOnOffCampusFlag()));
            QueryList filteredRates = unfilteredRates.filter(RCRTandOnOff);
            if (filteredRates == null || filteredRates.isEmpty()) continue;
            budgetProposalRates.addAll(unfilteredRates.filter(RCRTandOnOff));
        }
    }

    protected QueryList filterBasedOnDate(Date lineItemEndDate, QueryList budgetProposalRates) {
        if (CollectionUtils.isNotEmpty((Collection)budgetProposalRates)) {
            Or startsBeforeLineItemEndDate = new Or(new LesserThan(START_DATE, lineItemEndDate), new Equals(START_DATE, lineItemEndDate));
            budgetProposalRates = budgetProposalRates.filter(startsBeforeLineItemEndDate);
        }
        return budgetProposalRates;
    }

    protected void addUnderrecoveryRates(QueryList unfilteredRates, QueryList budgetProposalRates) {
        if (!this.isUndercoveryMatchesOverhead()) {
            Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)this.budget.getUrRateClassCode()));
            Equals equalsOnOff = new Equals(ON_OFF_CAMPUS_FLAG, this.budgetLineItem.getOnOffCampusFlag());
            And RCRTandOnOff = new And(equalsRC, equalsOnOff);
            budgetProposalRates.addAll(unfilteredRates.filter(RCRTandOnOff));
        }
    }

    protected void addInflationRates(String activityTypeCode, QueryList unfilteredRates, QueryList budgetProposalRates) {
        if (CollectionUtils.isNotEmpty(this.infltionValidCalcCeRates)) {
            this.infltionValidCalcCeRates.forEach(inflationValidceRate -> {
                Equals eActType;
                Equals equalsOnOff;
                Equals equalsRT;
                Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)inflationValidceRate.getRateClassCode()));
                And RCandRT = new And(equalsRC, equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)inflationValidceRate.getRateTypeCode())));
                And RCRTandOnOff = new And(RCandRT, equalsOnOff = new Equals(ON_OFF_CAMPUS_FLAG, this.budgetLineItem.getOnOffCampusFlag()));
                And RCRTandOnOffandActType = new And(RCRTandOnOff, eActType = new Equals(ACTIVITY_TYPE_CODE, (Comparable)((Object)activityTypeCode)));
                QueryList<BudgetRate> filteredRates = unfilteredRates.filter(RCRTandOnOffandActType);
                if (CollectionUtils.isNotEmpty(filteredRates)) {
                    this.setInflationRates(filteredRates);
                    budgetProposalRates.addAll(filteredRates);
                }
            });
        }
    }

    protected boolean isUndercoveryMatchesOverhead() {
        return this.budget.getOhRateClassCode().equals(this.budget.getUrRateClassCode());
    }

    public void calculate() {
        if (this.isProposalParent()) {
            this.budgetLineItem.setDirectCost(this.budgetLineItem.getLineItemCost());
            this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount());
            this.budgetLineItem.setIndirectCost(ScaleTwoDecimal.ZERO);
            this.populateSalaryIfPersonnel();
            QueryList calcAmts = new QueryList();
            calcAmts.addAll(this.budgetLineItem.getBudgetCalculatedAmounts());
            for (AbstractBudgetCalculatedAmount calcAmt : calcAmts) {
                calcAmt.refreshReferenceObject(RATE_CLASS);
                calcAmt.setRateClassType(calcAmt.getRateClass().getRateClassTypeCode());
            }
            NotEquals notEqualsOH = new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            Equals equalsOH = new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            this.budgetLineItem.setDirectCost((ScaleTwoDecimal)this.budgetLineItem.getDirectCost().add((AbstractDecimal)calcAmts.sumObjects(CALCULATED_COST, notEqualsOH)));
            this.budgetLineItem.setIndirectCost((ScaleTwoDecimal)this.budgetLineItem.getIndirectCost().add((AbstractDecimal)calcAmts.sumObjects(CALCULATED_COST, equalsOH)));
            this.budgetLineItem.setTotalCostSharingAmount((ScaleTwoDecimal)this.budgetLineItem.getTotalCostSharingAmount().add((AbstractDecimal)calcAmts.sumObjects(CALCULATED_COST_SHARING)));
            return;
        }
        this.budgetLineItem.setDirectCost(this.budgetLineItem.getLineItemCost());
        this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount());
        this.budgetLineItem.setIndirectCost(ScaleTwoDecimal.ZERO);
        this.budgetLineItem.setUnderrecoveryAmount(ScaleTwoDecimal.ZERO);
        this.createAndCalculateBreakupIntervals();
        this.updateBudgetLineItemCalculatedAmounts();
        this.populateBudgetRateBaseList();
    }

    protected boolean isProposalParent() {
        return this.budget.getBudgetParent() instanceof DevelopmentProposal && ((DevelopmentProposal)this.budget.getBudgetParent()).isParent();
    }

    protected void populateSalaryIfPersonnel() {
        if (this.budgetLineItem instanceof BudgetPersonnelDetails) {
            BudgetPersonnelDetails budgetPersonnelLineItem = (BudgetPersonnelDetails)this.budgetLineItem;
            SalaryCalculator salaryCalculator = new SalaryCalculator(this.budget, budgetPersonnelLineItem);
            salaryCalculator.calculate();
            budgetPersonnelLineItem.setLineItemCost(budgetPersonnelLineItem.getSalaryRequested());
        }
    }

    protected void updateBudgetLineItemCalculatedAmounts() {
        List lineItemCalcAmts = this.budgetLineItem.getBudgetCalculatedAmounts();
        List<BreakUpInterval> cvLIBreakupIntervals = this.getBreakupIntervals();
        if (lineItemCalcAmts != null && lineItemCalcAmts.size() > 0 && cvLIBreakupIntervals != null && cvLIBreakupIntervals.size() > 0) {
            ScaleTwoDecimal totalCalculatedCostSharing;
            ScaleTwoDecimal directCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal indirectCost = ScaleTwoDecimal.ZERO;
            And RCandRT = null;
            QueryList<RateAndCost> cvCombinedAmtDetails = new QueryList<RateAndCost>();
            for (BreakUpInterval brkUpInterval : cvLIBreakupIntervals) {
                cvCombinedAmtDetails.addAll(brkUpInterval.getRateAndCosts());
            }
            for (AbstractBudgetCalculatedAmount calculatedAmount : lineItemCalcAmts) {
                String rateClassCode = calculatedAmount.getRateClassCode();
                String rateTypeCode = calculatedAmount.getRateTypeCode();
                Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassCode));
                Equals equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateTypeCode));
                RCandRT = new And(equalsRC, equalsRT);
                ScaleTwoDecimal totalCalculatedCost = cvCombinedAmtDetails.sumObjects(CALCULATED_COST, RCandRT);
                calculatedAmount.setCalculatedCost(totalCalculatedCost);
                totalCalculatedCostSharing = cvCombinedAmtDetails.sumObjects(CALCULATED_COST_SHARING, RCandRT);
                calculatedAmount.setCalculatedCostSharing(totalCalculatedCostSharing);
            }
            this.updateLineItemUnderrecovery(cvLIBreakupIntervals, this.budgetLineItem);
            NotEquals notEqualsOH = new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            boolean directCostRolledUp = false;
            boolean resetTotalUnderRecovery = false;
            ScaleTwoDecimal newTotalUrAmount = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal newTotalCostSharing = ScaleTwoDecimal.ZERO;
            if (this.budgetLineItem instanceof BudgetLineItem && CollectionUtils.isNotEmpty(((BudgetLineItem)this.budgetLineItem).getBudgetPersonnelDetailsList())) {
                for (BudgetPersonnelDetails budgetPersonnelDetail : ((BudgetLineItem)this.budgetLineItem).getBudgetPersonnelDetailsList()) {
                    List<BudgetPersonnelCalculatedAmount> personnelCalAmts = budgetPersonnelDetail.getBudgetCalculatedAmounts();
                    newTotalUrAmount = (ScaleTwoDecimal)newTotalUrAmount.add((AbstractDecimal)budgetPersonnelDetail.getUnderrecoveryAmount());
                    resetTotalUnderRecovery = true;
                    if (!CollectionUtils.isNotEmpty(personnelCalAmts)) continue;
                    for (BudgetPersonnelCalculatedAmount personnelCalAmt : personnelCalAmts) {
                        if (personnelCalAmt.getRateClass() == null) {
                            personnelCalAmt.refreshReferenceObject(RATE_CLASS);
                        }
                        if (!personnelCalAmt.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            directCost = (ScaleTwoDecimal)directCost.add((AbstractDecimal)personnelCalAmt.getCalculatedCost());
                        } else {
                            indirectCost = (ScaleTwoDecimal)indirectCost.add((AbstractDecimal)personnelCalAmt.getCalculatedCost());
                        }
                        newTotalCostSharing = (ScaleTwoDecimal)newTotalCostSharing.add((AbstractDecimal)personnelCalAmt.getCalculatedCostSharing());
                        directCostRolledUp = true;
                    }
                }
            }
            if (resetTotalUnderRecovery) {
                this.budgetLineItem.setUnderrecoveryAmount(newTotalUrAmount);
            }
            if (!directCostRolledUp) {
                directCost = cvCombinedAmtDetails.sumObjects(CALCULATED_COST, notEqualsOH);
            }
            this.budgetLineItem.setDirectCost((ScaleTwoDecimal)directCost.add((AbstractDecimal)this.budgetLineItem.getLineItemCost()));
            Equals equalsOH = new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            if (!directCostRolledUp) {
                indirectCost = cvCombinedAmtDetails.sumObjects(CALCULATED_COST, equalsOH);
            }
            this.budgetLineItem.setIndirectCost(indirectCost);
            totalCalculatedCostSharing = !directCostRolledUp ? cvCombinedAmtDetails.sumObjects(CALCULATED_COST_SHARING) : newTotalCostSharing;
            this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount() == null ? totalCalculatedCostSharing : (ScaleTwoDecimal)this.budgetLineItem.getCostSharingAmount().add((AbstractDecimal)totalCalculatedCostSharing));
        } else if (lineItemCalcAmts != null && lineItemCalcAmts.size() > 0 && (this.budgetLineItem.getLineItemCost().equals((Object)ScaleTwoDecimal.ZERO) || CollectionUtils.isEmpty(cvLIBreakupIntervals))) {
            for (AbstractBudgetCalculatedAmount calculatedAmount : lineItemCalcAmts) {
                calculatedAmount.setCalculatedCost(ScaleTwoDecimal.ZERO);
                calculatedAmount.setCalculatedCostSharing(ScaleTwoDecimal.ZERO);
            }
        }
    }

    protected void updateLineItemUnderrecovery(List<BreakUpInterval> cvLIBreakupIntervals, BudgetLineItemBase budgetLineItem) {
        boolean itemHasOverhead = cvLIBreakupIntervals.stream().anyMatch(breakupInterval -> this.doesLineItemHaveOverhead(breakupInterval.getRateAndCosts()));
        if (itemHasOverhead) {
            ScaleTwoDecimal totalUnderRecovery = new QueryList<BreakUpInterval>(cvLIBreakupIntervals).sumObjects("underRecovery");
            budgetLineItem.setUnderrecoveryAmount(totalUnderRecovery);
        }
    }

    protected void createAndCalculateBreakupIntervals() {
        this.populateCalculatedAmountLineItems();
        this.setQlLineItemPropLaRates(this.filterRates(this.getBudgetLaRates()));
        this.setQlLineItemPropRates(this.filterRates(this.getBudgetRates()));
        this.createBreakUpInterval();
        this.calculateBreakUpInterval();
    }

    protected abstract List<BudgetRate> getBudgetRates();

    protected abstract List<BudgetLaRate> getBudgetLaRates();

    protected void createBreakUpInterval() {
        String multipleRatesMesgTemplate;
        String messageTemplate;
        if (this.breakupIntervals == null) {
            this.breakupIntervals = new ArrayList<BreakUpInterval>();
        }
        if (this.budgetLineItem.getOnOffCampusFlag().booleanValue()) {
            messageTemplate = "On-Campus rate information not available for Rate Class - '";
            multipleRatesMesgTemplate = "Multiple On-Campus rates found for the period ";
        } else {
            messageTemplate = "Off-Campus rate information not available for Rate Class - '";
            multipleRatesMesgTemplate = "Multiple Off-Campus rates found for the period ";
        }
        QueryList<BudgetLaRate> lineItemPropLaRates = this.getQlLineItemPropLaRates();
        QueryList<BudgetRate> lineItemPropRates = this.getQlLineItemPropRates();
        QueryList combinedRates = this.combineRates(lineItemPropLaRates, lineItemPropRates);
        List<Boundary> boundaries = this.createBreakupBoundaries(combinedRates, this.budgetLineItem.getStartDate(), this.budgetLineItem.getEndDate());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM-dd-yyyy");
        if (boundaries != null && boundaries.size() > 0) {
            for (Boundary boundary : boundaries) {
                BreakUpInterval breakUpInterval = this.getNewBreakupInterval(boundary);
                QueryList<RateAndCost> rateAndCosts = new QueryList<RateAndCost>();
                QueryList<BudgetRate> breakupPropRates = new QueryList<BudgetRate>();
                QueryList<BudgetLaRate> breakupPropLARates = new QueryList<BudgetLaRate>();
                QueryList multipleRates = new QueryList();
                this.populateApplicableCosts(boundary);
                breakUpInterval.setApplicableAmt(boundary.getApplicableCost());
                breakUpInterval.setApplicableAmtCostSharing(boundary.getApplicableCostSharing());
                List budgetCalculatedAmounts = this.budgetLineItem.getBudgetCalculatedAmounts();
                for (AbstractBudgetCalculatedAmount budgetLineItemCalculatedAmount : budgetCalculatedAmounts) {
                    Boolean applyRateFlag = budgetLineItemCalculatedAmount.getApplyRateFlag();
                    this.refreshRateClass(budgetLineItemCalculatedAmount.getRateClassCode(), budgetLineItemCalculatedAmount);
                    String rateClassType = budgetLineItemCalculatedAmount.getRateClass().getRateClassTypeCode();
                    String message = messageTemplate + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription() + "' for Period - ";
                    if ((applyRateFlag == null || !applyRateFlag.booleanValue()) && !rateClassType.equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    rateAndCosts.add(this.getNewRateCost(rateClassType, budgetLineItemCalculatedAmount.getRateClassCode(), budgetLineItemCalculatedAmount.getRateTypeCode(), applyRateFlag));
                    ArrayList<String> warningMessages = new ArrayList<String>();
                    if (this.isLARate(rateClassType)) {
                        this.breakupLARates(multipleRatesMesgTemplate, message, lineItemPropLaRates, simpleDateFormat, boundary, breakupPropLARates, multipleRates, warningMessages, budgetLineItemCalculatedAmount);
                    } else {
                        multipleRates = this.breakupOtherProposalRates(multipleRatesMesgTemplate, message, lineItemPropRates, simpleDateFormat, boundary, breakupPropRates, multipleRates, warningMessages, budgetLineItemCalculatedAmount);
                    }
                    this.logWarningMessages(warningMessages);
                }
                this.setBreakupIntervalRates(lineItemPropRates, boundary, breakUpInterval, rateAndCosts, breakupPropRates, breakupPropLARates);
            }
        }
    }

    protected QueryList combineRates(QueryList<BudgetLaRate> lineItemPropLaRates, QueryList<BudgetRate> lineItemPropRates) {
        QueryList<AbstractBudgetRate> combinedRates = new QueryList<AbstractBudgetRate>();
        combinedRates.addAll(lineItemPropRates);
        combinedRates.addAll(lineItemPropLaRates);
        combinedRates.sort(START_DATE, true);
        return combinedRates;
    }

    protected void logWarningMessages(List<String> warningMessages) {
        for (String warningMessage : warningMessages) {
            LOG.warn(warningMessage);
        }
    }

    protected void setBreakupIntervalRates(QueryList<BudgetRate> lineItemPropRates, Boundary boundary, BreakUpInterval breakUpInterval, QueryList<RateAndCost> rateAndCosts, QueryList<BudgetRate> breakupPropRates, QueryList<BudgetLaRate> breakupPropLARates) {
        if (CollectionUtils.isNotEmpty(rateAndCosts)) {
            breakUpInterval.setRateAndCosts(rateAndCosts);
            breakUpInterval.setBudgetProposalRates(breakupPropRates);
            breakUpInterval.setBudgetProposalLaRates(breakupPropLARates);
            this.breakupIntervals.add(breakUpInterval);
        }
        this.setUnderrecoveryRateBean(lineItemPropRates, boundary, breakUpInterval);
        this.calculateUnderrecoveryForLineItemsWithoutOverhead(breakUpInterval, rateAndCosts);
    }

    protected void calculateUnderrecoveryForLineItemsWithoutOverhead(BreakUpInterval breakUpInterval, QueryList<RateAndCost> rateAndCosts) {
        if (breakUpInterval.getURRatesBean() != null && (CollectionUtils.isEmpty(rateAndCosts) || !this.doesLineItemHaveOverhead(rateAndCosts))) {
            ScaleTwoDecimal underrecoveryRate = breakUpInterval.getURRatesBean().getApplicableRate();
            ScaleTwoDecimal overheadRate = ScaleTwoDecimal.ZERO;
            underrecoveryRate = (ScaleTwoDecimal)underrecoveryRate.subtract((AbstractDecimal)overheadRate);
            ScaleTwoDecimal underrecoveryAmount = (ScaleTwoDecimal)breakUpInterval.getApplicableAmt().percentage((AbstractDecimal)underrecoveryRate);
            this.budgetLineItem.setUnderrecoveryAmount(underrecoveryAmount);
        }
    }

    protected boolean doesLineItemHaveOverhead(QueryList<RateAndCost> rateAndCosts) {
        return rateAndCosts.stream().anyMatch(rateAndCost -> RateClassType.OVERHEAD.getRateClassType().equalsIgnoreCase(rateAndCost.getRateClassType()));
    }

    public void setUnderrecoveryRateBean(QueryList<BudgetRate> lineItemPropRates, Boundary boundary, BreakUpInterval breakUpInterval) {
        QueryList<ValidCeRateType> underrecoveryRates = this.getUnderrecoveryRateMappedToCostElement(new QueryList<ValidCeRateType>(this.budgetLineItem.getCostElementBO().getValidCeRateTypes()));
        if (!this.isUndercoveryMatchesOverhead()) {
            QueryList filteredUnderrecoveryRates;
            QueryList<BudgetRate> underRecoveryRates;
            this.setEmptyUnderrecoveryRate(breakUpInterval);
            if (!underrecoveryRates.isEmpty() && CollectionUtils.isNotEmpty(underRecoveryRates = this.getUnderrecoveryRatesFromPropRates(lineItemPropRates, underrecoveryRates)) && CollectionUtils.isNotEmpty((Collection)(filteredUnderrecoveryRates = this.filterUnderrecoveryByEndDate(boundary, underRecoveryRates)))) {
                filteredUnderrecoveryRates.sort(START_DATE, false);
                breakUpInterval.setURRatesBean((BudgetRate)filteredUnderrecoveryRates.get(0));
            }
        }
    }

    protected void setEmptyUnderrecoveryRate(BreakUpInterval breakUpInterval) {
        BudgetRate rate = new BudgetRate();
        rate.setInstituteRate(ScaleTwoDecimal.ZERO);
        breakUpInterval.setURRatesBean(rate);
    }

    protected And getRateClassRateTypeAndWithinStartAndEndDateCondition(Boundary boundary, AbstractBudgetCalculatedAmount calculatedAmount) {
        Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)calculatedAmount.getRateClassCode()));
        Equals equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)calculatedAmount.getRateTypeCode()));
        return new And(new And(equalsRC, equalsRT), this.getDateCondition(boundary));
    }

    protected And getRateClassAndRateTypeAndLessThanStartDateCondition(Boundary boundary, AbstractBudgetCalculatedAmount calculatedAmount) {
        Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)calculatedAmount.getRateClassCode()));
        Equals equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)calculatedAmount.getRateTypeCode()));
        return new And(new And(equalsRC, equalsRT), new Or(new LesserThan(START_DATE, boundary.getEndDate()), new Equals(START_DATE, boundary.getEndDate())));
    }

    protected And getDateCondition(Boundary boundary) {
        LesserThan ltEndDate = new LesserThan(START_DATE, boundary.getEndDate());
        Equals equalsEndDate = new Equals(START_DATE, boundary.getEndDate());
        GreaterThan greaterThanStartDate = new GreaterThan(START_DATE, boundary.getStartDate());
        Equals equalToStartDate = new Equals(START_DATE, boundary.getStartDate());
        Or greaterThanOrEqualToStartDate = new Or(greaterThanStartDate, equalToStartDate);
        Or lessThanOrEqualToEndDate = new Or(ltEndDate, equalsEndDate);
        return new And(greaterThanOrEqualToStartDate, lessThanOrEqualToEndDate);
    }

    protected BreakUpInterval getNewBreakupInterval(Boundary boundary) {
        BreakUpInterval breakUpInterval = new BreakUpInterval();
        breakUpInterval.setBoundary(boundary);
        breakUpInterval.setBudgetId(this.budgetLineItem.getBudgetId());
        breakUpInterval.setBudgetPeriod(this.budgetLineItem.getBudgetPeriod());
        breakUpInterval.setLineItemNumber(this.budgetLineItem.getLineItemNumber());
        return breakUpInterval;
    }

    protected void refreshRateClass(String rateClassCode, AbstractBudgetCalculatedAmount budgetLineItemCalculatedAmount) {
        if (budgetLineItemCalculatedAmount.getRateClass() == null && rateClassCode != null) {
            budgetLineItemCalculatedAmount.setRateClass((RateClass)this.getLegacyDataAdapter().findBySinglePrimaryKey(RateClass.class, (Object)rateClassCode));
        }
    }

    protected QueryList filterUnderrecoveryByEndDate(Boundary boundary, QueryList<BudgetRate> underRecoveryRates) {
        LesserThan ltEndDate = new LesserThan(START_DATE, boundary.getEndDate());
        Equals equalsEndDate = new Equals(START_DATE, boundary.getEndDate());
        Or ltEndDateOrEqEndDate = new Or(ltEndDate, equalsEndDate);
        QueryList<BudgetRate> tempRates = underRecoveryRates.filter(ltEndDateOrEqEndDate);
        return tempRates;
    }

    protected QueryList<BudgetRate> getUnderrecoveryRatesFromPropRates(QueryList<BudgetRate> lineItemPropRates, QueryList<ValidCeRateType> underrecoveryRates) {
        Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)underrecoveryRates.get(0).getRateClassCode()));
        Equals equalsOnOff = new Equals(ON_OFF_CAMPUS_FLAG, this.budgetLineItem.getOnOffCampusFlag());
        Equals equalsRT = new Equals(RATE_TYPE_CODE, (Comparable)((Object)underrecoveryRates.get(0).getRateTypeCode()));
        And RCandRT = new And(equalsRC, equalsRT);
        And RCRTandOnOff = new And(RCandRT, equalsOnOff);
        return lineItemPropRates.filter(RCRTandOnOff);
    }

    protected RateAndCost getNewRateCost(String rateClassType, String rateClassCode, String rateTypeCode, Boolean applyRateFlag) {
        RateAndCost rateCost = new RateAndCost();
        rateCost.setApplyRateFlag(applyRateFlag);
        rateCost.setRateClassType(rateClassType);
        rateCost.setRateClassCode(rateClassCode);
        rateCost.setRateTypeCode(rateTypeCode);
        rateCost.setCalculatedCost(ScaleTwoDecimal.ZERO);
        rateCost.setCalculatedCostSharing(ScaleTwoDecimal.ZERO);
        return rateCost;
    }

    protected QueryList breakupOtherProposalRates(String multipleRatesMesgTemplate, String message, QueryList<BudgetRate> lineItemPropRates, SimpleDateFormat simpleDateFormat, Boundary boundary, QueryList<BudgetRate> breakupPropRates, QueryList multipleRates, List<String> warningMessages, AbstractBudgetCalculatedAmount budgetLineItemCalculatedAmount) {
        And RCRTandLtStartDate = this.getRateClassAndRateTypeAndLessThanStartDateCondition(boundary, budgetLineItemCalculatedAmount);
        And RCRTandgtStartDateAndltEndDate = this.getRateClassRateTypeAndWithinStartAndEndDateCondition(boundary, budgetLineItemCalculatedAmount);
        QueryList<BudgetRate> validProposalRates = lineItemPropRates.filter(RCRTandLtStartDate);
        if (CollectionUtils.isNotEmpty(validProposalRates)) {
            multipleRates = lineItemPropRates.filter(RCRTandgtStartDateAndltEndDate);
            if (multipleRates != null && multipleRates.size() > 1) {
                message = multipleRatesMesgTemplate + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate()) + " for Rate Class - '" + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription();
                warningMessages.add((String)message);
            } else {
                validProposalRates.sort(START_DATE, false);
                breakupPropRates.add(validProposalRates.get(0));
            }
        } else {
            message = (String)message + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate());
            warningMessages.add((String)message);
        }
        return multipleRates;
    }

    protected void breakupLARates(String multipleRatesMesgTemplate, String message, QueryList<BudgetLaRate> lineItemPropLaRates, SimpleDateFormat simpleDateFormat, Boundary boundary, QueryList<BudgetLaRate> breakupPropLARates, QueryList multipleRates, List<String> warningMessages, AbstractBudgetCalculatedAmount budgetLineItemCalculatedAmount) {
        And RCRTandLtStartDate = this.getRateClassAndRateTypeAndLessThanStartDateCondition(boundary, budgetLineItemCalculatedAmount);
        QueryList<BudgetLaRate> validLARates = lineItemPropLaRates.filter(RCRTandLtStartDate);
        if (CollectionUtils.isNotEmpty(validLARates)) {
            if (multipleRates != null && multipleRates.size() > 1) {
                message = multipleRatesMesgTemplate + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate()) + " for Rate Class - '" + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription();
                warningMessages.add((String)message);
            } else {
                validLARates.sort(START_DATE, false);
                breakupPropLARates.add(validLARates.get(0));
            }
        } else {
            message = (String)message + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate());
            warningMessages.add((String)message);
        }
    }

    protected boolean isLARate(String rateClassType) {
        return rateClassType.equalsIgnoreCase(RateClassType.LAB_ALLOCATION.getRateClassType()) || rateClassType.equalsIgnoreCase(RateClassType.LA_SALARIES.getRateClassType());
    }

    protected QueryList<ValidCeRateType> getUnderrecoveryRateMappedToCostElement(QueryList<ValidCeRateType> validCeRateTypes) {
        Equals equalsRC = new Equals(RATE_CLASS_CODE, (Comparable)((Object)this.budget.getUrRateClassCode()));
        Equals equalsRCT = new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
        And RCRTandRCT = new And(equalsRC, equalsRCT);
        if (this.budgetLineItem.getCostElementBO() != null && this.budgetLineItem.getCostElementBO().getValidCeRateTypes().isEmpty()) {
            this.budgetLineItem.getCostElementBO().refreshReferenceObject(VALID_CE_RATE_TYPES);
        }
        return validCeRateTypes.filter(RCRTandRCT);
    }

    public String getPersonnelBudgetCategoryTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-B", "Document", "budgetCategoryType.personnel");
    }

    public List<Boundary> createBreakupBoundaries(QueryList<AbstractBudgetRate> qlCombinedRates, Date liStartDate, Date liEndDate) {
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        if (qlCombinedRates != null && qlCombinedRates.size() > 0) {
            Boundary boundary;
            Date tempStartDate = liStartDate;
            GreaterThan greaterThan = new GreaterThan(START_DATE, liStartDate);
            qlCombinedRates = qlCombinedRates.filter(greaterThan);
            qlCombinedRates.sort(START_DATE, true);
            for (AbstractBudgetRate laRate : qlCombinedRates) {
                Date tempEndDate;
                Date rateChangeDate = laRate.getStartDate();
                if (!rateChangeDate.after(tempStartDate)) continue;
                Calendar temEndCal = this.dateTimeService.getCalendar((java.util.Date)rateChangeDate);
                temEndCal.add(5, -1);
                try {
                    tempEndDate = this.dateTimeService.convertToSqlDate(temEndCal.get(1) + "-" + (temEndCal.get(2) + 1) + "-" + temEndCal.get(5));
                }
                catch (ParseException e) {
                    tempEndDate = new Date(rateChangeDate.getTime() - 86400000L);
                }
                Boundary boundary2 = new Boundary(tempStartDate, tempEndDate);
                boundaries.add(boundary2);
                tempStartDate = rateChangeDate;
            }
            if (boundaries.size() > 0) {
                boundary = new Boundary(tempStartDate, liEndDate);
                boundaries.add(boundary);
            }
            if (boundaries.size() == 0) {
                boundary = new Boundary(liStartDate, liEndDate);
                boundaries.add(boundary);
            }
        }
        return boundaries;
    }

    protected void calculateBreakUpInterval() {
        int rateNumber = 0;
        List<BreakUpInterval> cvLIBreakupIntervals = this.getBreakupIntervals();
        for (BreakUpInterval breakUpInterval : cvLIBreakupIntervals) {
            breakUpInterval.setRateNumber(rateNumber);
            this.getBreakupIntervalService().calculate(breakUpInterval);
        }
    }

    protected BreakupIntervalService getBreakupIntervalService() {
        return KcServiceLocator.getService(BreakupIntervalService.class);
    }

    protected List<ValidCalcType> getValidCalcTypes() {
        return (List)this.legacyDataAdapter.findAll(ValidCalcType.class);
    }

    protected abstract void populateCalculatedAmountLineItems();

    protected <T> QueryList<T> createQueryList(List<T> immutableList) {
        if (immutableList == null) {
            return new QueryList();
        }
        return new QueryList<T>(immutableList);
    }

    protected void setInflationRateOnLineItem(BudgetLineItemBase lineItem) {
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        QueryList<ValidCeRateType> inflationValidCeRates = qValidCeRateTypes.filter(new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.INFLATION.getRateClassType())));
        if (!inflationValidCeRates.isEmpty() && lineItem.getApplyInRateFlag().booleanValue()) {
            this.setInfltionValidCalcCeRates(inflationValidCeRates);
        }
    }

    protected Equals equalsOverHeadRateClassType() {
        return new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
    }

    protected NotEquals notEqualsInflationRateClassType() {
        return new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
    }

    protected Equals equalsOverHeadRateClassCode() {
        return new Equals(RATE_CLASS_CODE, (Comparable)((Object)this.budget.getOhRateClassCode()));
    }

    protected NotEquals notEqualsOverHeadRateClassType() {
        return new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
    }

    protected And notEqualsLabAllocationRateClassType() {
        return new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.LAB_ALLOCATION.getRateClassType())).and(new NotEquals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.LA_SALARIES.getRateClassType())));
    }

    protected void setValidCeRateTypeCalculatedAmounts(BudgetLineItemBase lineItem) {
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        qValidCeRateTypes = qValidCeRateTypes.filter(this.equalsOverHeadRateClassType().and(this.equalsOverHeadRateClassCode()).or(this.notEqualsOverHeadRateClassType()).and(this.notEqualsInflationRateClassType()));
        List<BudgetLaRate> budgetLaRates = this.budget.getBudgetLaRates();
        if (budgetLaRates == null || budgetLaRates.size() == 0) {
            qValidCeRateTypes = qValidCeRateTypes.filter(this.notEqualsLabAllocationRateClassType());
        }
        this.addBudgetLineItemCalculatedAmountsForRateTypes(qValidCeRateTypes);
    }

    protected void addBudgetLineItemCalculatedAmountsForRateTypes(List<ValidCeRateType> rateTypes) {
        if (CollectionUtils.isEmpty(rateTypes)) {
            return;
        }
        for (ValidCeRateType validCeRateType : rateTypes) {
            String rateClassType = validCeRateType.getRateClass().getRateClassTypeCode();
            if (rateClassType.equals(RateClassType.OVERHEAD.getRateClassType()) && !this.isProposalBudget()) {
                this.addOHBudgetLineItemCalculatedAmountForAward(validCeRateType.getRateClassCode(), validCeRateType.getRateType(), validCeRateType.getRateClass().getRateClassTypeCode());
                continue;
            }
            this.addBudgetLineItemCalculatedAmount(validCeRateType.getRateClassCode(), validCeRateType.getRateType(), validCeRateType.getRateClass().getRateClassTypeCode());
        }
    }

    protected boolean isProposalBudget() {
        return this.budget.getBudgetParent().isProposalBudget();
    }

    protected void addOHBudgetLineItemCalculatedAmountForAward(String rateClassCode, RateType rateType, String rateClassType) {
        BudgetRate awardBudgetRate = this.budget.getBudgetRates().stream().filter(rate -> StringUtils.equals((CharSequence)rate.getRateClassCode(), (CharSequence)rateClassCode)).filter(rate -> Objects.equals(rate.getOnOffCampusFlag(), this.budgetLineItem.getOnOffCampusFlag())).filter(rate -> StringUtils.equals((CharSequence)rate.getRateTypeCode(), (CharSequence)rateType.getRateTypeCode())).findAny().orElse(null);
        if (awardBudgetRate != null) {
            awardBudgetRate.setBudget(this.budget);
            if (awardBudgetRate.getNonEditableRateFlag()) {
                AbstractBudgetCalculatedAmount budgetCalculatedAmount = this.getNewBudgetCalculatedAmount(rateClassType, awardBudgetRate.getRateClassCode(), awardBudgetRate.getRateTypeCode(), this.getAwardRateTypeDescription(awardBudgetRate.getRateTypeCode()));
                budgetCalculatedAmount.setRateClass(awardBudgetRate.getRateClass());
                this.addCalculatedAmount(budgetCalculatedAmount);
            } else {
                this.addBudgetLineItemCalculatedAmount(rateClassCode, rateType, rateClassType);
            }
        }
    }

    protected AbstractBudgetCalculatedAmount getNewBudgetCalculatedAmount(String rateClassType, String rateClassCode, String rateTypeCode, String rateTypeDescription) {
        AbstractBudgetCalculatedAmount budgetCalculatedAmount = this.getNewCalculatedAmountInstance();
        budgetCalculatedAmount.setBudgetId(this.budgetLineItem.getBudgetId());
        budgetCalculatedAmount.setBudgetPeriod(this.budgetLineItem.getBudgetPeriod());
        budgetCalculatedAmount.setBudgetPeriodId(this.budgetLineItem.getBudgetPeriodId());
        budgetCalculatedAmount.setLineItemNumber(this.budgetLineItem.getLineItemNumber());
        budgetCalculatedAmount.setRateClassType(rateClassType);
        budgetCalculatedAmount.setRateClassCode(rateClassCode);
        budgetCalculatedAmount.setRateTypeCode(rateTypeCode);
        budgetCalculatedAmount.setApplyRateFlag(true);
        budgetCalculatedAmount.setRateTypeDescription(rateTypeDescription);
        return budgetCalculatedAmount;
    }

    protected String getAwardRateTypeDescription(String rateTypeCode) {
        return ((FandaRateType)this.getLegacyDataAdapter().findBySinglePrimaryKey(FandaRateType.class, (Object)rateTypeCode)).getDescription();
    }

    protected Equals equalsEmployeeBenefitsRateClassType() {
        return new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
    }

    protected Equals equalsVacationRateClassType() {
        return new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.VACATION.getRateClassType()));
    }

    protected Equals equalsLabAllocationSalariesRateClassType() {
        return new Equals(RATE_CLASS_TYPE, (Comparable)((Object)RateClassType.LA_SALARIES.getRateClassType()));
    }

    protected void setLabAllocationSalariesCalculatedAmounts(BudgetLineItemBase lineItem) {
        QueryEngine queryEngine = new QueryEngine();
        queryEngine.addDataCollection(ValidCalcType.class, this.getValidCalcTypes());
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        QueryList<ValidCeRateType> qLabAllocSalRates = qValidCeRateTypes.filter(this.equalsLabAllocationSalariesRateClassType());
        if (CollectionUtils.isNotEmpty(qLabAllocSalRates)) {
            ValidCalcType validCalcType;
            QueryList validCalCTypes = queryEngine.executeQuery(ValidCalcType.class, (Operator)this.equalsEmployeeBenefitsRateClassType());
            if (CollectionUtils.isNotEmpty((Collection)validCalCTypes) && (validCalcType = (ValidCalcType)validCalCTypes.get(0)).getDependentRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                this.addBudgetLineItemCalculatedAmount(validCalcType.getRateClassCode(), validCalcType.getRateType(), validCalcType.getRateClassType());
            }
            if (!(validCalCTypes = queryEngine.executeQuery(ValidCalcType.class, (Operator)this.equalsVacationRateClassType())).isEmpty() && (validCalcType = (ValidCalcType)validCalCTypes.get(0)).getDependentRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                this.addBudgetLineItemCalculatedAmount(validCalcType.getRateClassCode(), validCalcType.getRateType(), validCalcType.getRateClassType());
            }
        }
    }

    public final void setCalculatedAmounts(BudgetLineItemBase budgetLineItem) {
        budgetLineItem.getBudgetCalculatedAmounts().clear();
        if (budgetLineItem.getCostElementBO() == null) {
            budgetLineItem.refreshReferenceObject("costElementBO");
        }
        if (budgetLineItem.getCostElementBO().getValidCeRateTypes().isEmpty()) {
            budgetLineItem.getCostElementBO().refreshReferenceObject(VALID_CE_RATE_TYPES);
        }
        this.setInflationRateOnLineItem(budgetLineItem);
        this.setValidCeRateTypeCalculatedAmounts(budgetLineItem);
        this.setLabAllocationSalariesCalculatedAmounts(budgetLineItem);
    }

    protected void setInfltionValidCalcCeRates(QueryList<ValidCeRateType> infltionValidCalcCeRates) {
        this.infltionValidCalcCeRates = infltionValidCalcCeRates;
    }

    protected void addBudgetLineItemCalculatedAmount(String rateClassCode, RateType rateType, String rateClassType) {
        QueryList<BudgetRate> budgetRates = new QueryList<BudgetRate>(this.budget.getBudgetRates());
        QueryList<BudgetLaRate> budgetLaRates = new QueryList<BudgetLaRate>(this.budget.getBudgetLaRates());
        Equals eqValidRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassCode));
        Equals eqValidRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateType.getRateTypeCode()));
        And eqRateClassCodeAndRateTypeCode = new And(eqValidRateClassCode, eqValidRateTypeCode);
        QueryList<BudgetRate> filteredBudgetRates = budgetRates.filter(eqRateClassCodeAndRateTypeCode);
        QueryList<BudgetLaRate> filteredBudgetLaRates = budgetLaRates.filter(eqRateClassCodeAndRateTypeCode);
        if (filteredBudgetRates.isEmpty() && filteredBudgetLaRates.isEmpty()) {
            return;
        }
        AbstractBudgetCalculatedAmount budgetCalculatedAmount = this.getNewBudgetCalculatedAmount(rateClassType, rateClassCode, rateType.getRateTypeCode(), rateType.getDescription());
        budgetCalculatedAmount.refreshReferenceObject(RATE_CLASS);
        this.addCalculatedAmount(budgetCalculatedAmount);
    }

    protected abstract AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance();

    protected abstract void addCalculatedAmount(AbstractBudgetCalculatedAmount var1);

    public LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected List<BreakUpInterval> getBreakupIntervals() {
        return this.breakupIntervals;
    }

    protected void setBreakupIntervals(List<BreakUpInterval> breakupIntervals) {
        this.breakupIntervals = breakupIntervals;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public QueryList<BudgetRate> getUnderrecoveryRates() {
        return this.underrecoveryRates;
    }

    public void setUnderrecoveryRates(QueryList<BudgetRate> underrecoveryRates) {
        this.underrecoveryRates = underrecoveryRates;
    }

    public QueryList<BudgetRate> getInflationRates() {
        return this.inflationRates;
    }

    public void setInflationRates(QueryList<BudgetRate> inflationRates) {
        this.inflationRates = inflationRates;
    }

    public QueryList<BudgetLaRate> getQlLineItemPropLaRates() {
        return this.lineItemPropLaRates;
    }

    public void setQlLineItemPropLaRates(QueryList<BudgetLaRate> qlLineItemPropLaRates) {
        this.lineItemPropLaRates = qlLineItemPropLaRates;
    }

    public QueryList<BudgetRate> getQlLineItemPropRates() {
        return this.lineItemPropRates;
    }

    public void setQlLineItemPropRates(QueryList<BudgetRate> qlLineItemPropRates) {
        this.lineItemPropRates = qlLineItemPropRates;
    }

    protected BudgetRatesService getBudgetRateService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

