/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireAuthorizationService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="questionnaireLookupableHelperService")
@Scope(value="prototype")
public class QuestionnaireLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1800678175555048310L;
    private static final String VIEW = "view";
    private static final String DOCHANDLER_LINK = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    private static final String MAINTENANCE = "maintenance";
    private static final String NEW_MAINTENANCE = "../maintenanceQn";
    private static final String DOC_ROUTE_STATUS = "docRouteStatus";
    private List<MaintenanceDocumentBase> questionnaireMaintenanceDocs;
    private List<MaintenanceDocumentBase> newQuestionnaireDocs;
    private List<String> questionnaireIds;
    private String isActive;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="questionnaireAuthorizationService")
    private QuestionnaireAuthorizationService questionnaireAuthorizationService;
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.isActive = fieldValues.get("isFinal");
        this.getQuestionnaireDocs();
        List searchResults = super.getSearchResults(fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)searchResults)) {
            Collections.sort(searchResults);
            Collections.reverse(searchResults);
        }
        return this.getCurrentVersionQuestionnaires(searchResults);
    }

    private List<? extends BusinessObject> getCurrentVersionQuestionnaires(List<Questionnaire> searchResults) {
        Questionnaire questionnaire;
        List<Questionnaire> questionnaires = org.kuali.coeus.sys.framework.util.CollectionUtils.createCorrectImplementationForCollection(searchResults);
        Integer questionnaireSeqId = 0;
        for (BusinessObject businessObject : searchResults) {
            questionnaire = (Questionnaire)businessObject;
            if (questionnaire.getQuestionnaireSeqIdAsInteger().equals(questionnaireSeqId) || !this.isCurrent(questionnaire)) continue;
            questionnaires.add(questionnaire);
            questionnaireSeqId = questionnaire.getQuestionnaireSeqIdAsInteger();
        }
        for (MaintenanceDocumentBase maintenanceDocumentBase : this.newQuestionnaireDocs) {
            questionnaire = (Questionnaire)maintenanceDocumentBase.getNewMaintainableObject().getDataObject();
            questionnaires.add(questionnaire);
        }
        return questionnaires;
    }

    private boolean isCurrent(Questionnaire questionnaire) {
        Questionnaire currentQnaire = this.getQuestionnaireBySeqId(questionnaire.getQuestionnaireSeqId());
        return questionnaire.getId().equals(currentQnaire.getId());
    }

    protected Questionnaire getQuestionnaireBySeqId(String questionnaireSeqId) {
        Questionnaire questionnaire = null;
        if (questionnaireSeqId != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("questionnaireSeqId", questionnaireSeqId);
            Collection questionnaires = this.getBusinessObjectService().findMatchingOrderBy(Questionnaire.class, fieldValues, "SEQUENCE_NUMBER", false);
            if (questionnaires.size() > 0) {
                questionnaire = (Questionnaire)Collections.max(questionnaires);
            }
        }
        return questionnaire;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        boolean hasViewPermission;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        Questionnaire questionnaire = (Questionnaire)businessObject;
        boolean hasModifyPermission = this.questionnaireAuthorizationService.hasPermission("Modify Questionnaire");
        boolean bl = hasViewPermission = hasModifyPermission || this.questionnaireAuthorizationService.hasPermission("View Questionnaire");
        if (hasModifyPermission && questionnaire.getQuestionnaireSeqId() != null && (CollectionUtils.isEmpty(this.questionnaireIds) || !this.questionnaireIds.contains(questionnaire.getQuestionnaireSeqId()))) {
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "edit", pkNames));
        }
        if (hasModifyPermission && (questionnaire.getQuestionnaireSeqId() == null || !CollectionUtils.isEmpty(this.questionnaireIds) && this.questionnaireIds.contains(questionnaire.getQuestionnaireSeqId()))) {
            HtmlData.AnchorHtmlData htmlData = this.getHtmlData(businessObject, "edit", pkNames);
            String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            htmlData.setHref(String.format(DOCHANDLER_LINK, workflowUrl, this.getDocumentNumber(questionnaire)));
            htmlData.setDisplayText("resume edit");
            htmlDataList.add((HtmlData)htmlData);
        }
        if (hasViewPermission && questionnaire.getQuestionnaireSeqId() != null) {
            htmlDataList.add((HtmlData)this.getViewLink(businessObject, pkNames));
        }
        if (hasModifyPermission && questionnaire.getQuestionnaireSeqId() != null) {
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "copy", pkNames));
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "delete", pkNames));
        }
        return htmlDataList;
    }

    private String getDocumentNumber(Questionnaire questionnaire) {
        String docNumber = null;
        if (questionnaire.getQuestionnaireSeqId() == null) {
            docNumber = questionnaire.getDocumentNumber();
        } else {
            for (MaintenanceDocumentBase doc : this.questionnaireMaintenanceDocs) {
                if (!((Questionnaire)doc.getNewMaintainableObject().getDataObject()).getQuestionnaireSeqId().equals(questionnaire.getQuestionnaireSeqId())) continue;
                docNumber = doc.getDocumentNumber();
            }
        }
        return docNumber;
    }

    protected HtmlData.AnchorHtmlData getViewLink(BusinessObject businessObject, List pkNames) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData = this.getUrlData(businessObject, "edit", pkNames);
        htmlData.setHref(htmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE) + "&readOnly=true");
        htmlData.setDisplayText(VIEW);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getHtmlData(BusinessObject businessObject, String methodToCall, List pkNames) {
        HtmlData.AnchorHtmlData htmlData = this.getUrlData(businessObject, methodToCall, pkNames);
        htmlData.setHref(htmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE));
        return htmlData;
    }

    protected void getQuestionnaireDocs() {
        this.questionnaireMaintenanceDocs = new ArrayList<MaintenanceDocumentBase>();
        this.newQuestionnaireDocs = new ArrayList<MaintenanceDocumentBase>();
        this.questionnaireIds = new ArrayList<String>();
        ArrayList<String> docTypeIds = new ArrayList<String>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        DocumentType documentType = this.getDocumentTypeService().getDocumentTypeByName(this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(Questionnaire.class));
        docTypeIds.add(documentType.getId());
        fieldValues.put("documentTypeId", docTypeIds);
        fieldValues.put(DOC_ROUTE_STATUS, "S");
        List docHeaders = this.getDataObjectService().findMatching(DocumentRouteHeaderValue.class, QueryByCriteria.Builder.andAttributes(fieldValues).build()).getResults();
        try {
            for (DocumentRouteHeaderValue docHeader : docHeaders) {
                MaintenanceDocumentBase doc = (MaintenanceDocumentBase)this.documentService.getByDocumentHeaderId(docHeader.getDocumentId().toString());
                if (doc.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                    this.questionnaireIds.add(((Questionnaire)doc.getNewMaintainableObject().getDataObject()).getQuestionnaireSeqId());
                    this.questionnaireMaintenanceDocs.add(doc);
                    continue;
                }
                if (!doc.getNewMaintainableObject().getMaintenanceAction().equals("New")) continue;
                Questionnaire questionnaire = (Questionnaire)doc.getNewMaintainableObject().getDataObject();
                if (!StringUtils.isBlank((CharSequence)this.isActive) && (!"N".equals(this.isActive) || questionnaire.isActive()) && (!"Y".equals(this.isActive) || !questionnaire.isActive())) continue;
                this.newQuestionnaireDocs.add(doc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setQuestionnaireAuthorizationService(QuestionnaireAuthorizationService questionnaireAuthorizationService) {
        this.questionnaireAuthorizationService = questionnaireAuthorizationService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public QuestionnaireAuthorizationService getQuestionnaireAuthorizationService() {
        return this.questionnaireAuthorizationService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

