/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.lock;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PessimisticLockController {
    private static final Logger LOG = LogManager.getLogger(PessimisticLockController.class);
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Transactional
    @RequestMapping(value={"/sys/pessimisticLock/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deletePessimisticLock(@PathVariable(value="id") String id) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)id) && NumberUtils.isNumber((String)id) && this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "ALLOW_CLEAR_PESSIMISTIC_LOCK").booleanValue()) {
            try {
                this.dataObjectService.deleteMatching(PessimisticLock.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("id", id)).build());
            }
            catch (IllegalArgumentException | DataAccessException e) {
                LOG.warn("Failed to delete pessimistic lock with id: " + id);
            }
        }
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

