/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.sensitive;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.kuali.coeus.sys.framework.sensitive.SensitiveFieldMatcher;
import org.kuali.coeus.sys.impl.sensitive.SensitiveFields;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="sensitiveFieldPatternMatcher")
public class SensitiveFieldPatternMatcherDecorator
implements SensitiveFieldMatcher {
    public static final String REPEAT_NTIMES = "[\\w\\.]*";
    public static final String STAR_CONSTANT = "*";
    private List<Pattern> listOfPatterns = new ArrayList<Pattern>();
    private final SensitiveFieldMatcher matcher;

    @Autowired
    public SensitiveFieldPatternMatcherDecorator(@Qualifier(value="sensitiveFieldSimpleMatcher") SensitiveFieldMatcher matcher, @Qualifier(value="sensitiveFieldResourceLoader") SensitiveFields sensitiveFields) {
        this.matcher = matcher;
        this.compileToPatterns(sensitiveFields.getSensitiveFields());
    }

    private void compileToPatterns(List<String> listOfStrings) {
        for (String regex : listOfStrings) {
            if (!regex.contains(STAR_CONSTANT)) continue;
            this.listOfPatterns.add(Pattern.compile(REPEAT_NTIMES + regex.substring(0, regex.length() - 1) + REPEAT_NTIMES, 2));
        }
    }

    @Override
    public boolean match(String text) {
        if (this.matcher.match(text)) {
            return true;
        }
        for (Pattern pattern : this.listOfPatterns) {
            if (!pattern.matcher(text).matches()) continue;
            return true;
        }
        return false;
    }
}

