/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.service.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.kra.excon.customdata.ExconProjectCustomData;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.kra.excon.service.ExconProjectService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class ExconProjectServiceImpl
implements ExconProjectService {
    private static final String EXCON_PROJECT_ID = "exconProjectId";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;
    private SequenceAccessorService sequenceAccessorService;

    @Override
    public ExconProject getExconProject(Long exconProjectId) {
        return exconProjectId != null ? (ExconProject)this.businessObjectService.findByPrimaryKey(ExconProject.class, Collections.singletonMap(EXCON_PROJECT_ID, exconProjectId)) : null;
    }

    @Override
    public ExconProject getExconProject(String exconProjectId) {
        return exconProjectId != null ? (ExconProject)this.businessObjectService.findByPrimaryKey(ExconProject.class, Collections.singletonMap(EXCON_PROJECT_ID, exconProjectId)) : null;
    }

    @Override
    public String getNextExconProjectNumber() {
        Long nextExconProjectNumber = this.sequenceAccessorService.getNextAvailableSequenceNumber("EXCON_PROJECT_NUMBER_S");
        DecimalFormat formatter = new DecimalFormat("000000");
        return formatter.format(nextExconProjectNumber);
    }

    @Override
    public ExconProjectDocument createNewExconProjectVersion(ExconProjectDocument exconProjectDocument) throws VersionException, WorkflowException {
        ExconProject newVersion = this.getVersioningService().createNewVersion(exconProjectDocument.getExconProject());
        for (ExconProjectAttachment attach : newVersion.getExconProjectAttachments()) {
            ExconProjectAttachment orignalAttachment = this.findMatchingExconProjectAttachment(exconProjectDocument.getExconProject().getExconProjectAttachments(), attach.getFileId());
            attach.setUpdateUser(orignalAttachment.getUpdateUser());
            attach.setUpdateTimestamp(orignalAttachment.getUpdateTimestamp());
            attach.setUpdateUserSet(true);
        }
        this.incrementVersionNumberIfCanceledVersionsExist(newVersion);
        ExconProjectDocument newExconProjectDocument = (ExconProjectDocument)this.getDocumentService().getNewDocument(ExconProjectDocument.class);
        newExconProjectDocument.getDocumentHeader().setDocumentDescription(exconProjectDocument.getDocumentHeader().getDocumentDescription());
        newExconProjectDocument.setExconProject(newVersion);
        newVersion.setExconProjectDocument(newExconProjectDocument);
        this.synchNewCustomAttributes(newVersion, exconProjectDocument.getExconProject());
        return newExconProjectDocument;
    }

    @Override
    public void synchNewCustomAttributes(ExconProject newExconProject, ExconProject oldExconProject) {
        HashSet<Long> availableCustomAttributes = new HashSet<Long>();
        for (ExconProjectCustomData exconProjectCustomData : newExconProject.getExconProjectCustomDataList()) {
            availableCustomAttributes.add(exconProjectCustomData.getCustomAttributeId());
        }
        if (oldExconProject.getExconProjectDocument() != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = oldExconProject.getExconProjectDocument().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                if (availableCustomAttributes.contains(customAttributeDocument.getId())) continue;
                ExconProjectCustomData exconProjectCustomData = new ExconProjectCustomData();
                exconProjectCustomData.setCustomAttributeId(customAttributeDocument.getId());
                exconProjectCustomData.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                exconProjectCustomData.setValue(customAttributeDocument.getCustomAttribute().getDefaultValue());
                exconProjectCustomData.setExconProject(newExconProject);
                newExconProject.getExconProjectCustomDataList().add(exconProjectCustomData);
            }
            newExconProject.getExconProjectCustomDataList().removeAll(this.getInactiveCustomDataList(newExconProject.getExconProjectCustomDataList(), customAttributeDocuments));
        }
    }

    private List<ExconProjectCustomData> getInactiveCustomDataList(List<ExconProjectCustomData> exconProjectCustomDataList, Map<String, CustomAttributeDocument> customAttributeDocuments) {
        ArrayList<ExconProjectCustomData> inactiveCustomDataList = new ArrayList<ExconProjectCustomData>();
        for (ExconProjectCustomData exconProjectCustomData : exconProjectCustomDataList) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(exconProjectCustomData.getCustomAttributeId().toString());
            if (customAttributeDocument != null && customAttributeDocument.isActive()) continue;
            inactiveCustomDataList.add(exconProjectCustomData);
        }
        return inactiveCustomDataList;
    }

    private ExconProjectAttachment findMatchingExconProjectAttachment(List<ExconProjectAttachment> originalExconProjectList, Long currentFileId) throws VersionException {
        for (ExconProjectAttachment attach : originalExconProjectList) {
            if (!attach.getFileId().equals(currentFileId)) continue;
            return attach;
        }
        throw new VersionException("Unable to find matching attachment.");
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(ExconProject exconProject) {
        List versionHistory = (List)this.businessObjectService.findMatching(VersionHistory.class, this.getHashMap(exconProject.getProjectNumber()));
        exconProject.setSequenceNumber(versionHistory.size() + 1);
    }

    protected Map<String, String> getHashMap(String exconProjectNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sequenceOwnerVersionNameValue", exconProjectNumber);
        return map;
    }

    @Override
    public void updateExconProjectSequenceStatus(ExconProject exconProject, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveExconProject(exconProject.getProjectNumber());
        }
        exconProject.setExconProjectSequenceStatus(status.toString());
        if (exconProject.getExconProjectDocument() != null) {
            this.businessObjectService.save((PersistableBusinessObject)exconProject);
        }
    }

    protected void archiveCurrentActiveExconProject(String exconProjectNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("projectNumber", exconProjectNumber);
        values.put("exconProjectSequenceStatus", VersionStatus.ACTIVE.name());
        Collection exconProjects = this.businessObjectService.findMatching(ExconProject.class, values);
        for (ExconProject exconProject : exconProjects) {
            exconProject.setExconProjectSequenceStatus(VersionStatus.ARCHIVED.name());
            exconProject.setAllowUpdateTimestampToBeReset(false);
            this.businessObjectService.save((PersistableBusinessObject)exconProject);
        }
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

