/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.actionlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.actionlist.DefaultCustomActionListAttribute;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionItemCustomization;
import org.kuali.rice.kew.api.action.ActionSet;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.framework.actionlist.ActionListCustomizationHandlerService;

public class ActionListCustomizationHandlerServiceImpl
implements ActionListCustomizationHandlerService {
    private static final Logger LOG = LogManager.getLogger(ActionListCustomizationHandlerServiceImpl.class);
    private DocumentTypeService documentTypeService;

    public List<ActionItemCustomization> customizeActionList(String principalId, List<ActionItem> actionItems) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (actionItems == null) {
            actionItems = Collections.emptyList();
        }
        ArrayList<ActionItemCustomization> actionItemCustomizations = new ArrayList<ActionItemCustomization>(actionItems.size());
        for (ActionItem actionItem : actionItems) {
            DocumentType documentType = this.getDocumentTypeService().findByName(actionItem.getDocName());
            try {
                CustomActionListAttribute customActionListAttribute = null;
                if (documentType != null) {
                    customActionListAttribute = documentType.getCustomActionListAttribute();
                }
                if (customActionListAttribute == null) {
                    customActionListAttribute = this.getDefaultCustomActionListAttribute();
                }
                ActionItemCustomization actionItemCustomization = ActionItemCustomization.Builder.create((String)actionItem.getId(), (ActionSet)customActionListAttribute.getLegalActions(principalId, actionItem), (DisplayParameters)customActionListAttribute.getDocHandlerDisplayParameters(principalId, actionItem)).build();
                actionItemCustomizations.add(actionItemCustomization);
            }
            catch (Exception e) {
                LOG.error("Problem loading custom action list attribute for action item " + actionItem.getId(), (Throwable)e);
            }
        }
        return actionItemCustomizations;
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    private CustomActionListAttribute getDefaultCustomActionListAttribute() {
        return DefaultCustomActionListAttributeHolder.defaultCustomActionListAttribute;
    }

    private static class DefaultCustomActionListAttributeHolder {
        static final CustomActionListAttribute defaultCustomActionListAttribute = new DefaultCustomActionListAttribute();

        private DefaultCustomActionListAttributeHolder() {
        }
    }
}

