/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.AbstractRoleAttribute;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;

public abstract class UnqualifiedRoleAttribute
extends AbstractRoleAttribute {
    private static final long serialVersionUID = -356582375961050905L;
    protected List<RoleName> roles;

    public UnqualifiedRoleAttribute() {
        this.roles = Collections.emptyList();
    }

    public UnqualifiedRoleAttribute(List<RoleName> roles) {
        this.roles = roles;
    }

    @Override
    public List<RoleName> getRoleNames() {
        return this.roles;
    }

    @Override
    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        ArrayList<String> qualifiedRoleName = new ArrayList<String>(1);
        qualifiedRoleName.add(roleName);
        return qualifiedRoleName;
    }

    protected String parseRoleNameFromClassAndRole(String classAndRole) {
        return classAndRole.substring(classAndRole.indexOf("!") + 1);
    }

    protected boolean isValidRoleName(String roleName) {
        boolean valid = false;
        for (RoleName role : this.getRoleNames()) {
            if (!this.parseRoleNameFromClassAndRole(role.getName()).equals(roleName)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @Override
    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRole) {
        if (!roleName.equals(qualifiedRole)) {
            throw new IllegalArgumentException("UnqualifiedRoleAttribute resolveQualifiedRole invoked with differing role and qualified role (they should be the same)");
        }
        if (!this.isValidRoleName(roleName)) {
            throw new IllegalArgumentException("This attribute does not support the role: '" + roleName + "'");
        }
        return this.resolveRole(routeContext, roleName);
    }

    protected abstract ResolvedQualifiedRole resolveRole(RouteContext var1, String var2);
}

