/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.ksb.security.SignatureVerifyingInputStream;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class SignatureVerifyingRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] digitalSignature;
    private Signature signature;

    public SignatureVerifyingRequestWrapper(HttpServletRequest request) {
        super(request);
        String encodedSignature = request.getHeader("KEW_DIGITAL_SIGNATURE");
        if (StringUtils.isEmpty((String)encodedSignature)) {
            throw new RuntimeException("A digital signature was required on the request but none was found.");
        }
        String verificationAlias = request.getHeader("KEW_KEYSTORE_ALIAS");
        String encodedCertificate = request.getHeader("KEW_CERTIFICATE_ALIAS");
        if (StringUtils.isEmpty((String)verificationAlias) && StringUtils.isEmpty((String)encodedCertificate)) {
            throw new RuntimeException("A verification alias or certificate was required on the request but neither was found.");
        }
        try {
            this.digitalSignature = Base64.decodeBase64((byte[])encodedSignature.getBytes("UTF-8"));
            if (StringUtils.isNotBlank((String)encodedCertificate)) {
                byte[] certificate = Base64.decodeBase64((byte[])encodedCertificate.getBytes("UTF-8"));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.signature = KSBServiceLocator.getDigitalSignatureService().getSignatureForVerification(cf.generateCertificate(new ByteArrayInputStream(certificate)));
            } else if (StringUtils.isNotBlank((String)verificationAlias)) {
                this.signature = KSBServiceLocator.getDigitalSignatureService().getSignatureForVerification(verificationAlias);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize digital signature verification.", e);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return new SignatureVerifyingInputStream(this.digitalSignature, this.signature, (InputStream)super.getInputStream());
    }
}

