/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.common.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;

public abstract class AbstractConnectionDaoService
implements ConnectionDaoService {
    private String riceConnectionString;
    private String coeusConnectionString;
    private String riceUser;
    private String coeusUser;
    private String ricePassword;
    private String coeusPassword;
    private static final ThreadLocal<Connection> COEUS_CONNECTIONS = new ThreadLocal();
    private static final ThreadLocal<Connection> RICE_CONNECTIONS = new ThreadLocal();

    public AbstractConnectionDaoService() {
        try {
            Class.forName(this.getDriverClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getDriverClassName();

    @Override
    public Connection getCoeusConnection() {
        Connection c = COEUS_CONNECTIONS.get();
        if (c == null) {
            try {
                c = this.getConnection(this.getCoeusConnectionString(), this.getCoeusUser(), this.getCoeusPassword());
                c.setAutoCommit(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            COEUS_CONNECTIONS.set(c);
        }
        return c;
    }

    @Override
    public Connection getRiceConnection() {
        Connection c = RICE_CONNECTIONS.get();
        if (c == null) {
            try {
                c = this.getConnection(this.getRiceConnectionString(), this.getRiceUser(), this.getRicePassword());
                c.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            RICE_CONNECTIONS.set(c);
        }
        return c;
    }

    private Connection getConnection(String con, String user, String pass) throws SQLException {
        if (user != null && !user.trim().equals("")) {
            return DriverManager.getConnection(con, user, pass);
        }
        return DriverManager.getConnection(con);
    }

    public String getRiceConnectionString() {
        return this.riceConnectionString;
    }

    public void setRiceConnectionString(String riceConnectionString) {
        this.riceConnectionString = riceConnectionString;
    }

    public String getCoeusConnectionString() {
        return this.coeusConnectionString;
    }

    public void setCoeusConnectionString(String coeusConnectionString) {
        this.coeusConnectionString = coeusConnectionString;
    }

    private String getRiceUser() {
        return this.riceUser;
    }

    public void setRiceUser(String riceUser) {
        this.riceUser = riceUser;
    }

    private String getCoeusUser() {
        return this.coeusUser;
    }

    public void setCoeusUser(String coeusUser) {
        this.coeusUser = coeusUser;
    }

    private String getRicePassword() {
        return this.ricePassword;
    }

    public void setRicePassword(String ricePassword) {
        this.ricePassword = ricePassword;
    }

    private String getCoeusPassword() {
        return this.coeusPassword;
    }

    public void setCoeusPassword(String coeusPassword) {
        this.coeusPassword = coeusPassword;
    }
}

