/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.config.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.module.Configurer;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseCompositeLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderContainer;
import org.kuali.rice.core.framework.config.module.WebModuleConfiguration;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.core.framework.resourceloader.RiceResourceLoaderFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class ModuleConfigurer
extends BaseCompositeLifecycle
implements Configurer,
InitializingBean,
DisposableBean,
ServletContextAware {
    private static final String MODULE_CONFIGURERS_CONFIG_KEY = "ModuleConfigurers";
    protected final Logger LOG = LogManager.getLogger(((Object)((Object)this)).getClass());
    private List<RunMode> validRunModes = new ArrayList<RunMode>();
    private Properties properties = new Properties();
    private String moduleName;
    private ServletContext servletContext;

    public static Collection<ModuleConfigurer> getCurrentContextConfigurers() {
        return (Collection)ConfigContext.getCurrentContextConfig().getObject(MODULE_CONFIGURERS_CONFIG_KEY);
    }

    public ModuleConfigurer() {
    }

    public ModuleConfigurer(String moduleName) {
        this.moduleName = moduleName;
    }

    public final void start() throws Exception {
        super.start();
        this.doAdditionalModuleStartLogic();
    }

    protected void doAdditionalModuleStartLogic() throws Exception {
    }

    public final void afterPropertiesSet() throws Exception {
        this.validateConfigurerState();
        this.addToConfig();
        this.initializeResourceLoaders();
        this.start();
    }

    public final void stop() throws Exception {
        try {
            this.doAdditionalModuleStopLogic();
        }
        finally {
            super.stop();
        }
    }

    protected void doAdditionalModuleStopLogic() throws Exception {
    }

    public final void destroy() throws Exception {
        this.stop();
        GlobalResourceLoader.stop();
    }

    public List<Lifecycle> loadLifecycles() throws Exception {
        return Collections.emptyList();
    }

    public RunMode getRunMode() {
        String propertyName = this.getModuleName().toLowerCase() + ".mode";
        String runMode = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
        if (StringUtils.isBlank((String)runMode)) {
            throw new ConfigurationException("Failed to determine run mode for module '" + this.getModuleName() + "'.  Please be sure to set configuration parameter '" + propertyName + "'");
        }
        return RunMode.valueOf((String)runMode.toUpperCase());
    }

    public boolean hasWebInterface() {
        return false;
    }

    public boolean shouldRenderWebInterface() {
        return this.hasWebInterface() && this.getRunMode().equals((Object)RunMode.LOCAL);
    }

    public boolean isExposeServicesOnBus() {
        return Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("rice." + this.getModuleName().toLowerCase() + ".expose.services.on.bus"));
    }

    public List<String> getPrimarySpringFiles() {
        return Collections.singletonList(this.getDefaultSpringBeansPath(this.getDefaultConfigPackagePath()));
    }

    public final WebModuleConfiguration getWebModuleConfiguration() {
        if (this.hasWebInterface()) {
            return this.loadWebModule();
        }
        return null;
    }

    protected WebModuleConfiguration loadWebModule() {
        WebModuleConfiguration webConfig = new WebModuleConfiguration(this.moduleName);
        String files = ConfigContext.getCurrentContextConfig().getProperty("rice." + this.getModuleName() + ".web.additionalSpringFiles");
        webConfig.setAdditionalWebSpringFiles(files == null ? Collections.emptyList() : this.parseFileList(files));
        return webConfig;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List<String> getAdditionalSpringFiles() {
        String files = ConfigContext.getCurrentContextConfig().getProperty("rice." + this.getModuleName() + ".additionalSpringFiles");
        return files == null ? Collections.emptyList() : this.parseFileList(files);
    }

    protected List<String> parseFileList(String files) {
        ArrayList<String> parsedFiles = new ArrayList<String>();
        for (String file : Arrays.asList(files.split(","))) {
            String trimmedFile = file.trim();
            if (trimmedFile.isEmpty()) continue;
            parsedFiles.add(trimmedFile);
        }
        return parsedFiles;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    protected String getDefaultConfigPackagePath() {
        return "classpath:org/kuali/rice/" + this.getModuleName().toLowerCase() + "/config/";
    }

    protected String getDefaultSpringBeansPath(String configPackagePath) {
        return configPackagePath + this.getModuleName().toUpperCase() + "SpringBeans.xml";
    }

    public List<RunMode> getValidRunModes() {
        return this.validRunModes;
    }

    protected void setValidRunModes(List<RunMode> validRunModes) {
        this.validRunModes = validRunModes;
    }

    public final void validateConfigurerState() {
        if (StringUtils.isBlank((String)this.moduleName)) {
            throw new IllegalStateException("the module name for this module has not been set");
        }
        if (CollectionUtils.isEmpty(this.validRunModes)) {
            throw new IllegalStateException("the valid run modes for this module has not been set");
        }
        if (!ConfigContext.isInitialized()) {
            throw new ConfigurationException("ConfigContext has not yet been initialized, please initialize prior to using.");
        }
        this.validateRunMode();
        this.doAdditonalConfigurerValidations();
    }

    private void validateRunMode() {
        if (!this.validRunModes.contains(this.getRunMode())) {
            throw new IllegalArgumentException("Invalid run mode for the " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.getRunMode() + " - Valid Values are: " + this.validRunModes);
        }
    }

    protected void doAdditonalConfigurerValidations() {
    }

    public final void addToConfig() {
        if (this.properties != null) {
            ConfigContext.getCurrentContextConfig().putProperties(this.properties);
        }
        this.registerConfigurerWithConfig();
        this.addAdditonalToConfig();
    }

    protected void addAdditonalToConfig() {
    }

    private void registerConfigurerWithConfig() {
        ArrayList<ModuleConfigurer> configurers = (ArrayList<ModuleConfigurer>)ConfigContext.getCurrentContextConfig().getObject(MODULE_CONFIGURERS_CONFIG_KEY);
        if (configurers == null) {
            configurers = new ArrayList<ModuleConfigurer>();
        }
        configurers.add(this);
        ConfigContext.getCurrentContextConfig().putObject(MODULE_CONFIGURERS_CONFIG_KEY, configurers);
    }

    public final void initializeResourceLoaders() throws Exception {
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.getPrimarySpringFiles());
        files.addAll(this.getAdditionalSpringFiles());
        ResourceLoader rootResourceLoader = GlobalResourceLoader.getResourceLoader();
        if (rootResourceLoader == null) {
            rootResourceLoader = this.createRootResourceLoader();
        }
        if (!files.isEmpty()) {
            ResourceLoader rl = this.createResourceLoader(this.servletContext, files, this.getModuleName());
            rl.start();
            GlobalResourceLoader.addResourceLoader((ResourceLoader)rl);
        }
        Collection<ResourceLoader> rls = this.getResourceLoadersToRegister();
        for (ResourceLoader rl : rls) {
            GlobalResourceLoader.addResourceLoader((ResourceLoader)rl);
        }
    }

    protected ResourceLoader createResourceLoader(ServletContext servletContext, List<String> files, String moduleName) {
        return RiceResourceLoaderFactory.createRootRiceResourceLoader(servletContext, files, this.getModuleName());
    }

    protected Collection<ResourceLoader> getResourceLoadersToRegister() throws Exception {
        return Collections.emptyList();
    }

    private ResourceLoader createRootResourceLoader() throws Exception {
        ResourceLoaderContainer container = new ResourceLoaderContainer(new QName(CoreConfigHelper.getApplicationId(), "RootResourceLoaderContainer"));
        BaseResourceLoader rootResourceLoader = new BaseResourceLoader(new QName(CoreConfigHelper.getApplicationId(), "RootResourceLoader"));
        container.addResourceLoader((ResourceLoader)rootResourceLoader);
        GlobalResourceLoader.addResourceLoader((ResourceLoader)container);
        GlobalResourceLoader.start();
        return container;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }
}

