/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch.configuration.quartz;

import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.kuali.coeus.common.impl.document.ElasticsearchIndexJob;
import org.kuali.coeus.elasticsearch.ElasticsearchEnabledCondition;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.scheduling.KcCronTriggerBean;
import org.kuali.coeus.sys.framework.scheduling.KcCronTriggerService;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={ElasticsearchEnabledCondition.class})
public class ElasticsearchQuartzConfiguration {
    @Bean
    public JobDetail elasticsearchIndexJobDetail() {
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setName("elasticsearchIndexJobDetail");
        jobDetail.setJobClass(ElasticsearchIndexJob.class);
        jobDetail.setDurability(true);
        return jobDetail;
    }

    @Bean
    public CronTriggerFactoryBean elasticsearchIndexJobTrigger(KcCronTriggerService kcCronTriggerService, ParameterService parameterService) {
        KcCronTriggerBean triggerFactory = new KcCronTriggerBean();
        triggerFactory.setJobDetail(this.elasticsearchIndexJobDetail());
        triggerFactory.setKcCronTriggerService(kcCronTriggerService);
        triggerFactory.setParameterService(parameterService);
        triggerFactory.setParameterNamespace("KC-SYS");
        triggerFactory.setParameterComponent("All");
        triggerFactory.setCronExpressionParameterName("Elasticsearch_Index_Job_Cron_Expression");
        triggerFactory.setTriggerEnabledParameterName("Elasticsearch_Index_Job_Enabled");
        triggerFactory.setMisfireSkipParameterName("Elasticsearch_Index_Job_Skip_Misfire");
        return triggerFactory;
    }

    @Bean
    public SchedulerFactoryBean elasticsearchScheduler(@Qualifier(value="dataSource") DataSource dataSource, GlobalVariableService globalVariableService, @Qualifier(value="elasticsearchIndexJobTrigger") Trigger trigger, KewDocHeaderDao kewDocHeaderDao, ConfigurationService configurationService, ElasticsearchIndexService elasticsearchIndexService) {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setSchedulerName("ElasticsearchScheduler");
        schedulerFactory.setAutoStartup(false);
        schedulerFactory.setExposeSchedulerInRepository(true);
        schedulerFactory.setOverwriteExistingJobs(true);
        schedulerFactory.setDataSource(dataSource);
        schedulerFactory.setTriggers(new Trigger[]{trigger});
        HashMap<String, Object> schedulerContext = new HashMap<String, Object>();
        schedulerContext.put("user", configurationService.getPropertyValueAsString("batchJobUserName"));
        schedulerContext.put("elasticsearchIndexService", elasticsearchIndexService);
        schedulerContext.put("globalVariableService", globalVariableService);
        schedulerContext.put("kewDocHeaderDao", kewDocHeaderDao);
        schedulerFactory.setSchedulerContextAsMap(schedulerContext);
        schedulerFactory.setQuartzProperties(this.quartzProperties(configurationService));
        return schedulerFactory;
    }

    private Properties quartzProperties(ConfigurationService configurationService) {
        Properties quartzProperties = new Properties();
        quartzProperties.setProperty("org.quartz.jobStore.tablePrefix", configurationService.getPropertyValueAsString("kcQuartzDatabasePrefix"));
        quartzProperties.setProperty("org.quartz.jobStore.isClustered", configurationService.getPropertyValueAsString("kc.org.quartz.jobStore.isClustered"));
        quartzProperties.setProperty("org.quartz.scheduler.instanceId", configurationService.getPropertyValueAsString("kc.org.quartz.scheduler.instanceId"));
        quartzProperties.setProperty("org.quartz.jobStore.misfireThreshold", configurationService.getPropertyValueAsString("kc.org.quartz.jobStore.misfireThreshold"));
        quartzProperties.setProperty("org.quartz.jobStore.clusterCheckinInterval", configurationService.getPropertyValueAsString("kc.org.quartz.jobStore.clusterCheckinInterval"));
        quartzProperties.setProperty("org.quartz.jobStore.maxMisfiresToHandleAtATime", configurationService.getPropertyValueAsString("kc.org.quartz.jobStore.maxMisfiresToHandleAtATime"));
        return quartzProperties;
    }
}

