/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget;

import java.sql.Date;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNumberOfMonthsService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.stereotype.Component;

@Component(value="proposalBudgetNumberOfMonthsService")
public class ProposalBudgetNumberOfMonthsServiceImpl
implements ProposalBudgetNumberOfMonthsService {
    @Override
    public double getNumberOfMonth(Date startDate, Date endDate) {
        if (startDate == null || endDate == null || startDate.after(endDate)) {
            return 0.0;
        }
        DateTime start = new DateTime((Object)startDate);
        DateTime end = new DateTime((Object)endDate).plusDays(1);
        int daysInMonthForEndDate = end.dayOfMonth().getMaximumValue();
        int wholeMonths = Months.monthsBetween((ReadableInstant)start, (ReadableInstant)end).getMonths();
        int daysRemaining = Days.daysBetween((ReadableInstant)start.plusMonths(wholeMonths), (ReadableInstant)end).getDays();
        double numberOfMonths = (double)wholeMonths + (double)daysRemaining / (double)daysInMonthForEndDate;
        return new ScaleTwoDecimal(numberOfMonths).doubleValue();
    }
}

