/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.framework.attachment.FileMetaKcFileDto;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormAtt;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormFile;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="S2S_USER_ATTACHED_FORM")
public class S2sUserAttachedForm
extends KcPersistableBusinessObjectBase
implements S2sUserAttachedFormContract {
    @PortableSequenceGenerator(name="SEQ_S2S_USER_ATTD_FORM_ID")
    @GeneratedValue(generator="SEQ_S2S_USER_ATTD_FORM_ID")
    @Id
    @Column(name="S2S_USER_ATTACHED_FORM_ID")
    private Long id;
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", insertable=false, updatable=false)
    private DevelopmentProposal developmentProposal;
    @Column(name="NAMESPACE")
    private String namespace;
    @Column(name="FORM_NAME")
    private String formName;
    @Column(name="FORM_FILE_NAME")
    private String formFileName;
    @Column(name="DESCRIPTION")
    private String description;
    @OneToMany(mappedBy="s2sUserAttachedForm", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<S2sUserAttachedFormAtt> s2sUserAttachedFormAtts = new ArrayList<S2sUserAttachedFormAtt>();
    @OneToMany(mappedBy="s2sUserAttachedForm", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<S2sUserAttachedFormFile> s2sUserAttachedFormFileList = new ArrayList<S2sUserAttachedFormFile>();
    @Transient
    private transient boolean edit = false;
    @Transient
    private transient MultipartFile newFormFile;
    @Transient
    private transient byte[] newFormFileBytes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFormFileName() {
        return this.formFileName;
    }

    public void setFormFileName(String formFileName) {
        this.formFileName = formFileName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public MultipartFile getNewFormFile() {
        return this.newFormFile;
    }

    public void setNewFormFile(MultipartFile newFormFile) {
        this.newFormFile = newFormFile;
    }

    public List<S2sUserAttachedFormAtt> getS2sUserAttachedFormAtts() {
        return this.s2sUserAttachedFormAtts;
    }

    public List<FileMetaKcFileDto> getS2sUserAttachedFormAttsFileMetas() {
        return this.getS2sUserAttachedFormAtts().stream().map(att -> {
            FileMetaKcFileDto file = new FileMetaKcFileDto();
            file.setId(String.valueOf(att.getId()));
            file.setData(att.getData());
            file.setName(att.getName());
            file.setType(att.getType());
            file.setDateUploaded(att.getUpdateTimestamp());
            file.setUrl("");
            return file;
        }).collect(Collectors.toList());
    }

    public void setS2sUserAttachedFormAtts(List<S2sUserAttachedFormAtt> s2sUserAttachedFormAtts) {
        this.s2sUserAttachedFormAtts = s2sUserAttachedFormAtts;
    }

    public List<S2sUserAttachedFormFile> getS2sUserAttachedFormFileList() {
        return this.s2sUserAttachedFormFileList;
    }

    public void setS2sUserAttachedFormFileList(List<S2sUserAttachedFormFile> s2sUserAttachedFormFileList) {
        this.s2sUserAttachedFormFileList = s2sUserAttachedFormFileList;
    }

    public byte[] getNewFormFileBytes() {
        return this.newFormFileBytes;
    }

    public void setNewFormFileBytes(byte[] newFormFileBytes) {
        this.newFormFileBytes = newFormFileBytes;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }
}

