/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.dao.impl;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;

public class MessageQueueDaoJpa
implements MessageQueueDAO {
    private static final Logger LOG = LogManager.getLogger(MessageQueueDaoJpa.class);
    private EntityManager entityManager;

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding next " + maxRows + " messages");
        }
        TypedQuery query = this.entityManager.createNamedQuery("PersistedMessageBO.FindAll", PersistedMessageBO.class);
        query.setMaxResults(maxRows);
        return query.getResultList();
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        return (PersistedMessageBO)this.entityManager.find(PersistedMessageBO.class, (Object)routeQueueId);
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(PersistedMessageBO.class);
        Root message = query.from(PersistedMessageBO.class);
        Predicate predicate = builder.conjunction();
        for (Map.Entry<String, String> entry : criteriaValues.entrySet()) {
            predicate = builder.and((Expression)predicate, (Expression)builder.equal((Expression)message.get(entry.getKey()), (Object)entry.getValue()));
        }
        query.where((Expression)predicate);
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        return typedQuery.getResultList();
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        String applicationId = CoreConfigHelper.getApplicationId();
        TypedQuery query = this.entityManager.createNamedQuery("PersistedMessageBO.GetNextDocuments", PersistedMessageBO.class);
        query.setParameter("applicationId", (Object)applicationId);
        query.setParameter("queueStatus", (Object)"E");
        query.setParameter("ipNumber", (Object)RiceUtilities.getIpNumber());
        if (maxDocuments != null) {
            query.setMaxResults(maxDocuments.intValue());
        }
        return query.getResultList();
    }

    @Override
    public void remove(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing message " + routeQueue);
        }
        if (routeQueue.getRouteQueueId() == null) {
            throw new RiceRuntimeException("can't delete a PersistedMessageBO with no id");
        }
        this.evict(routeQueue);
        this.entityManager.remove(this.entityManager.merge((Object)routeQueue));
    }

    @Override
    public PersistedMessageBO save(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting message " + routeQueue);
        }
        routeQueue = (PersistedMessageBO)this.entityManager.merge((Object)routeQueue);
        this.entityManager.flush();
        this.evict(routeQueue);
        return routeQueue;
    }

    private void evict(Object entity) {
        if (this.entityManager.getEntityManagerFactory().getCache() != null) {
            try {
                Object Key2 = this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity);
                if (Key2 != null) {
                    this.entityManager.getEntityManagerFactory().getCache().evict(entity.getClass(), Key2);
                }
            }
            catch (PersistenceException ex) {
                LOG.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

