/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kns.kim.permission.PermissionTypeServiceBase;

public class DocumentTypePermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    protected transient DocumentTypeService documentTypeService;

    protected List<String> getRequiredAttributes() {
        return Collections.singletonList("documentTypeName");
    }

    protected boolean isCheckRequiredAttributes() {
        return true;
    }

    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        HashSet<String> permissionDocTypeNames = new HashSet<String>(permissionsList.size());
        for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)permission);
            String docTypeName = (String)bo.getDetails().get("documentTypeName");
            if (!StringUtils.isNotBlank((String)docTypeName)) continue;
            permissionDocTypeNames.add(docTypeName);
        }
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(requestedDetails.get("documentTypeName"));
        String matchingDocTypeName = this.getClosestParentDocumentTypeName(docType, permissionDocTypeNames);
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission kpi : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)kpi);
            String docTypeName = (String)bo.getDetails().get("documentTypeName");
            if ((!StringUtils.isEmpty((String)matchingDocTypeName) || !StringUtils.equals((String)docTypeName, (String)"*")) && (!StringUtils.isNotEmpty((String)matchingDocTypeName) || !matchingDocTypeName.equals(docTypeName))) continue;
            matchingPermissions.add(kpi);
        }
        return matchingPermissions;
    }

    protected DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }
}

