/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.DirectoryXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.ZipXmlDocCollection;
import org.kuali.rice.kew.batch.XmlPollerService;

public class XmlPollerServiceImpl
implements XmlPollerService {
    private static final Logger LOG = LogManager.getLogger(XmlPollerServiceImpl.class);
    private static final Format DIR_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
    private int pollIntervalSecs = 300;
    private int initialDelaySecs = 30;
    private String xmlPendingLocation;
    private String xmlCompletedLocation;
    private String xmlProblemLocation;
    private String xmlParentDirectory;
    private static final String PENDING_MOVE_FAILED_ARCHIVE_FILE = "movesfailed";
    private static final String NEW_LINE = "\n";

    @Override
    public void run() {
        LOG.debug("checking for xml data files...");
        File[] files = this.getXmlPendingDir().listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        LOG.info("Found " + files.length + " files to ingest.");
        ArrayList<Object> collections = new ArrayList<Object>();
        for (File file : files) {
            if (file.isDirectory()) {
                collections.add(new DirectoryXmlDocCollection(file));
                continue;
            }
            if (file.getName().equals(PENDING_MOVE_FAILED_ARCHIVE_FILE)) continue;
            if (file.getName().toLowerCase().endsWith(".zip")) {
                try {
                    collections.add(new ZipXmlDocCollection(file));
                }
                catch (IOException ioe) {
                    LOG.error("Unable to load file: " + file, (Throwable)ioe);
                }
                continue;
            }
            if (file.getName().endsWith(".xml")) {
                collections.add(new FileXmlDocCollection(file));
                continue;
            }
            LOG.warn("Ignoring extraneous file in xml pending directory: " + file);
        }
        Iterator collectionsIt = collections.iterator();
        ArrayList<XmlDocCollection> culled = new ArrayList<XmlDocCollection>();
        while (collectionsIt.hasNext()) {
            XmlDocCollection container = (XmlDocCollection)collectionsIt.next();
            if (!this.inPendingMoveFailedArchive(container.getFile())) continue;
            LOG.info("Ignoring previously processed resource: " + container);
            culled.add(container);
        }
        collections.removeAll(culled);
        if (collections.size() == 0) {
            LOG.debug("No valid new resources found to ingest");
            return;
        }
        Date LOAD_TIME = Calendar.getInstance().getTime();
        File completeDir = new File(this.getXmlCompleteDir(), DIR_FORMAT.format(LOAD_TIME));
        File failedDir = new File(this.getXmlProblemDir(), DIR_FORMAT.format(LOAD_TIME));
        Collection failed = null;
        try {
            failed = CoreApiServiceLocator.getXmlIngesterService().ingest(collections);
        }
        catch (Exception exception) {
            LOG.error("Error ingesting data", (Throwable)exception);
        }
        LOG.info("Moving files...");
        for (XmlDocCollection xmlDocCollection : collections) {
            LOG.debug("container: " + xmlDocCollection);
            try {
                xmlDocCollection.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing " + xmlDocCollection, (Throwable)ioe);
            }
            if (failed.contains(xmlDocCollection)) {
                if (xmlDocCollection.getFile() == null) continue;
                LOG.error("Moving " + xmlDocCollection.getFile() + " to problem dir.");
                if ((failedDir.isDirectory() || failedDir.mkdirs()) && this.moveFile(failedDir, xmlDocCollection.getFile())) continue;
                LOG.error("Could not move: " + xmlDocCollection.getFile());
                this.recordUnmovablePendingFile(xmlDocCollection.getFile(), LOAD_TIME);
                continue;
            }
            if (xmlDocCollection.getFile() == null) continue;
            LOG.info("Moving " + xmlDocCollection.getFile() + " to loaded dir.");
            if ((completeDir.isDirectory() || completeDir.mkdirs()) && this.moveFile(completeDir, xmlDocCollection.getFile())) continue;
            LOG.error("Could not move: " + xmlDocCollection.getFile());
            this.recordUnmovablePendingFile(xmlDocCollection.getFile(), LOAD_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inPendingMoveFailedArchive(File xmlDataFile) {
        if (xmlDataFile == null) {
            return false;
        }
        BufferedReader inFile = null;
        File movesFailedFile = new File(this.getXmlPendingDir(), PENDING_MOVE_FAILED_ARCHIVE_FILE);
        if (!movesFailedFile.isFile()) {
            return false;
        }
        try {
            String line;
            inFile = new BufferedReader(new FileReader(movesFailedFile));
            while ((line = inFile.readLine()) != null) {
                String trimmedLine = line.trim();
                if (!trimmedLine.equals(xmlDataFile.getName()) && !trimmedLine.startsWith(xmlDataFile.getName() + "=")) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.warn("Error reading file " + movesFailedFile, (Throwable)e);
        }
        finally {
            if (inFile != null) {
                try {
                    inFile.close();
                }
                catch (Exception e) {
                    LOG.warn("Error closing buffered reader for " + movesFailedFile, (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recordUnmovablePendingFile(File unMovablePendingFile, Date dateLoaded) {
        boolean recorded = false;
        OutputStreamWriter archiveFile = null;
        try {
            archiveFile = new FileWriter(new File(this.getXmlPendingDir(), PENDING_MOVE_FAILED_ARCHIVE_FILE), true);
            archiveFile.write(unMovablePendingFile.getName() + "=" + dateLoaded.getTime() + NEW_LINE);
            recorded = true;
        }
        catch (IOException e) {
            LOG.error("Unable to record unmovable pending file " + unMovablePendingFile.getName() + "in the archive file movesfailed", (Throwable)e);
        }
        finally {
            if (archiveFile != null) {
                try {
                    archiveFile.close();
                }
                catch (IOException ioe) {
                    LOG.error("Error closing unmovable pending file", (Throwable)ioe);
                }
            }
        }
        return recorded;
    }

    private boolean moveFile(File toDirectory, File fileToMove) {
        boolean moved = true;
        if (!fileToMove.renameTo(new File(toDirectory.getPath(), fileToMove.getName()))) {
            LOG.error("Unable to move file " + fileToMove.getName() + " to directory " + toDirectory.getPath());
            moved = false;
        }
        return moved;
    }

    private File getXmlPendingDir() {
        return new File(this.getXmlPendingLocation());
    }

    private File getXmlCompleteDir() {
        return new File(this.getXmlCompletedLocation());
    }

    private File getXmlProblemDir() {
        return new File(this.getXmlProblemLocation());
    }

    public String getXmlCompletedLocation() {
        return this.xmlCompletedLocation;
    }

    public void setXmlCompletedLocation(String xmlCompletedLocation) {
        this.xmlCompletedLocation = xmlCompletedLocation;
    }

    public String getXmlPendingLocation() {
        return this.xmlPendingLocation;
    }

    public void setXmlPendingLocation(String xmlPendingLocation) {
        this.xmlPendingLocation = xmlPendingLocation;
    }

    public String getXmlProblemLocation() {
        return this.xmlProblemLocation;
    }

    public void setXmlProblemLocation(String xmlProblemLocation) {
        this.xmlProblemLocation = xmlProblemLocation;
    }

    public String getXmlParentDirectory() {
        return this.xmlParentDirectory;
    }

    public void setXmlParentDirectory(String xmlDataParentDirectory) {
        this.xmlParentDirectory = xmlDataParentDirectory;
    }

    public void setPollIntervalSecs(int seconds) {
        this.pollIntervalSecs = seconds;
    }

    @Override
    public int getPollIntervalSecs() {
        return this.pollIntervalSecs;
    }

    public void setInitialDelaySecs(int seconds) {
        this.initialDelaySecs = seconds;
    }

    @Override
    public int getInitialDelaySecs() {
        return this.initialDelaySecs;
    }
}

