/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class SubAwardFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            SubAwardDocument subAwardDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, subAwardDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        SubAward subAward = subAwardDocument.getSubAward();
        this.addSubAwardFacts(factsBuilder, subAward);
    }

    private void addSubAwardFacts(Facts.Builder factsBuilder, SubAward subAward) {
        this.addObjectMembersAsFacts(factsBuilder, subAward, "KC-SUBAWARD-CONTEXT", "KC-SUBAWARD");
        factsBuilder.addFact("SubAward", (Object)subAward);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

