/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.OTFAdvancedTypographicTableReader;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OFTableName;
import org.apache.fop.fonts.truetype.OTFFile;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

public abstract class OpenFont {
    static final byte NTABS = 24;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    private static final String[] MAC_GLYPH_ORDERING = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    protected FontFileReader fontFile;
    public static final boolean TRACE_ENABLED = false;
    private static final String ENCODING = "WinAnsiEncoding";
    private static final short FIRST_CHAR = 0;
    protected boolean useKerning;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map<OFTableName, OFDirTabEntry> dirTabs;
    private Map<Integer, Map<Integer, Integer>> kerningTab;
    private Map<Integer, Map<Integer, Integer>> ansiKerningTab;
    private List<CMapSegment> cmaps;
    protected List<UnicodeMapping> unicodeMappings;
    private int upem;
    protected int nhmtx;
    private PostScriptVersion postScriptVersion;
    protected int locaFormat;
    protected long lastLoca;
    protected int numberOfGlyphs;
    protected OFMtxEntry[] mtxTab;
    protected String postScriptName = "";
    protected String fullName = "";
    protected String embedFontName = "";
    protected String notice = "";
    protected final Set<String> familyNames = new HashSet<String>();
    protected String subFamilyName = "";
    protected boolean cid = true;
    private long italicAngle;
    private long isFixedPitch;
    private int fontBBox1;
    private int fontBBox2;
    private int fontBBox3;
    private int fontBBox4;
    private int capHeight;
    private int os2CapHeight;
    private int underlinePosition;
    private int underlineThickness;
    private int strikeoutPosition;
    private int strikeoutThickness;
    private int xHeight;
    private int os2xHeight;
    private int ascender;
    private int descender;
    private int hheaAscender;
    private int hheaDescender;
    private int os2Ascender;
    private int os2Descender;
    private int usWeightClass;
    private short lastChar;
    private int[] ansiWidth;
    private Map<Integer, List<Integer>> ansiIndex;
    private final Map<Integer, Integer> glyphToUnicodeMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> unicodeToGlyphMap = new HashMap<Integer, Integer>();
    private boolean isCFF;
    protected boolean useAdvanced;
    protected OTFAdvancedTypographicTableReader advancedTableReader;
    protected Log log = LogFactory.getLog(TTFFile.class);

    public OpenFont() {
        this(true, false);
    }

    public OpenFont(boolean useKerning, boolean useAdvanced) {
        this.useKerning = useKerning;
        this.useAdvanced = useAdvanced;
    }

    public OFDirTabEntry getDirectoryEntry(OFTableName name) {
        return this.dirTabs.get(name);
    }

    public boolean seekTab(FontFileReader in, OFTableName tableName, long offset) throws IOException {
        OFDirTabEntry dt = this.dirTabs.get(tableName);
        if (dt == null) {
            this.log.info((Object)("Dirtab " + tableName.getName() + " not found."));
            return false;
        }
        in.seekSet(dt.getOffset() + offset);
        return true;
    }

    public int convertTTFUnit2PDFUnit(int n) {
        int ret;
        if (n < 0) {
            long rest1 = n % this.upem;
            long storrest = 1000L * rest1;
            long ledd2 = storrest != 0L ? rest1 / storrest : 0L;
            ret = -(-1000 * n / this.upem - (int)ledd2);
        } else {
            ret = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return ret;
    }

    protected boolean readCMAP() throws IOException {
        this.unicodeMappings = new ArrayList<UnicodeMapping>();
        if (!this.seekTab(this.fontFile, OFTableName.CMAP, 2L)) {
            return true;
        }
        int numCMap = this.fontFile.readTTFUShort();
        long cmapUniOffset = 0L;
        long symbolMapOffset = 0L;
        long surrogateMapOffset = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(numCMap + " cmap tables"));
        }
        for (int i = 0; i < numCMap; ++i) {
            int cmapPID = this.fontFile.readTTFUShort();
            int cmapEID = this.fontFile.readTTFUShort();
            long cmapOffset = this.fontFile.readTTFLong();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Platform ID: " + cmapPID + " Encoding: " + cmapEID));
            }
            if (cmapPID == 3 && cmapEID == 1) {
                cmapUniOffset = cmapOffset;
            }
            if (cmapPID == 3 && cmapEID == 0) {
                symbolMapOffset = cmapOffset;
            }
            if (cmapPID != 3 || cmapEID != 10) continue;
            surrogateMapOffset = cmapOffset;
        }
        if (surrogateMapOffset > 0L) {
            return this.readUnicodeCmap(surrogateMapOffset, 10);
        }
        if (cmapUniOffset > 0L) {
            return this.readUnicodeCmap(cmapUniOffset, 1);
        }
        if (symbolMapOffset > 0L) {
            return this.readUnicodeCmap(symbolMapOffset, 0);
        }
        this.log.fatal((Object)"Unsupported TrueType font: No Unicode or Symbol cmap table not present. Aborting");
        return false;
    }

    private boolean readUnicodeCmap(long cmapUniOffset, int encodingID) throws IOException {
        int mtxPtr = 0;
        this.seekTab(this.fontFile, OFTableName.CMAP, cmapUniOffset);
        int cmapFormat = this.fontFile.readTTFUShort();
        if (cmapFormat < 8) {
            this.fontFile.readTTFUShort();
            this.fontFile.readTTFUShort();
        } else {
            this.fontFile.readTTFUShort();
            this.fontFile.readTTFULong();
            this.fontFile.readTTFULong();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CMAP format: " + cmapFormat));
        }
        if (cmapFormat == 4) {
            int i;
            int cmapSegCountX2 = this.fontFile.readTTFUShort();
            int cmapSearchRange = this.fontFile.readTTFUShort();
            int cmapEntrySelector = this.fontFile.readTTFUShort();
            int cmapRangeShift = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("segCountX2   : " + cmapSegCountX2));
                this.log.debug((Object)("searchRange  : " + cmapSearchRange));
                this.log.debug((Object)("entrySelector: " + cmapEntrySelector));
                this.log.debug((Object)("rangeShift   : " + cmapRangeShift));
            }
            int[] cmapEndCounts = new int[cmapSegCountX2 / 2];
            int[] cmapStartCounts = new int[cmapSegCountX2 / 2];
            int[] cmapDeltas = new int[cmapSegCountX2 / 2];
            int[] cmapRangeOffsets = new int[cmapSegCountX2 / 2];
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapEndCounts[i] = this.fontFile.readTTFUShort();
            }
            this.fontFile.skip(2L);
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapStartCounts[i] = this.fontFile.readTTFUShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapDeltas[i] = this.fontFile.readTTFShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapRangeOffsets[i] = this.fontFile.readTTFUShort();
            }
            int glyphIdArrayOffset = this.fontFile.getCurrentPos();
            BitSet eightBitGlyphs = new BitSet(256);
            for (int i2 = 0; i2 < cmapStartCounts.length; ++i2) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(i2 + ": " + cmapStartCounts[i2] + " - " + cmapEndCounts[i2]));
                }
                if (this.log.isDebugEnabled() && this.isInPrivateUseArea(cmapStartCounts[i2], cmapEndCounts[i2])) {
                    this.log.debug((Object)("Font contains glyphs in the Unicode private use area: " + Integer.toHexString(cmapStartCounts[i2]) + " - " + Integer.toHexString(cmapEndCounts[i2])));
                }
                for (int j = cmapStartCounts[i2]; j <= cmapEndCounts[i2]; ++j) {
                    Object v;
                    int glyphIdx;
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (j < 256) {
                        eightBitGlyphs.set(j);
                    }
                    if (mtxPtr >= this.mtxTab.length) continue;
                    if (cmapRangeOffsets[i2] != 0 && j != 65535) {
                        int mapped;
                        int glyphOffset = glyphIdArrayOffset + (cmapRangeOffsets[i2] / 2 + (j - cmapStartCounts[i2]) + i2 - cmapSegCountX2 / 2) * 2;
                        this.fontFile.seekSet(glyphOffset);
                        glyphIdx = this.fontFile.readTTFUShort() + cmapDeltas[i2] & 0xFFFF;
                        this.unicodeMappings.add(new UnicodeMapping(this, glyphIdx, j));
                        this.mtxTab[glyphIdx].getUnicodeIndex().add(j);
                        if (encodingID == 0 && j >= 61472 && j <= 61695 && !eightBitGlyphs.get(mapped = j - 61440)) {
                            this.unicodeMappings.add(new UnicodeMapping(this, glyphIdx, mapped));
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(mapped);
                        }
                        if ((v = this.ansiIndex.get(j)) != null) {
                            Iterator iterator = v.iterator();
                            while (iterator.hasNext()) {
                                Integer aIdx = (Integer)iterator.next();
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                                if (!this.log.isTraceEnabled()) continue;
                                this.log.trace((Object)("Added width " + this.mtxTab[glyphIdx].getWx() + " uni: " + j + " ansi: " + aIdx));
                            }
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Idx: " + glyphIdx + " Delta: " + cmapDeltas[i2] + " Unicode: " + j + " name: " + this.mtxTab[glyphIdx].getName()));
                        }
                    } else {
                        glyphIdx = j + cmapDeltas[i2] & 0xFFFF;
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(j);
                        } else {
                            this.log.debug((Object)("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length));
                        }
                        this.unicodeMappings.add(new UnicodeMapping(this, glyphIdx, j));
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(j);
                        } else {
                            this.log.debug((Object)("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length));
                        }
                        List<Integer> v2 = this.ansiIndex.get(j);
                        if (v2 != null) {
                            v = v2.iterator();
                            while (v.hasNext()) {
                                Integer aIdx = v.next();
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                            }
                        }
                    }
                    if (glyphIdx >= this.mtxTab.length || this.mtxTab[glyphIdx].getUnicodeIndex().size() >= 2) continue;
                    ++mtxPtr;
                }
            }
        } else if (cmapFormat == 12) {
            long nGroups = this.fontFile.readTTFULong();
            block8: for (long i = 0L; i < nGroups; ++i) {
                long startCharCode = this.fontFile.readTTFULong();
                long endCharCode = this.fontFile.readTTFULong();
                long startGlyphCode = this.fontFile.readTTFULong();
                if (startCharCode < 0L || startCharCode > 0x10FFFFL) {
                    this.log.warn((Object)"startCharCode outside Unicode range");
                    continue;
                }
                if (startCharCode >= 55296L && startCharCode <= 57343L) {
                    this.log.warn((Object)("startCharCode is a surrogate pair: " + startCharCode));
                }
                if (endCharCode > 0L && endCharCode < startCharCode || endCharCode > 0x10FFFFL) {
                    this.log.warn((Object)"startCharCode outside Unicode range");
                    continue;
                }
                if (endCharCode >= 55296L && endCharCode <= 57343L) {
                    this.log.warn((Object)("endCharCode is a surrogate pair: " + startCharCode));
                }
                for (long offset = 0L; offset <= endCharCode - startCharCode; ++offset) {
                    long glyphIndexL = startGlyphCode + offset;
                    long charCodeL = startCharCode + offset;
                    if (glyphIndexL >= (long)this.numberOfGlyphs) {
                        this.log.warn((Object)"Format 12 cmap contains an invalid glyph index");
                        continue block8;
                    }
                    if (charCodeL > 0x10FFFFL) {
                        this.log.warn((Object)"Format 12 cmap contains character beyond UCS-4");
                    }
                    if (glyphIndexL > Integer.MAX_VALUE) {
                        this.log.error((Object)"glyphIndex > Integer.MAX_VALUE");
                        continue;
                    }
                    if (charCodeL > Integer.MAX_VALUE) {
                        this.log.error((Object)"startCharCode + j > Integer.MAX_VALUE");
                        continue;
                    }
                    if (charCodeL < 255L && charCodeL > (long)this.lastChar) {
                        this.lastChar = (short)charCodeL;
                    }
                    int charCode = (int)charCodeL;
                    int glyphIndex = (int)glyphIndexL;
                    List<Integer> ansiIndexes = null;
                    if (charCodeL <= 65535L) {
                        ansiIndexes = this.ansiIndex.get((int)charCodeL);
                    }
                    this.unicodeMappings.add(new UnicodeMapping(this, glyphIndex, charCode));
                    this.mtxTab[glyphIndex].getUnicodeIndex().add(charCode);
                    if (ansiIndexes == null) continue;
                    for (Integer aIdx : ansiIndexes) {
                        this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIndex].getWx();
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)("Added width " + this.mtxTab[glyphIndex].getWx() + " uni: " + offset + " ansi: " + aIdx));
                    }
                }
            }
        } else {
            this.log.error((Object)("Cmap format not supported: " + cmapFormat));
            return false;
        }
        return true;
    }

    private boolean isInPrivateUseArea(int start, int end) {
        return this.isInPrivateUseArea(start) || this.isInPrivateUseArea(end);
    }

    private boolean isInPrivateUseArea(int unicode) {
        return unicode >= 57344 && unicode <= 63743;
    }

    public List<OFMtxEntry> getMtx() {
        return Collections.unmodifiableList(Arrays.asList(this.mtxTab));
    }

    public void readFont(FontFileReader in, String header) throws IOException {
        this.readFont(in, header, (String)null);
    }

    protected void initAnsiWidths() {
        int i;
        this.ansiWidth = new int[256];
        for (i = 0; i < 256; ++i) {
            this.ansiWidth[i] = this.mtxTab[0].getWx();
        }
        this.ansiIndex = new HashMap<Integer, List<Integer>>();
        for (i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            Integer ansi = i;
            Integer uni = Glyphs.WINANSI_ENCODING[i];
            List<Integer> v = this.ansiIndex.get(uni);
            if (v == null) {
                v = new ArrayList<Integer>();
                this.ansiIndex.put(uni, v);
            }
            v.add(ansi);
        }
    }

    public boolean readFont(FontFileReader in, String header, String name) throws IOException {
        this.initializeFont(in);
        if (!this.checkTTC(header, name)) {
            if (name == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + name);
        }
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Number of glyphs in font: " + this.numberOfGlyphs));
        }
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.initAnsiWidths();
        this.readPostScript();
        this.readOS2();
        this.determineAscDesc();
        this.readName();
        boolean pcltFound = this.readPCLT();
        boolean valid = this.readCMAP();
        if (!valid) {
            return false;
        }
        this.createCMaps();
        this.updateBBoxAndOffset();
        if (this.useKerning) {
            this.readKerning();
        }
        this.handleCharacterSpacing(in);
        this.guessVerticalMetricsFromGlyphBBox();
        return true;
    }

    public void readFont(FontFileReader in, String header, MultiByteFont mbfont) throws IOException {
        this.readFont(in, header, mbfont.getTTCName());
    }

    protected abstract void updateBBoxAndOffset() throws IOException;

    protected abstract void readName() throws IOException;

    protected abstract void initializeFont(FontFileReader var1) throws IOException;

    protected void handleCharacterSpacing(FontFileReader in) throws IOException {
        if (this.useAdvanced) {
            try {
                OTFAdvancedTypographicTableReader atr = new OTFAdvancedTypographicTableReader(this, in);
                atr.readAll();
                this.advancedTableReader = atr;
            }
            catch (AdvancedTypographicTableFormatException e) {
                this.log.warn((Object)("Encountered format constraint violation in advanced (typographic) table (AT) in font '" + this.getFullName() + "', ignoring AT data: " + e.getMessage()));
            }
        }
    }

    protected void createCMaps() {
        int unicodeEnd;
        UnicodeMapping um;
        this.cmaps = new ArrayList<CMapSegment>();
        if (this.unicodeMappings.isEmpty()) {
            return;
        }
        Iterator<UnicodeMapping> e = this.unicodeMappings.iterator();
        UnicodeMapping lastMapping = um = e.next();
        int unicodeStart = um.getUnicodeIndex();
        int glyphStart = um.getGlyphIndex();
        while (e.hasNext()) {
            um = e.next();
            if (lastMapping.getUnicodeIndex() + 1 != um.getUnicodeIndex() || lastMapping.getGlyphIndex() + 1 != um.getGlyphIndex()) {
                unicodeEnd = lastMapping.getUnicodeIndex();
                this.cmaps.add(new CMapSegment(unicodeStart, unicodeEnd, glyphStart));
                unicodeStart = um.getUnicodeIndex();
                glyphStart = um.getGlyphIndex();
            }
            lastMapping = um;
        }
        unicodeEnd = lastMapping.getUnicodeIndex();
        this.cmaps.add(new CMapSegment(unicodeStart, unicodeEnd, glyphStart));
    }

    public String getPostScriptName() {
        if (this.postScriptName.length() == 0) {
            return FontUtil.stripWhiteSpace(this.getFullName());
        }
        return this.postScriptName;
    }

    PostScriptVersion getPostScriptVersion() {
        return this.postScriptVersion;
    }

    public Set<String> getFamilyNames() {
        return this.familyNames;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCharSetName() {
        return ENCODING;
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    protected int getPadSize(int currentPosition) {
        int padSize = 4 - currentPosition % 4;
        return padSize < 4 ? padSize : 0;
    }

    public int getFlags() {
        int flags = 32;
        if (this.italicAngle != 0L) {
            flags |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            flags |= 2;
        }
        if (this.hasSerifs) {
            flags |= 1;
        }
        return flags;
    }

    public int getWeightClass() {
        return this.usWeightClass;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String ia = Short.toString((short)(this.italicAngle / 65536L));
        return ia;
    }

    public int[] getFontBBox() {
        int[] fbb = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return fbb;
    }

    public int[] getBBoxRaw() {
        int[] bbox = new int[]{this.fontBBox1, this.fontBBox2, this.fontBBox3, this.fontBBox4};
        return bbox;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return 0;
    }

    public int[] getWidths() {
        int[] wx = new int[this.mtxTab.length];
        for (int i = 0; i < wx.length; ++i) {
            wx[i] = this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx());
        }
        return wx;
    }

    public Rectangle[] getBoundingBoxes() {
        Rectangle[] boundingBoxes = new Rectangle[this.mtxTab.length];
        for (int i = 0; i < boundingBoxes.length; ++i) {
            int[] boundingBox = this.mtxTab[i].getBoundingBox();
            boundingBoxes[i] = new Rectangle(this.convertTTFUnit2PDFUnit(boundingBox[0]), this.convertTTFUnit2PDFUnit(boundingBox[1]), this.convertTTFUnit2PDFUnit(boundingBox[2] - boundingBox[0]), this.convertTTFUnit2PDFUnit(boundingBox[3] - boundingBox[1]));
        }
        return boundingBoxes;
    }

    public int[] getBBox(int glyphIndex) {
        int[] bbox = new int[4];
        if (glyphIndex < this.mtxTab.length) {
            int[] bboxInTTFUnits = this.mtxTab[glyphIndex].getBoundingBox();
            for (int i = 0; i < 4; ++i) {
                bbox[i] = this.convertTTFUnit2PDFUnit(bboxInTTFUnits[i]);
            }
        }
        return bbox;
    }

    public int getCharWidth(int idx) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[idx]);
    }

    public int getCharWidthRaw(int idx) {
        if (this.ansiWidth != null) {
            return this.ansiWidth[idx];
        }
        return -1;
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        return this.kerningTab;
    }

    public Map<Integer, Map<Integer, Integer>> getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public int getUnderlinePosition() {
        return this.convertTTFUnit2PDFUnit(this.underlinePosition);
    }

    public int getUnderlineThickness() {
        return this.convertTTFUnit2PDFUnit(this.underlineThickness);
    }

    public int getStrikeoutPosition() {
        return this.convertTTFUnit2PDFUnit(this.strikeoutPosition);
    }

    public int getStrikeoutThickness() {
        return this.convertTTFUnit2PDFUnit(this.strikeoutThickness);
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isCFF() {
        return this.isCFF;
    }

    protected void readDirTabs() throws IOException {
        int sfntVersion = this.fontFile.readTTFLong();
        switch (sfntVersion) {
            case 65536: {
                this.log.debug((Object)"sfnt version: OpenType 1.0");
                break;
            }
            case 0x4F54544F: {
                this.isCFF = true;
                this.log.debug((Object)"sfnt version: OpenType with CFF data");
                break;
            }
            case 1953658213: {
                this.log.debug((Object)"sfnt version: Apple TrueType");
                break;
            }
            case 1954115633: {
                this.log.debug((Object)"sfnt version: Apple Type 1 housed in sfnt wrapper");
                break;
            }
            default: {
                this.log.debug((Object)("Unknown sfnt version: " + Integer.toHexString(sfntVersion)));
            }
        }
        int ntabs = this.fontFile.readTTFUShort();
        this.fontFile.skip(6L);
        this.dirTabs = new HashMap<OFTableName, OFDirTabEntry>();
        OFDirTabEntry[] pd = new OFDirTabEntry[ntabs];
        this.log.debug((Object)("Reading " + ntabs + " dir tables"));
        for (int i = 0; i < ntabs; ++i) {
            pd[i] = new OFDirTabEntry();
            String tableName = pd[i].read(this.fontFile);
            this.dirTabs.put(OFTableName.getValue(tableName), pd[i]);
        }
        this.dirTabs.put(OFTableName.TABLE_DIRECTORY, new OFDirTabEntry(0L, this.fontFile.getCurrentPos()));
        this.log.debug((Object)("dir tables: " + this.dirTabs.keySet()));
    }

    protected void readFontHeader() throws IOException {
        this.seekTab(this.fontFile, OFTableName.HEAD, 16L);
        int flags = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("flags: " + flags + " - " + Integer.toString(flags, 2)));
        }
        this.upem = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unit per em: " + this.upem));
        }
        this.fontFile.skip(16L);
        this.fontBBox1 = this.fontFile.readTTFShort();
        this.fontBBox2 = this.fontFile.readTTFShort();
        this.fontBBox3 = this.fontFile.readTTFShort();
        this.fontBBox4 = this.fontFile.readTTFShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("font bbox: xMin=" + this.fontBBox1 + " yMin=" + this.fontBBox2 + " xMax=" + this.fontBBox3 + " yMax=" + this.fontBBox4));
        }
        this.fontFile.skip(6L);
        this.locaFormat = this.fontFile.readTTFShort();
    }

    protected void getNumGlyphs() throws IOException {
        this.seekTab(this.fontFile, OFTableName.MAXP, 4L);
        this.numberOfGlyphs = this.fontFile.readTTFUShort();
    }

    protected void readHorizontalHeader() throws IOException {
        this.seekTab(this.fontFile, OFTableName.HHEA, 4L);
        this.hheaAscender = this.fontFile.readTTFShort();
        this.hheaDescender = this.fontFile.readTTFShort();
        this.fontFile.skip(26L);
        this.nhmtx = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("hhea.Ascender: " + this.formatUnitsForDebug(this.hheaAscender)));
            this.log.debug((Object)("hhea.Descender: " + this.formatUnitsForDebug(this.hheaDescender)));
            this.log.debug((Object)("Number of horizontal metrics: " + this.nhmtx));
        }
    }

    protected void readHorizontalMetrics() throws IOException {
        int i;
        this.seekTab(this.fontFile, OFTableName.HMTX, 0L);
        int mtxSize = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new OFMtxEntry[mtxSize];
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"*** Widths array: \n");
        }
        for (i = 0; i < mtxSize; ++i) {
            this.mtxTab[i] = new OFMtxEntry();
        }
        for (i = 0; i < this.nhmtx; ++i) {
            this.mtxTab[i].setWx(this.fontFile.readTTFUShort());
            this.mtxTab[i].setLsb(this.fontFile.readTTFUShort());
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("   width[" + i + "] = " + this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx()) + ";"));
        }
        if (this.cid && this.nhmtx < mtxSize) {
            int lastWidth = this.mtxTab[this.nhmtx - 1].getWx();
            for (int i2 = this.nhmtx; i2 < mtxSize; ++i2) {
                this.mtxTab[i2].setWx(lastWidth);
                this.mtxTab[i2].setLsb(this.fontFile.readTTFUShort());
            }
        }
    }

    protected void readPostScript() throws IOException {
        this.seekTab(this.fontFile, OFTableName.POST, 0L);
        int postFormat = this.fontFile.readTTFLong();
        this.italicAngle = this.fontFile.readTTFULong();
        this.underlinePosition = this.fontFile.readTTFShort();
        this.underlineThickness = this.fontFile.readTTFShort();
        this.isFixedPitch = this.fontFile.readTTFULong();
        this.fontFile.skip(16L);
        this.log.debug((Object)("PostScript format: 0x" + Integer.toHexString(postFormat)));
        switch (postFormat) {
            case 65536: {
                this.log.debug((Object)"PostScript format 1");
                this.postScriptVersion = PostScriptVersion.V1;
                for (int i = 0; i < MAC_GLYPH_ORDERING.length; ++i) {
                    this.mtxTab[i].setName(MAC_GLYPH_ORDERING[i]);
                }
                break;
            }
            case 131072: {
                int i;
                this.log.debug((Object)"PostScript format 2");
                this.postScriptVersion = PostScriptVersion.V2;
                int numGlyphStrings = 257;
                int l = this.fontFile.readTTFUShort();
                for (int i2 = 0; i2 < l; ++i2) {
                    this.mtxTab[i2].setIndex(this.fontFile.readTTFUShort());
                    if (this.mtxTab[i2].getIndex() > numGlyphStrings) {
                        numGlyphStrings = this.mtxTab[i2].getIndex();
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("PostScript index: " + this.mtxTab[i2].getIndexAsString()));
                }
                String[] psGlyphsBuffer = new String[numGlyphStrings - 257];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reading " + numGlyphStrings + " glyphnames, that are not in the standard Macintosh set. Total number of glyphs=" + l));
                }
                for (i = 0; i < psGlyphsBuffer.length; ++i) {
                    psGlyphsBuffer[i] = this.fontFile.readTTFString(this.fontFile.readTTFUByte());
                }
                for (i = 0; i < l; ++i) {
                    if (this.mtxTab[i].getIndex() < MAC_GLYPH_ORDERING.length) {
                        this.mtxTab[i].setName(MAC_GLYPH_ORDERING[this.mtxTab[i].getIndex()]);
                        continue;
                    }
                    if (this.mtxTab[i].isIndexReserved()) continue;
                    int k = this.mtxTab[i].getIndex() - MAC_GLYPH_ORDERING.length;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(k + " i=" + i + " mtx=" + this.mtxTab.length + " ps=" + psGlyphsBuffer.length));
                    }
                    this.mtxTab[i].setName(psGlyphsBuffer[k]);
                }
                break;
            }
            case 196608: {
                this.log.debug((Object)"PostScript format 3");
                this.postScriptVersion = PostScriptVersion.V3;
                break;
            }
            default: {
                this.log.error((Object)("Unknown PostScript format: " + postFormat));
                this.postScriptVersion = PostScriptVersion.UNKNOWN;
            }
        }
    }

    protected void readOS2() throws IOException {
        OFDirTabEntry os2Entry = this.dirTabs.get(OFTableName.OS2);
        if (os2Entry != null) {
            this.seekTab(this.fontFile, OFTableName.OS2, 0L);
            int version = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("OS/2 table: version=" + version + ", offset=" + os2Entry.getOffset() + ", len=" + os2Entry.getLength()));
            }
            this.fontFile.skip(2L);
            this.usWeightClass = this.fontFile.readTTFUShort();
            this.fontFile.skip(2L);
            int fsType = this.fontFile.readTTFUShort();
            this.isEmbeddable = fsType != 2;
            this.fontFile.skip(16L);
            this.strikeoutThickness = this.fontFile.readTTFShort();
            this.strikeoutPosition = this.fontFile.readTTFShort();
            this.fontFile.skip(2L);
            this.fontFile.skip(10L);
            this.fontFile.skip(16L);
            this.fontFile.skip(4L);
            this.fontFile.skip(6L);
            this.os2Ascender = this.fontFile.readTTFShort();
            this.os2Descender = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoAscender: " + this.os2Ascender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Ascender)));
                this.log.debug((Object)("sTypoDescender: " + this.os2Descender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Descender)));
            }
            int v = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoLineGap: " + v));
            }
            v = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinAscent: " + this.formatUnitsForDebug(v)));
            }
            v = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinDescent: " + this.formatUnitsForDebug(v)));
            }
            if (os2Entry.getLength() >= 90L) {
                this.fontFile.skip(8L);
                this.os2xHeight = this.fontFile.readTTFShort();
                this.os2CapHeight = this.fontFile.readTTFShort();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sxHeight: " + this.os2xHeight));
                    this.log.debug((Object)("sCapHeight: " + this.os2CapHeight));
                }
            }
        } else {
            this.isEmbeddable = true;
        }
    }

    protected boolean readPCLT() throws IOException {
        OFDirTabEntry dirTab = this.dirTabs.get(OFTableName.PCLT);
        if (dirTab != null) {
            this.fontFile.seekSet(dirTab.getOffset() + 4L + 4L + 2L);
            this.xHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("xHeight from PCLT: " + this.formatUnitsForDebug(this.xHeight)));
            this.fontFile.skip(4L);
            this.capHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("capHeight from PCLT: " + this.formatUnitsForDebug(this.capHeight)));
            this.fontFile.skip(34L);
            int serifStyle = this.fontFile.readTTFUByte();
            serifStyle >>= 6;
            this.hasSerifs = (serifStyle &= 3) != 1;
            return true;
        }
        return false;
    }

    protected void determineAscDesc() {
        int hheaBoxHeight = this.hheaAscender - this.hheaDescender;
        int os2BoxHeight = this.os2Ascender - this.os2Descender;
        if (this.os2Ascender > 0 && os2BoxHeight <= this.upem) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else if (this.hheaAscender > 0 && hheaBoxHeight <= this.upem) {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        } else if (this.os2Ascender > 0) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Font box height: " + (this.ascender - this.descender)));
            if (this.ascender - this.descender > this.upem) {
                this.log.debug((Object)"Ascender and descender together are larger than the em box.");
            }
        }
    }

    protected void guessVerticalMetricsFromGlyphBBox() {
        int localCapHeight = 0;
        int localXHeight = 0;
        int localAscender = 0;
        int localDescender = 0;
        for (OFMtxEntry aMtxTab : this.mtxTab) {
            if ("H".equals(aMtxTab.getName())) {
                localCapHeight = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if ("x".equals(aMtxTab.getName())) {
                localXHeight = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if ("d".equals(aMtxTab.getName())) {
                localAscender = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if ("p".equals(aMtxTab.getName())) {
                localDescender = aMtxTab.getBoundingBox()[1];
                continue;
            }
            List<Integer> unicodeIndex = aMtxTab.getUnicodeIndex();
            if (unicodeIndex.size() <= 0) continue;
            char ch = (char)unicodeIndex.get(0).intValue();
            if (ch == 'H') {
                localCapHeight = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if (ch == 'x') {
                localXHeight = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if (ch == 'd') {
                localAscender = aMtxTab.getBoundingBox()[3];
                continue;
            }
            if (ch != 'p') continue;
            localDescender = aMtxTab.getBoundingBox()[1];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ascender from glyph 'd': " + this.formatUnitsForDebug(localAscender)));
            this.log.debug((Object)("Descender from glyph 'p': " + this.formatUnitsForDebug(localDescender)));
        }
        if (this.ascender - this.descender > this.upem) {
            this.log.debug((Object)"Replacing specified ascender/descender with derived values to get values which fit in the em box.");
            this.ascender = localAscender;
            this.descender = localDescender;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("xHeight from glyph 'x': " + this.formatUnitsForDebug(localXHeight)));
            this.log.debug((Object)("CapHeight from glyph 'H': " + this.formatUnitsForDebug(localCapHeight)));
        }
        if (this.capHeight == 0) {
            this.capHeight = localCapHeight;
            if (this.capHeight == 0) {
                this.capHeight = this.os2CapHeight;
            }
            if (this.capHeight == 0) {
                this.log.debug((Object)"capHeight value could not be determined. The font may not work as expected.");
            }
        }
        if (this.xHeight == 0) {
            this.xHeight = localXHeight;
            if (this.xHeight == 0) {
                this.xHeight = this.os2xHeight;
            }
            if (this.xHeight == 0) {
                this.log.debug((Object)"xHeight value could not be determined. The font may not work as expected.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readKerning() throws IOException {
        this.kerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        this.ansiKerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        OFDirTabEntry dirTab = this.dirTabs.get(OFTableName.KERN);
        if (dirTab != null) {
            this.seekTab(this.fontFile, OFTableName.KERN, 2L);
            for (int n = this.fontFile.readTTFUShort(); n > 0; --n) {
                this.fontFile.skip(4L);
                int k = this.fontFile.readTTFUShort();
                if ((k & 1) == 0 || (k & 2) != 0 || (k & 4) != 0) {
                    return;
                }
                if (k >> 8 != 0) continue;
                k = this.fontFile.readTTFUShort();
                this.fontFile.skip(6L);
                while (k-- > 0) {
                    void var9_15;
                    int i = this.fontFile.readTTFUShort();
                    int j = this.fontFile.readTTFUShort();
                    short kpx = this.fontFile.readTTFShort();
                    if (kpx == 0) continue;
                    Integer iObj = this.glyphToUnicode(i);
                    Integer u2 = this.glyphToUnicode(j);
                    if (iObj == null) {
                        this.log.debug((Object)("Ignoring kerning pair because no Unicode index was found for the first glyph " + i));
                        continue;
                    }
                    if (u2 == null) {
                        this.log.debug((Object)("Ignoring kerning pair because Unicode index was found for the second glyph " + i));
                        continue;
                    }
                    Map<Integer, Integer> map = this.kerningTab.get(iObj);
                    if (map == null) {
                        HashMap hashMap = new HashMap();
                    }
                    var9_15.put(u2, this.convertTTFUnit2PDFUnit(kpx));
                    this.kerningTab.put(iObj, (Map<Integer, Integer>)var9_15);
                }
            }
            for (Map.Entry<Integer, Map<Integer, Integer>> e1 : this.kerningTab.entrySet()) {
                Integer unicodeKey1 = e1.getKey();
                Integer cidKey1 = this.unicodeToGlyph(unicodeKey1);
                HashMap<Integer, Integer> akpx = new HashMap<Integer, Integer>();
                Map<Integer, Integer> ckpx = e1.getValue();
                for (Map.Entry<Integer, Integer> entry : ckpx.entrySet()) {
                    Integer unicodeKey2 = entry.getKey();
                    Integer cidKey2 = this.unicodeToGlyph(unicodeKey2);
                    Integer kern = entry.getValue();
                    Iterator<Integer> iterator = this.mtxTab[cidKey2].getUnicodeIndex().iterator();
                    while (iterator.hasNext()) {
                        Integer[] ansiKeys;
                        Integer o;
                        Integer unicodeKey = o = iterator.next();
                        for (Integer ansiKey : ansiKeys = this.unicodeToWinAnsi(unicodeKey)) {
                            akpx.put(ansiKey, kern);
                        }
                    }
                }
                if (akpx.size() <= 0) continue;
                for (Object object : this.mtxTab[cidKey1].getUnicodeIndex()) {
                    Integer[] ansiKeys;
                    Integer unicodeKey = (Integer)object;
                    for (Integer ansiKey : ansiKeys = this.unicodeToWinAnsi(unicodeKey)) {
                        this.ansiKerningTab.put(ansiKey, akpx);
                    }
                }
            }
        }
    }

    public void stream(TTFOutputStream ttfOut) throws IOException {
        SortedSet<Map.Entry<OFTableName, OFDirTabEntry>> sortedDirTabs = this.sortDirTabMap(this.dirTabs);
        byte[] file = this.fontFile.getAllBytes();
        TTFTableOutputStream tableOut = ttfOut.getTableOutputStream();
        TTFGlyphOutputStream glyphOut = ttfOut.getGlyphOutputStream();
        ttfOut.startFontStream();
        for (Map.Entry entry : sortedDirTabs) {
            int offset = (int)((OFDirTabEntry)entry.getValue()).getOffset();
            int paddedLength = (int)((OFDirTabEntry)entry.getValue()).getLength();
            paddedLength += this.getPadSize(offset + paddedLength);
            if (((OFTableName)entry.getKey()).equals(OFTableName.GLYF)) {
                this.streamGlyf(glyphOut, file, offset, paddedLength);
                continue;
            }
            tableOut.streamTable(file, offset, paddedLength);
        }
        ttfOut.endFontStream();
    }

    private void streamGlyf(TTFGlyphOutputStream glyphOut, byte[] fontFile, int tableOffset, int tableLength) throws IOException {
        int glyphStart = 0;
        int glyphEnd = 0;
        glyphOut.startGlyphStream();
        for (int i = 0; i < this.mtxTab.length - 1; ++i) {
            glyphStart = (int)this.mtxTab[i].getOffset() + tableOffset;
            glyphEnd = (int)this.mtxTab[i + 1].getOffset() + tableOffset;
            glyphOut.streamGlyph(fontFile, glyphStart, glyphEnd - glyphStart);
        }
        glyphOut.streamGlyph(fontFile, glyphEnd, tableOffset + tableLength - glyphEnd);
        glyphOut.endGlyphStream();
    }

    SortedSet<Map.Entry<OFTableName, OFDirTabEntry>> sortDirTabMap(Map<OFTableName, OFDirTabEntry> directoryTabs) {
        TreeSet<Map.Entry<OFTableName, OFDirTabEntry>> sortedSet = new TreeSet<Map.Entry<OFTableName, OFDirTabEntry>>(new Comparator<Map.Entry<OFTableName, OFDirTabEntry>>(){

            @Override
            public int compare(Map.Entry<OFTableName, OFDirTabEntry> o1, Map.Entry<OFTableName, OFDirTabEntry> o2) {
                return (int)(o1.getValue().getOffset() - o2.getValue().getOffset());
            }
        });
        sortedSet.addAll(directoryTabs.entrySet());
        return sortedSet;
    }

    public List<CMapSegment> getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(String tag, String name) throws IOException {
        if ("ttcf".equals(tag)) {
            this.fontFile.skip(4L);
            int numDirectories = (int)this.fontFile.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            for (int i = 0; i < numDirectories; ++i) {
                dirOffsets[i] = this.fontFile.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + numDirectories + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            boolean found = false;
            long dirTabOffset = 0L;
            for (int i = 0; i < numDirectories; ++i) {
                this.fontFile.seekSet(dirOffsets[i]);
                this.readDirTabs();
                this.readName();
                if (this.fullName.equals(name)) {
                    found = true;
                    dirTabOffset = dirOffsets[i];
                    this.log.info((Object)(this.fullName + " <-- selected"));
                } else {
                    this.log.info((Object)this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            this.fontFile.seekSet(dirTabOffset);
            return found;
        }
        this.fontFile.seekSet(0L);
        return true;
    }

    public final List<String> getTTCnames(FontFileReader in) throws IOException {
        this.fontFile = in;
        ArrayList<String> fontNames = new ArrayList<String>();
        String tag = in.readTTFString(4);
        if ("ttcf".equals(tag)) {
            int i;
            in.skip(4L);
            int numDirectories = (int)in.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            for (i = 0; i < numDirectories; ++i) {
                dirOffsets[i] = in.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + numDirectories + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            for (i = 0; i < numDirectories; ++i) {
                in.seekSet(dirOffsets[i]);
                this.readDirTabs();
                this.readName();
                this.log.info((Object)this.fullName);
                fontNames.add(this.fullName);
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            in.seekSet(0L);
            return fontNames;
        }
        this.log.error((Object)"Not a TTC!");
        return null;
    }

    private Integer[] unicodeToWinAnsi(int unicode) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            if (unicode != Glyphs.WINANSI_ENCODING[i]) continue;
            ret.add(i);
        }
        return ret.toArray(new Integer[ret.size()]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.postScriptName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyNames);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int italic = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + italic);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    private String formatUnitsForDebug(int units) {
        return units + " -> " + this.convertTTFUnit2PDFUnit(units) + " internal units";
    }

    private Integer glyphToUnicode(int glyphIndex) {
        return this.glyphToUnicodeMap.get(glyphIndex);
    }

    private Integer unicodeToGlyph(int unicodeIndex) throws IOException {
        Integer result = this.unicodeToGlyphMap.get(unicodeIndex);
        if (result == null) {
            throw new IOException("Glyph index not found for unicode value " + unicodeIndex);
        }
        return result;
    }

    String getGlyphName(int glyphIndex) {
        return this.mtxTab[glyphIndex].getName();
    }

    public boolean hasAdvancedTable() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.hasAdvancedTable();
        }
        return false;
    }

    public GlyphDefinitionTable getGDEF() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGDEF();
        }
        return null;
    }

    public GlyphSubstitutionTable getGSUB() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGSUB();
        }
        return null;
    }

    public GlyphPositioningTable getGPOS() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGPOS();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileInputStream stream = null;
        try {
            String header;
            boolean isCFF;
            boolean useKerning = true;
            boolean useAdvanced = true;
            stream = new FileInputStream(args[0]);
            FontFileReader reader = new FontFileReader(stream);
            String name = null;
            if (args.length >= 2) {
                name = args[1];
            }
            OpenFont otfFile = (isCFF = (header = OFFontLoader.readHeader(reader)).equals("OTTO")) ? new OTFFile() : new TTFFile(useKerning, useAdvanced);
            otfFile.readFont(reader, header, name);
            otfFile.printStuff();
        }
        catch (IOException ioe) {
            try {
                System.err.println("Problem reading font: " + ioe.toString());
                ioe.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public String getEmbedFontName() {
        return this.embedFontName;
    }

    public String getCopyrightNotice() {
        return this.notice;
    }

    static final class UnicodeMapping
    implements Comparable {
        private final int unicodeIndex;
        private final int glyphIndex;

        UnicodeMapping(OpenFont font, int glyphIndex, int unicodeIndex) {
            this.unicodeIndex = unicodeIndex;
            this.glyphIndex = glyphIndex;
            font.glyphToUnicodeMap.put(glyphIndex, unicodeIndex);
            font.unicodeToGlyphMap.put(unicodeIndex, glyphIndex);
        }

        public int getGlyphIndex() {
            return this.glyphIndex;
        }

        public int getUnicodeIndex() {
            return this.unicodeIndex;
        }

        public int hashCode() {
            int hc = this.unicodeIndex;
            hc = 19 * hc + (hc ^ this.glyphIndex);
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof UnicodeMapping) {
                UnicodeMapping m = (UnicodeMapping)o;
                if (this.unicodeIndex != m.unicodeIndex) {
                    return false;
                }
                return this.glyphIndex == m.glyphIndex;
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof UnicodeMapping) {
                UnicodeMapping m = (UnicodeMapping)o;
                if (this.unicodeIndex > m.unicodeIndex) {
                    return 1;
                }
                if (this.unicodeIndex < m.unicodeIndex) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }

    public static enum PostScriptVersion {
        V1,
        V2,
        V3,
        UNKNOWN;

    }
}

