/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jdbc.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SqlBuilder;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.core.web.format.BooleanFormatter;

public class Criteria {
    private static Logger LOG = LogManager.getLogger(Criteria.class);
    private Integer searchLimit;
    private String entityName;
    private String alias;
    private boolean distinct = false;
    private transient DateTimeService dateTimeService;
    protected List tokens = new ArrayList();
    private List orderByTokens = new ArrayList();
    protected Map<String, Object> params = new LinkedHashMap<String, Object>();
    DatabasePlatform dbPlatform = null;

    public Criteria(String entityName) {
        this(entityName, "a");
    }

    public DatabasePlatform getDbPlatform() {
        if (this.dbPlatform == null) {
            this.dbPlatform = (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
        }
        return this.dbPlatform;
    }

    public void setDbPlatform(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
    }

    public Criteria(String entityName, String alias) {
        this.entityName = entityName;
        this.alias = alias;
    }

    public void between(String attribute, Object value1, Object value2, Class propertyType) {
        String fixedValue1 = this.fixValue(value1, propertyType);
        String fixedValue2 = this.fixValue(value2, propertyType);
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(" (" + this.fix(attribute) + " BETWEEN " + fixedValue1 + " AND " + fixedValue2 + ") ");
        } else {
            this.tokens.add(" (" + this.alias + "." + attribute + " BETWEEN " + fixedValue1 + " AND " + fixedValue2 + ") ");
        }
    }

    private String fixValue(Object value, Class propertyType) {
        if (value == null) {
            return "";
        }
        if (SqlBuilder.isJoinClass(propertyType)) {
            return value.toString();
        }
        if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
            new BigDecimal(value.toString());
            return value.toString();
        }
        if (TypeUtils.isTemporalClass((Class)propertyType)) {
            try {
                if (value instanceof String) {
                    value = this.getDateTimeService().convertToSqlTimestamp(value.toString());
                }
                return this.getFixedTemporalValue(value);
            }
            catch (ParseException pe) {
                LOG.warn("Could not parse " + value.toString() + " as date");
                throw new RuntimeException("Could not parse " + value.toString() + " as date", pe);
            }
        }
        if (TypeUtils.isStringClass((Class)propertyType)) {
            return " '" + this.getDbPlatform().escapeString(value.toString().trim()) + "' ";
        }
        if (TypeUtils.isBooleanClass((Class)propertyType)) {
            boolean bVal;
            if (value instanceof String) {
                value = new BooleanFormatter().convertFromPresentationFormat((Object)value.toString());
            }
            if (bVal = ((Boolean)value).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return value.toString();
    }

    private String getFixedTemporalValue(Object value) {
        Timestamp ts = (Timestamp)value;
        Date dt = new Date(ts.getTime());
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        String sql = this.getDbPlatform().getDateSQL(sdfDate.format(dt), sdfTime.format(dt));
        return sql;
    }

    public void eq(String attribute, Object value, Class propertyType) {
        this.tokens.add(this.alias + "." + attribute + " = " + this.fixValue(value, propertyType) + " ");
    }

    public void gt(String attribute, Object value, Class propertyType) {
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " > " + this.fixValue(value, propertyType) + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " > " + this.fixValue(value, propertyType) + " ");
        }
    }

    public void gte(String attribute, Object value, Class propertyType) {
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " >= " + this.fixValue(value, propertyType) + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " >= " + this.fixValue(value, propertyType) + " ");
        }
    }

    public void like(String attribute, Object value, Class propertyType, boolean allowWildcards) {
        String fixedValue = this.fixValue(value, propertyType);
        if (allowWildcards) {
            fixedValue = Criteria.fixWildcards(fixedValue, this.getAttributeValueStartIndex(fixedValue), this.getAttributeValueEndIndex(fixedValue));
        }
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " LIKE " + fixedValue + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " LIKE " + fixedValue + " ");
        }
    }

    public void notLike(String attribute, Object value, Class propertyType, boolean allowWildcards) {
        String fixedValue = this.fixValue(value, propertyType);
        if (allowWildcards) {
            fixedValue = Criteria.fixWildcards(fixedValue, this.getAttributeValueStartIndex(fixedValue), this.getAttributeValueEndIndex(fixedValue));
        }
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " NOT LIKE " + fixedValue + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " NOT LIKE " + fixedValue + " ");
        }
    }

    public void notEqual(String attribute, Object value, Class propertyType, boolean allowWildcards) {
        String fixedValue = this.fixValue(value, propertyType);
        if (allowWildcards) {
            fixedValue = Criteria.fixWildcards(fixedValue, this.getAttributeValueStartIndex(fixedValue), this.getAttributeValueEndIndex(fixedValue));
        }
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " <> " + fixedValue + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " <> " + fixedValue + " ");
        }
    }

    private static String fixWildcards(String sIn, int startIndex, int endIndex) {
        String attribute = startIndex == -1 ? sIn : sIn.substring(startIndex + 1, endIndex);
        attribute = attribute.replaceAll("\\*", "%");
        attribute = attribute.replaceAll("\\?", "_");
        return startIndex == -1 ? attribute : sIn.substring(0, startIndex + 1) + attribute + sIn.substring(endIndex);
    }

    public void lt(String attribute, Object value, Class propertyType) {
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " < " + this.fixValue(value, propertyType) + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " < " + this.fixValue(value, propertyType) + " ");
        }
    }

    public void lte(String attribute, Object value, Class propertyType) {
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(this.fix(attribute) + " <= " + this.fixValue(value, propertyType) + " ");
        } else {
            this.tokens.add(this.alias + "." + attribute + " <= " + this.fixValue(value, propertyType) + " ");
        }
    }

    public void ne(String attribute, Object value, Class propertyType) {
        this.tokens.add(this.alias + "." + attribute + " != " + this.fixValue(value, propertyType) + " ");
    }

    public void isNull(String attribute) {
        this.tokens.add(this.alias + "." + attribute + " IS NULL ");
    }

    public void rawJpql(String jpql) {
        this.tokens.add(" " + jpql + " ");
    }

    public void in(String attribute, List values, Class propertyType) {
        Object in = "";
        for (Object object : values) {
            in = (String)in + this.fixValue(object, propertyType) + ",";
        }
        if (!"".equals(in)) {
            in = ((String)in).substring(0, ((String)in).length() - 1);
        }
        this.tokens.add(this.alias + "." + attribute + " IN (" + (String)in + ") ");
    }

    public void notIn(String attribute, List values, Class propertyType) {
        Object in = "";
        for (Object object : values) {
            in = (String)in + this.fixValue(object, propertyType) + ",";
        }
        if (!"".equals(in)) {
            in = ((String)in).substring(((String)in).length() - 1);
        }
        this.tokens.add(this.alias + "." + attribute + " NOT IN (" + (String)in + ") ");
    }

    public void orderBy(String attribute, boolean sortAscending) {
        String sort = sortAscending ? "ASC" : "DESC";
        this.orderByTokens.add(this.alias + "." + attribute + " " + sort + " ");
    }

    public void and(Criteria and) {
        this.tokens.add(new AndCriteria(and));
    }

    public void or(Criteria or) {
        this.tokens.add(new OrCriteria(or));
    }

    public void exists(Criteria exists) {
        this.tokens.add(new ExistsCriteria(exists));
    }

    public String toQuery() {
        Object queryType = "SELECT";
        if (this.distinct) {
            queryType = (String)queryType + " DISTINCT";
        }
        queryType = (String)queryType + " " + this.alias;
        String queryString = (String)queryType + " FROM " + this.entityName + " AS " + this.alias;
        if (!this.tokens.isEmpty()) {
            queryString = queryString + " WHERE " + this.buildWhere();
        }
        if (!this.orderByTokens.isEmpty()) {
            queryString = queryString + " ORDER BY ";
            int count = 0;
            for (Object token : this.orderByTokens) {
                if (count == 0) {
                    ++count;
                } else {
                    queryString = queryString + ", ";
                }
                queryString = queryString + (String)token;
            }
        }
        return this.fix(queryString);
    }

    public String toCountQuery() {
        String queryString = "SELECT COUNT(*) FROM " + this.entityName + " AS " + this.alias;
        if (!this.tokens.isEmpty()) {
            queryString = queryString + " WHERE " + this.buildWhere();
        }
        return this.fix(queryString);
    }

    private String fix(String queryString) {
        queryString = queryString.replaceAll("__JPA_ALIAS__", this.alias);
        return queryString;
    }

    public String buildWhere() {
        return this.fix(this.buildWhere(null));
    }

    private String buildWhere(Criteria parentCriteria) {
        Object queryString = "";
        int i = 0;
        for (Object token : this.tokens) {
            if (token instanceof Criteria) {
                String logic = "";
                if (i > 0 && token instanceof AndCriteria) {
                    logic = " AND ";
                } else if (i > 0 && token instanceof OrCriteria) {
                    logic = " OR ";
                } else if (i > 0 && token instanceof ExistsCriteria) {
                    logic = " EXISTS ";
                }
                queryString = (String)queryString + logic + " (" + ((Criteria)token).buildWhere((Criteria)token) + ") ";
            } else {
                queryString = i > 0 ? (String)queryString + " AND " + (String)token : (String)queryString + (String)token;
            }
            ++i;
        }
        return queryString;
    }

    public List<Object> getParameteres() {
        return this.getParameteres(this.tokens, this.params);
    }

    public List<Object> getParameteres(List tokens, Map<String, Object> params) {
        ArrayList<Object> mRet = new ArrayList<Object>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            Object value = param.getValue();
            if (value instanceof BigDecimal) {
                value = new Long(((BigDecimal)value).longValue());
            }
            if (value instanceof String) {
                value = ((String)value).replaceAll("\\*", "%");
            }
            mRet.add(value);
        }
        for (Object token : tokens) {
            if (!(token instanceof Criteria)) continue;
            mRet.addAll(this.getParameteres(((Criteria)token).tokens, ((Criteria)token).params));
        }
        return mRet;
    }

    public Integer getSearchLimit() {
        return this.searchLimit;
    }

    public void setSearchLimit(Integer searchLimit) {
        this.searchLimit = searchLimit;
    }

    public void notNull(String attribute) {
        this.tokens.add(this.alias + "." + attribute + " IS NOT NULL ");
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void notBetween(String attribute, Object value1, Object value2, Class propertyType) {
        String fixedValue1 = this.fixValue(value1, propertyType);
        String fixedValue2 = this.fixValue(value1, propertyType);
        if (attribute.contains("__JPA_ALIAS__")) {
            this.tokens.add(" (" + this.fix(attribute) + " NOT BETWEEN " + fixedValue1 + " AND " + fixedValue2 + ") ");
        } else {
            this.tokens.add(" (" + this.alias + "." + attribute + " NOT BETWEEN " + fixedValue1 + " AND " + fixedValue2 + ") ");
        }
    }

    public void in(String match, Criteria subQuery, String attribute, Class propertyType) {
        if ("a".equals(subQuery.alias)) {
            subQuery.alias = "b";
        }
        Object whereClause = "";
        whereClause = subQuery.tokens.isEmpty() ? "WHERE " : "AND ";
        whereClause = (String)whereClause + subQuery.alias + "." + attribute + " = " + this.alias + "." + match;
        this.tokens.add("EXISTS (" + subQuery.toQuery() + (String)whereClause + " ) ");
    }

    private String stripFunctions(String attribute) {
        int index = attribute.lastIndexOf(40);
        if (index != -1) {
            return attribute.substring(index + 1, attribute.indexOf(41));
        }
        return attribute;
    }

    private int getAttributeValueStartIndex(String attribute) {
        return attribute.lastIndexOf(40);
    }

    private int getAttributeValueEndIndex(String attribute) {
        return attribute.lastIndexOf(41);
    }

    public String getAlias() {
        return this.alias;
    }

    public String establishDateString(String fromDate, String toDate, String columnDbName, String whereStatementClause) {
        DatabasePlatform platform = this.getDbPlatform();
        StringBuffer dateSqlString = new StringBuffer(whereStatementClause).append(" " + platform.escapeString(columnDbName) + " ");
        if (fromDate != null && SQLUtils.getSqlFormattedDate(fromDate) != null && toDate != null && SQLUtils.getSqlFormattedDate(toDate) != null) {
            return dateSqlString.append(" >= " + platform.getDateSQL(platform.escapeString(SQLUtils.getSqlFormattedDate(fromDate.trim())), null) + " and " + platform.escapeString(columnDbName) + " <= " + platform.getDateSQL(platform.escapeString(SQLUtils.getSqlFormattedDate(toDate.trim())), "23:59:59")).toString();
        }
        if (fromDate != null && SQLUtils.getSqlFormattedDate(fromDate) != null) {
            return dateSqlString.append(" >= " + platform.getDateSQL(platform.escapeString(SQLUtils.getSqlFormattedDate(fromDate.trim())), null)).toString();
        }
        if (toDate != null && SQLUtils.getSqlFormattedDate(toDate) != null) {
            return dateSqlString.append(" <= " + platform.getDateSQL(platform.escapeString(SQLUtils.getSqlFormattedDate(toDate.trim())), "23:59:59")).toString();
        }
        return "";
    }

    private DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }

    private class ExistsCriteria
    extends Criteria {
        public ExistsCriteria(Criteria exists) {
            super(exists.entityName, exists.alias);
            this.tokens = new ArrayList(exists.tokens);
            this.params = new HashMap<String, Object>(exists.params);
        }
    }

    private class OrCriteria
    extends Criteria {
        public OrCriteria(Criteria or) {
            super(or.entityName, or.alias);
            this.tokens = new ArrayList(or.tokens);
            this.params = new HashMap<String, Object>(or.params);
        }
    }

    private class AndCriteria
    extends Criteria {
        public AndCriteria(Criteria and) {
            super(and.entityName, and.alias);
            this.tokens = new ArrayList(and.tokens);
            this.params = new HashMap<String, Object>(and.params);
        }
    }
}

