/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.rice.krad.service.impl;

import co.kuali.rice.coreservice.api.attachment.S3FileService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.service.impl.AttachmentServiceImpl;

public class S3AttachmentServiceImpl
extends AttachmentServiceImpl {
    private static final Logger LOG = LogManager.getLogger(S3AttachmentServiceImpl.class);
    private S3FileService riceS3FileService;
    private ParameterService parameterService;

    @Override
    public Attachment createAttachment(GloballyUnique parent, String uploadedFileName, String mimeType, int fileSize, InputStream fileContents, String attachmentType) throws IOException {
        String uniqueFileNameGuid;
        if (!this.isS3IntegrationEnabled()) {
            return super.createAttachment(parent, uploadedFileName, mimeType, fileSize, fileContents, attachmentType);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting to create attachment for document: " + parent.getObjectId());
        }
        if (parent == null) {
            throw new IllegalArgumentException("invalid (null or uninitialized) document");
        }
        if (StringUtils.isBlank((CharSequence)uploadedFileName)) {
            throw new IllegalArgumentException("invalid (blank) fileName");
        }
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            throw new IllegalArgumentException("invalid (blank) mimeType");
        }
        if (fileSize <= 0) {
            throw new IllegalArgumentException("invalid (non-positive) fileSize");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("invalid (null) inputStream");
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)fileContents);
        try {
            Class<?> s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
            Object s3File = s3FileClass.newInstance();
            Method setFileContents = s3FileClass.getMethod("setByteContents", byte[].class);
            setFileContents.invoke(s3File, new Object[]{bytes});
            uniqueFileNameGuid = this.riceS3FileService.createFile(s3File);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (this.isS3DualSaveEnabled()) {
            String fullPathUniqueFileName = this.getDocumentDirectory(parent.getObjectId()) + File.separator + uniqueFileNameGuid;
            this.writeInputStreamToFileStorage(new BufferedInputStream(new ByteArrayInputStream(bytes)), fullPathUniqueFileName);
        }
        Attachment attachment = new Attachment();
        attachment.setAttachmentIdentifier(uniqueFileNameGuid);
        attachment.setAttachmentFileName(uploadedFileName);
        attachment.setAttachmentFileSize(Long.valueOf(fileSize));
        attachment.setAttachmentMimeTypeCode(mimeType);
        attachment.setAttachmentTypeCode(attachmentType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("finished creating attachment for document: " + parent.getObjectId());
        }
        return attachment;
    }

    @Override
    public InputStream retrieveAttachmentContents(Attachment attachment) throws IOException {
        if (!this.isS3IntegrationEnabled()) {
            return super.retrieveAttachmentContents(attachment);
        }
        try {
            String dbMD5;
            String s3MD5;
            Object s3File = this.riceS3FileService.retrieveFile(attachment.getAttachmentIdentifier());
            byte[] s3Bytes = null;
            byte[] fsBytes = null;
            if (s3File != null) {
                if (LOG.isDebugEnabled()) {
                    Method getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                    LOG.debug("data found in S3, existing id: " + attachment.getAttachmentIdentifier() + " metadata: " + getFileMetaData.invoke(s3File, new Object[0]));
                }
                Method getFileContents = s3File.getClass().getMethod("getByteContents", new Class[0]);
                s3Bytes = (byte[])getFileContents.invoke(s3File, new Object[0]);
            }
            if (s3Bytes == null || this.isS3DualRetrieveEnabled()) {
                String parentDirectory = "";
                if (attachment.getNote() != null && attachment.getNote().getRemoteObjectIdentifier() != null) {
                    parentDirectory = attachment.getNote().getRemoteObjectIdentifier();
                }
                Path path = Paths.get(this.getDocumentDirectory(parentDirectory), attachment.getAttachmentIdentifier());
                try {
                    fsBytes = Files.readAllBytes(path);
                }
                catch (NoSuchFileException e) {
                    LOG.info("file not found at path " + path);
                }
            }
            if (s3Bytes != null && fsBytes != null && !Objects.equals(s3MD5 = DigestUtils.md5Hex(s3Bytes), dbMD5 = DigestUtils.md5Hex(fsBytes))) {
                LOG.error("S3 data MD5: " + s3MD5 + " does not equal FS data MD5: " + dbMD5 + " for id: " + attachment.getAttachmentIdentifier());
            }
            return new ByteArrayInputStream(s3Bytes != null ? s3Bytes : fsBytes);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteAttachmentContents(Attachment attachment) {
        String fullPathUniqueFileName;
        File attachmentFile;
        if (!this.isS3IntegrationEnabled()) {
            super.deleteAttachmentContents(attachment);
            return;
        }
        if (attachment.getNote() == null) {
            throw new RuntimeException("Attachment.note must be set in order to delete the attachment");
        }
        this.riceS3FileService.deleteFile(attachment.getAttachmentIdentifier());
        if (this.isS3DualSaveEnabled() && (attachmentFile = new File(fullPathUniqueFileName = this.getDocumentDirectory(attachment.getNote().getRemoteObjectIdentifier()) + File.separator + attachment.getAttachmentIdentifier())).exists()) {
            attachmentFile.delete();
        }
    }

    @Override
    public void moveAttachmentWherePending(Note note) {
        if (!this.isS3IntegrationEnabled() || this.isS3DualSaveEnabled()) {
            super.moveAttachmentWherePending(note);
            return;
        }
        if (note == null) {
            throw new IllegalArgumentException("Note must be non-null");
        }
        if (StringUtils.isBlank((CharSequence)note.getObjectId())) {
            throw new IllegalArgumentException("Note does not have a valid object id, object id was null or empty");
        }
    }

    @Override
    public void deletePendingAttachmentsModifiedBefore(long modificationTime) {
        if (!this.isS3IntegrationEnabled() || this.isS3DualSaveEnabled()) {
            super.deletePendingAttachmentsModifiedBefore(modificationTime);
            return;
        }
    }

    @Override
    public Attachment getAttachmentByNoteId(Long noteId) {
        return super.getAttachmentByNoteId(noteId);
    }

    protected boolean isS3IntegrationEnabled() {
        if (this.parameterService.parameterExists("KR-SYS", "All", "S3_INTEGRATION_ENABLED").booleanValue()) {
            return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_INTEGRATION_ENABLED");
        }
        return false;
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isS3DualRetrieveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_RETRIEVE_ENABLED");
    }

    public S3FileService getRiceS3FileService() {
        return this.riceS3FileService;
    }

    public void setRiceS3FileService(S3FileService riceS3FileService) {
        this.riceS3FileService = riceS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

