/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;

public class DotConnector
implements Comparable<DotConnector> {
    private final TableColumn parentColumn;
    private final Table parentTable;
    private final TableColumn childColumn;
    private final Table childTable;
    private final boolean implied;
    private final boolean bottomJustify;
    private String parentPort;
    private String childPort;

    public DotConnector(TableColumn tableColumn, TableColumn tableColumn2, boolean bl) {
        this.parentColumn = tableColumn;
        this.childColumn = tableColumn2;
        this.implied = bl;
        this.parentPort = tableColumn.getName();
        this.parentTable = tableColumn.getTable();
        this.childPort = tableColumn2.getName();
        this.childTable = tableColumn2.getTable();
        this.bottomJustify = !Dot.getInstance().supportsCenteredEastWestEdges();
    }

    public boolean pointsTo(Table table) {
        return table.equals(this.parentTable);
    }

    public boolean isImplied() {
        return this.implied;
    }

    public void connectToParentDetails() {
        this.parentPort = this.parentColumn.getName() + ".type";
    }

    public void connectToParentTitle() {
        this.parentPort = "elipses";
    }

    public void connectToChildTitle() {
        this.childPort = "elipses";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  \"");
        if (this.childTable.isRemote()) {
            stringBuilder.append(this.childTable.getContainer());
            stringBuilder.append('.');
        }
        stringBuilder.append(this.childTable.getName());
        stringBuilder.append("\":\"");
        stringBuilder.append(this.childPort);
        stringBuilder.append("\":");
        if (this.bottomJustify) {
            stringBuilder.append("s");
        }
        stringBuilder.append("w -> \"");
        if (this.parentTable.isRemote()) {
            stringBuilder.append(this.parentTable.getContainer());
            stringBuilder.append('.');
        }
        stringBuilder.append(this.parentTable.getName());
        stringBuilder.append("\":\"");
        stringBuilder.append(this.parentPort);
        stringBuilder.append("\":");
        if (this.bottomJustify) {
            stringBuilder.append("s");
        }
        stringBuilder.append("e ");
        stringBuilder.append("[arrowhead=none");
        stringBuilder.append(" dir=back");
        stringBuilder.append(" arrowtail=");
        if (this.childColumn.isUnique()) {
            stringBuilder.append("teeodot");
        } else {
            stringBuilder.append("crowodot");
        }
        if (this.implied) {
            stringBuilder.append(" style=dashed");
        }
        stringBuilder.append("];");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(DotConnector dotConnector) {
        int n = this.childTable.compareTo(dotConnector.childTable);
        if (n == 0) {
            n = this.childColumn.getName().compareToIgnoreCase(dotConnector.childColumn.getName());
        }
        if (n == 0) {
            n = this.parentTable.compareTo(dotConnector.parentTable);
        }
        if (n == 0) {
            n = this.parentColumn.getName().compareToIgnoreCase(dotConnector.parentColumn.getName());
        }
        if (n == 0 && this.implied != dotConnector.implied) {
            n = this.implied ? 1 : -1;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DotConnector)) {
            return false;
        }
        return this.compareTo((DotConnector)object) == 0;
    }

    public int hashCode() {
        int n = this.parentTable == null ? 0 : this.parentTable.getName().hashCode();
        int n2 = this.childTable == null ? 0 : this.childTable.getName().hashCode();
        return n << 16 & n2;
    }

    public TableColumn getParentColumn() {
        return this.parentColumn;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public TableColumn getChildColumn() {
        return this.childColumn;
    }

    public Table getChildTable() {
        return this.childTable;
    }
}

