/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.version.history;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.version.history.VersionHistoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="versionHistoryDao")
public class VersionHistoryDaoJdbcImpl
implements VersionHistoryDao {
    private static final String AWARDS_BY_VERSION_STATUS = "select award_id, document_number from award where award_sequence_status in (%s)";
    private static final String IPS_BY_VERSION_STATUS = "select proposal_id, document_number from proposal where proposal_sequence_status in (%s)";
    private static final String SUBAWARDS_BY_VERSION_STATUS = "select subaward_id, document_number from subaward where subaward_sequence_status in (%s)";
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public Set<Long> getAwardIdsByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToIds(this.getVersionStatusResults(AWARDS_BY_VERSION_STATUS, versionStatuses));
    }

    @Override
    public Set<String> getAwardDocumentNumbersByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToDocNumbers(this.getVersionStatusResults(AWARDS_BY_VERSION_STATUS, versionStatuses));
    }

    @Override
    public Set<Long> getIPIdsByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToIds(this.getVersionStatusResults(IPS_BY_VERSION_STATUS, versionStatuses));
    }

    @Override
    public Set<String> getIPDocumentNumbersByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToDocNumbers(this.getVersionStatusResults(IPS_BY_VERSION_STATUS, versionStatuses));
    }

    @Override
    public Set<Long> getSubAwardIdsByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToIds(this.getVersionStatusResults(SUBAWARDS_BY_VERSION_STATUS, versionStatuses));
    }

    @Override
    public Set<String> getSubAwardDocumentNumbersByVersionStatus(Collection<String> versionStatuses) {
        return this.collectToDocNumbers(this.getVersionStatusResults(SUBAWARDS_BY_VERSION_STATUS, versionStatuses));
    }

    protected List<DocInfo> getVersionStatusResults(String queryString, Collection<String> versionStatuses) {
        String query = String.format(queryString, this.formatVersionStatusesForQuery(versionStatuses));
        return this.jdbcOperations.query(c -> c.prepareStatement(query), (rs, row) -> new DocInfo(rs.getLong(1), rs.getString(2)));
    }

    protected String formatVersionStatusesForQuery(Collection<String> versionStatuses) {
        return String.format("'%s'", String.join((CharSequence)"','", versionStatuses));
    }

    protected Set<Long> collectToIds(Collection<DocInfo> docInfos) {
        return docInfos.stream().map(DocInfo::getId).collect(Collectors.toSet());
    }

    protected Set<String> collectToDocNumbers(Collection<DocInfo> docInfos) {
        return docInfos.stream().map(DocInfo::getDocumentNumber).collect(Collectors.toSet());
    }

    protected class DocInfo {
        private Long id;
        private String documentNumber;

        protected DocInfo(Long id, String documentNumber) {
            this.id = id;
            this.documentNumber = documentNumber;
        }

        public Long getId() {
            return this.id;
        }

        public String getDocumentNumber() {
            return this.documentNumber;
        }
    }
}

