/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;
import org.kuali.rice.krms.api.repository.RepositoryDataException;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionParameterDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionRepositoryService;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.framework.engine.Function;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.expression.BinaryOperatorExpression;
import org.kuali.rice.krms.framework.engine.expression.BooleanValidatingExpression;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ConstantExpression;
import org.kuali.rice.krms.framework.engine.expression.Expression;
import org.kuali.rice.krms.framework.engine.expression.ExpressionBasedProposition;
import org.kuali.rice.krms.framework.engine.expression.FunctionExpression;
import org.kuali.rice.krms.framework.engine.expression.TermExpression;
import org.kuali.rice.krms.framework.type.FunctionTypeService;
import org.kuali.rice.krms.framework.type.PropositionTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;

public class SimplePropositionTypeService
implements PropositionTypeService {
    private FunctionRepositoryService functionRepositoryService;
    private TermRepositoryService termRepositoryService;
    private KrmsTypeResolver typeResolver;
    private ComparisonOperatorService comparisonOperatorService;

    public Proposition loadProposition(PropositionDefinition propositionDefinition) {
        return new ExpressionBasedProposition(this.translateToExpression(propositionDefinition));
    }

    protected Expression<Boolean> translateToExpression(PropositionDefinition propositionDefinition) {
        LinkedList<Object> stack = new LinkedList<Object>();
        for (PropositionParameter parameter : propositionDefinition.getParameters()) {
            PropositionParameterType parameterType = PropositionParameterType.fromCode((String)parameter.getParameterType());
            if (parameterType == PropositionParameterType.CONSTANT) {
                stack.addFirst(new ConstantExpression((Object)parameter.getValue()));
                continue;
            }
            if (parameterType == PropositionParameterType.FUNCTION) {
                String functionId = parameter.getValue();
                FunctionDefinition functionDefinition = this.functionRepositoryService.getFunction(functionId);
                if (functionDefinition == null) {
                    throw new RepositoryDataException("Unable to locate function with the given id: " + functionId);
                }
                FunctionTypeService functionTypeService = this.typeResolver.getFunctionTypeService(functionDefinition);
                Function function = functionTypeService.loadFunction(functionDefinition);
                List parameters = functionDefinition.getParameters();
                if (stack.size() < parameters.size()) {
                    throw new RepositoryDataException("Failed to initialize custom function '" + functionDefinition.getNamespace() + " " + functionDefinition.getName() + "'.  There were only " + stack.size() + " values on the stack but function requires at least " + parameters.size());
                }
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                for (int index = parameters.size() - 1; index >= 0; --index) {
                    FunctionParameterDefinition parameterDefinition = (FunctionParameterDefinition)parameters.get(index);
                    parameterDefinition.getParameterType();
                    Expression argument = (Expression)stack.removeFirst();
                    arguments.add(argument);
                }
                String[] parameterTypes = this.getFunctionParameterTypes(functionDefinition);
                stack.addFirst(new FunctionExpression(function, parameterTypes, arguments, this.getComparisonOperatorService()));
                continue;
            }
            if (parameterType == PropositionParameterType.OPERATOR) {
                ComparisonOperator operator = ComparisonOperator.fromCode((String)parameter.getValue());
                if (stack.size() < 2) {
                    throw new RepositoryDataException("Failed to initialize expression for comparison operator " + operator + " because a sufficient number of arguments was not available on the stack.  Current contents of stack: " + stack.toString());
                }
                Expression rhs = (Expression)stack.removeFirst();
                Expression lhs = (Expression)stack.removeFirst();
                stack.addFirst(new BinaryOperatorExpression(operator, lhs, rhs));
                continue;
            }
            if (parameterType != PropositionParameterType.TERM) continue;
            String termId = parameter.getValue();
            TermDefinition termDefinition = this.getTermRepositoryService().getTerm(termId);
            if (termDefinition == null) {
                throw new RepositoryDataException("unable to load term with id " + termId);
            }
            Term term = this.translateTermDefinition(termDefinition);
            stack.addFirst(new TermExpression(term));
        }
        if (stack.size() != 1) {
            throw new RepositoryDataException("Final contents of expression stack are incorrect, there should only be one entry but was " + stack.size() + ".  Current contents of stack: " + stack.toString());
        }
        return new BooleanValidatingExpression((Expression)stack.removeFirst());
    }

    private String[] getFunctionParameterTypes(FunctionDefinition functionDefinition) {
        String[] argumentTypes = null;
        List functionParameters = functionDefinition.getParameters();
        if (!CollectionUtils.isEmpty((Collection)functionParameters)) {
            argumentTypes = new String[functionParameters.size()];
            int argTypesIndex = 0;
            for (FunctionParameterDefinition functionParameter : functionParameters) {
                argumentTypes[argTypesIndex] = functionParameter.getParameterType();
                ++argTypesIndex;
            }
        }
        return argumentTypes;
    }

    protected Term translateTermDefinition(TermDefinition termDefinition) {
        if (termDefinition == null) {
            throw new RepositoryDataException("Given TermDefinition is null");
        }
        TermSpecificationDefinition termSpecificationDefinition = termDefinition.getSpecification();
        if (termSpecificationDefinition == null) {
            throw new RepositoryDataException("term with id " + termDefinition.getId() + " has a null specification");
        }
        List params = termDefinition.getParameters();
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)params)) {
            for (TermParameterDefinition param : params) {
                if (StringUtils.isBlank((String)param.getName())) {
                    throw new RepositoryDataException("TermParameterDefinition.name may not be blank");
                }
                paramsMap.put(param.getName(), param.getValue());
            }
        }
        return new Term(termSpecificationDefinition.getName(), paramsMap);
    }

    public void setFunctionRepositoryService(FunctionRepositoryService functionRepositoryService) {
        this.functionRepositoryService = functionRepositoryService;
    }

    public void setTypeResolver(KrmsTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public ComparisonOperatorService getComparisonOperatorService() {
        return this.comparisonOperatorService;
    }

    public void setComparisonOperatorService(ComparisonOperatorService comparisonOperatorService) {
        this.comparisonOperatorService = comparisonOperatorService;
    }

    public TermRepositoryService getTermRepositoryService() {
        return this.termRepositoryService;
    }

    public void setTermRepositoryService(TermRepositoryService termRepositoryService) {
        this.termRepositoryService = termRepositoryService;
    }
}

