/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAssociate;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public abstract class AbstractSubAwardAttachment
extends SubAwardAssociate
implements Comparable<AbstractSubAwardAttachment>,
KcFile {
    private static final Logger LOG = LogManager.getLogger(AbstractSubAwardAttachment.class);
    protected Integer attachmentId;
    protected String description;
    private transient FormFile newFile;
    protected Integer subAwardAttachmentTypeCode;
    protected Integer documentId;
    protected String fileName;
    protected String fileDataId;
    private String oldFileDataId;
    private transient SoftReference<byte[]> document;
    protected String mimeType;
    protected String documentStatusCode;
    protected boolean modifyAttachment = false;
    protected String lastUpdateUser;
    protected Timestamp lastUpdateTimestamp;
    private transient KcAttachmentDataDao kcAttachmentDataDao;

    public String getName() {
        return this.getFileName();
    }

    public String getType() {
        return this.getMimeType();
    }

    public byte[] getData() {
        return this.getDocument();
    }

    public byte[] getAttachmentContent() {
        return this.getDocument();
    }

    public String getContentType() {
        return this.getMimeType();
    }

    public void setContentType(String contentType) {
        this.setMimeType(contentType);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public byte[] getDocument() {
        byte[] existingData;
        if (this.document != null && (existingData = this.document.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDataDao().getData(this.fileDataId);
        this.document = new SoftReference<byte[]>(newData);
        return newData;
    }

    public void setDocument(byte[] document) {
        if (document == null || document.length == 0) {
            this.setFileDataId(null);
        } else {
            this.setFileDataId(this.getKcAttachmentDataDao().saveData(document, null));
        }
        this.document = new SoftReference<byte[]>(document);
    }

    public AbstractSubAwardAttachment() {
    }

    public AbstractSubAwardAttachment(SubAward subaward) {
        this.setSubAward(subaward);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getSubAwardAttachmentTypeCode() {
        return this.subAwardAttachmentTypeCode;
    }

    public void setSubAwardAttachmentTypeCode(Integer subAwardAttachmentTypeCode) {
        this.subAwardAttachmentTypeCode = subAwardAttachmentTypeCode;
    }

    public String getAttachmentDescription() {
        return "Subaward Attachment";
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Integer documentId) {
        this.documentId = documentId;
    }

    public FormFile getNewFile() {
        return this.newFile;
    }

    public void setNewFile(FormFile newFile) {
        this.newFile = newFile;
    }

    public Integer getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Integer attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isNew() {
        return this.getAttachmentId() == null;
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        if (this.getVersionNumber() == null) {
            this.setVersionNumber(0L);
        }
    }

    public String getLastUpdateUserName() {
        Person updateUser = KcServiceLocator.getService(PersonService.class).getPersonByPrincipalName(this.getLastUpdateUser());
        return updateUser != null ? updateUser.getName() : this.getUpdateUser();
    }

    public void populateAttachment() {
        FormFile newFile = this.getNewFile();
        if (newFile == null) {
            return;
        }
        try {
            byte[] newFileData = newFile.getFileData();
            this.setDocument(newFileData);
            if (newFileData.length > 0) {
                this.mimeType = newFile.getContentType();
                this.fileName = newFile.getFileName();
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String getDocumentStatusCode() {
        return this.documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public boolean isModifyAttachment() {
        return this.modifyAttachment;
    }

    public void setModifyAttachment(boolean modifyAttachment) {
        this.modifyAttachment = modifyAttachment;
    }

    @Override
    public void resetPersistenceState() {
        this.setAttachmentId(null);
    }

    @Override
    public int compareTo(AbstractSubAwardAttachment o) {
        return this.getAttachmentId().compareTo(o.getAttachmentId());
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(Timestamp lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    @Override
    public void prePersist() {
        super.prePersist();
        if (this.lastUpdateUser == null) {
            this.setLastUpdateUser(this.getUpdateUser());
        }
        if (this.lastUpdateTimestamp == null) {
            this.setLastUpdateTimestamp(this.getUpdateTimestamp());
        }
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        if (!StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)fileDataId)) {
            this.oldFileDataId = this.fileDataId;
        }
        this.fileDataId = fileDataId;
    }

    public void postRemove() {
        super.postRemove();
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDataDao().removeData(this.getFileDataId());
        }
    }

    public void postUpdate() {
        super.postUpdate();
        if (this.oldFileDataId != null && !StringUtils.equals((CharSequence)this.fileDataId, (CharSequence)this.oldFileDataId)) {
            this.getKcAttachmentDataDao().removeData(this.oldFileDataId);
            this.oldFileDataId = null;
        }
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        if (this.kcAttachmentDataDao == null) {
            this.kcAttachmentDataDao = KcServiceLocator.getService(KcAttachmentDataDao.class);
        }
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDao) {
        this.kcAttachmentDataDao = kcAttachmentDao;
    }

    public String getOldFileDataId() {
        return this.oldFileDataId;
    }

    public void setOldFileDataId(String oldFileDataId) {
        this.oldFileDataId = oldFileDataId;
    }
}

