/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;

@BeanTag(name="cssGridSizes-bean", parent="Uif-CssGridSizes")
public class CssGridSizes
extends UifDictionaryBeanBase {
    private static final long serialVersionUID = 4390107040745451681L;
    private String cssClassString;
    private int xsSize;
    private int smSize;
    private int mdSize;
    private int lgSize;
    private int smOffset = -1;
    private int mdOffset = -1;
    private int lgOffset = -1;

    public CssGridSizes() {
    }

    public CssGridSizes(int xsSize, int smSize, int mdSize, int lgSize) {
        this.xsSize = xsSize;
        this.smSize = smSize;
        this.mdSize = mdSize;
        this.lgSize = lgSize;
    }

    public String getCssClassString() {
        if (this.cssClassString != null) {
            return this.cssClassString;
        }
        this.cssClassString = "";
        this.concatenateSizeStyle(this.xsSize, "col-xs-", 1);
        this.concatenateSizeStyle(this.smSize, "col-sm-", 1);
        this.concatenateSizeStyle(this.smOffset, "col-sm-offset-", 0);
        this.concatenateSizeStyle(this.mdSize, "col-md-", 1);
        this.concatenateSizeStyle(this.mdOffset, "col-md-offset-", 0);
        this.concatenateSizeStyle(this.lgSize, "col-lg-", 1);
        this.concatenateSizeStyle(this.lgOffset, "col-lg-offset-", 0);
        this.cssClassString = this.cssClassString.trim();
        return this.cssClassString;
    }

    private void concatenateSizeStyle(int size, String cssClassPrefix, int minSize) {
        if (size >= minSize) {
            this.cssClassString = this.cssClassString + " " + cssClassPrefix + size;
        }
        if (size > 12) {
            throw new RuntimeException("Sizes in CssGridSizes cannot exceed 12");
        }
    }

    @BeanTagAttribute(name="xsSize")
    public int getXsSize() {
        return this.xsSize;
    }

    public void setXsSize(int xsSize) {
        this.xsSize = xsSize;
    }

    @BeanTagAttribute(name="smSize")
    public int getSmSize() {
        return this.smSize;
    }

    public void setSmSize(int smSize) {
        this.smSize = smSize;
    }

    @BeanTagAttribute(name="mdSize")
    public int getMdSize() {
        return this.mdSize;
    }

    public void setMdSize(int mdSize) {
        this.mdSize = mdSize;
    }

    @BeanTagAttribute(name="lgSize")
    public int getLgSize() {
        return this.lgSize;
    }

    public void setLgSize(int lgSize) {
        this.lgSize = lgSize;
    }

    @BeanTagAttribute(name="smOffset")
    public int getSmOffset() {
        return this.smOffset;
    }

    public void setSmOffset(int smOffset) {
        this.smOffset = smOffset;
    }

    @BeanTagAttribute(name="mdOffset")
    public int getMdOffset() {
        return this.mdOffset;
    }

    public void setMdOffset(int mdOffset) {
        this.mdOffset = mdOffset;
    }

    @BeanTagAttribute(name="lgOffset")
    public int getLgOffset() {
        return this.lgOffset;
    }

    public void setLgOffset(int lgOffset) {
        this.lgOffset = lgOffset;
    }

    @BeanTagAttribute(name="sizes", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public void setSizes(int[] sizes) {
        if (sizes == null || sizes.length != 4) {
            throw new RuntimeException("Sizes on CssGridSizes requires 4 and only 4 values.  Values that are not used can be set to 0 or less.");
        }
        this.xsSize = sizes[0];
        this.smSize = sizes[1];
        this.mdSize = sizes[2];
        this.lgSize = sizes[3];
    }

    @BeanTagAttribute(name="offsets", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public void setOffsets(int[] offsets) {
        if (offsets == null || offsets.length != 3) {
            throw new RuntimeException("Offset on CssGridSizes requires 3 and only 3 values.  Values that are not used can be set to -1 or less.");
        }
        this.smOffset = offsets[0];
        this.mdOffset = offsets[1];
        this.lgOffset = offsets[2];
    }

    public int getTotalSmSize() {
        int totalSmSize = this.smSize;
        if (totalSmSize == 0 && this.xsSize != 0) {
            totalSmSize = this.xsSize;
        }
        if (this.smOffset > -1) {
            return totalSmSize + this.smOffset;
        }
        return totalSmSize;
    }

    public int getTotalMdSize() {
        int totalMdSize = this.mdSize;
        if (totalMdSize == 0) {
            if (this.smSize != 0) {
                totalMdSize = this.smSize;
            } else if (this.xsSize != 0) {
                totalMdSize = this.xsSize;
            }
        }
        if (this.mdOffset > -1) {
            return totalMdSize + this.mdOffset;
        }
        if (this.smOffset > -1) {
            return totalMdSize + this.smOffset;
        }
        return totalMdSize;
    }

    public int getTotalLgSize() {
        int totalLgSize = this.lgSize;
        if (totalLgSize == 0) {
            if (this.mdSize != 0) {
                totalLgSize = this.mdSize;
            } else if (this.smSize != 0) {
                totalLgSize = this.smSize;
            } else if (this.xsSize != 0) {
                totalLgSize = this.xsSize;
            }
        }
        if (this.lgOffset > -1) {
            return totalLgSize + this.lgOffset;
        }
        if (this.mdOffset > -1) {
            return totalLgSize + this.mdOffset;
        }
        if (this.smOffset > -1) {
            return totalLgSize + this.smOffset;
        }
        return totalLgSize;
    }
}

