/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.property.source.CompositeSourcePropertyFactory;
import com.codiform.moo.property.source.SourcePropertyFactory;
import com.codiform.moo.translator.ArrayTranslator;
import com.codiform.moo.translator.CollectionTranslator;
import com.codiform.moo.translator.MapTranslator;
import com.codiform.moo.translator.ObjectTranslator;
import com.codiform.moo.translator.StringValueTypeTranslator;
import com.codiform.moo.translator.TranslatorFactory;
import com.codiform.moo.translator.ValueTypeTranslator;
import java.util.HashMap;
import java.util.Map;

public class CachingTranslatorFactory
implements TranslatorFactory {
    private Configuration configuration;
    private CollectionTranslator collectionTranslator;
    private MapTranslator mapTranslator;
    private Map<Class<?>, ValueTypeTranslator<?>> valueTypeTranslators;
    private ArrayTranslator arrayTranslator;
    private Map<Class<?>, ObjectTranslator<?>> translators;
    private SourcePropertyFactory sourcePropertyFactory;

    public CachingTranslatorFactory() {
        this(new Configuration(), new CompositeSourcePropertyFactory());
    }

    public CachingTranslatorFactory(Configuration configuration, SourcePropertyFactory sourcePropertyFactory) {
        this.configuration = configuration;
        this.collectionTranslator = new CollectionTranslator(configuration, sourcePropertyFactory);
        this.mapTranslator = new MapTranslator(configuration, sourcePropertyFactory);
        this.arrayTranslator = new ArrayTranslator(configuration);
        this.valueTypeTranslators = new HashMap();
        this.sourcePropertyFactory = sourcePropertyFactory;
        this.translators = new HashMap();
        this.initializeValueTypeTranslators();
    }

    private void initializeValueTypeTranslators() {
        this.valueTypeTranslators.put(String.class, new StringValueTypeTranslator());
    }

    @Override
    public synchronized <T> ObjectTranslator<T> getTranslator(Class<T> destinationClass) {
        if (this.translators.containsKey(destinationClass)) {
            return this.translators.get(destinationClass);
        }
        ObjectTranslator<T> objectTranslator = new ObjectTranslator<T>(destinationClass, this.configuration, this, this.sourcePropertyFactory);
        this.translators.put(destinationClass, objectTranslator);
        return objectTranslator;
    }

    @Override
    public CollectionTranslator getCollectionTranslator() {
        return this.collectionTranslator;
    }

    @Override
    public ArrayTranslator getArrayTranslator() {
        return this.arrayTranslator;
    }

    @Override
    public <V> ValueTypeTranslator<V> getValueTypeTranslator(Class<V> destinationType) {
        return this.valueTypeTranslators.get(destinationType);
    }

    @Override
    public MapTranslator getMapTranslator() {
        return this.mapTranslator;
    }
}

