/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.resourceloader;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.exception.RiceRemoteServiceConnectionException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.ParentChildResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderContainer;
import org.kuali.rice.core.api.resourceloader.ResourceLoaderException;
import org.kuali.rice.core.api.util.ClassLoaderUtils;

public class GlobalResourceLoader {
    private static final Logger LOG = LogManager.getLogger(GlobalResourceLoader.class);
    private static Map<ClassLoader, ResourceLoader> rootResourceLoaders = new HashMap<ClassLoader, ResourceLoader>();
    private static boolean initializing;

    public static synchronized ResourceLoader getResourceLoader() {
        ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
        return GlobalResourceLoader.getResourceLoaderCheckParent(classLoader);
    }

    private static synchronized ResourceLoader getResourceLoaderCheckParent(ClassLoader classLoader) {
        ResourceLoader parentResourceLoader;
        ResourceLoader resourceLoader = GlobalResourceLoader.getResourceLoader(classLoader);
        if (resourceLoader != null && classLoader.getParent() != null && (parentResourceLoader = GlobalResourceLoader.getResourceLoaderCheckParent(classLoader.getParent())) != null) {
            resourceLoader = new ParentChildResourceLoader(parentResourceLoader, resourceLoader);
        }
        if (resourceLoader == null && classLoader.getParent() != null) {
            resourceLoader = GlobalResourceLoader.getResourceLoaderCheckParent(classLoader.getParent());
        }
        return resourceLoader;
    }

    public static synchronized ResourceLoader getResourceLoader(ClassLoader classloader) {
        return rootResourceLoaders.get(classloader);
    }

    public static synchronized void start() throws Exception {
        try {
            initializing = true;
            ResourceLoader internalResourceLoader = GlobalResourceLoader.getResourceLoader();
            if (internalResourceLoader == null) {
                throw new RiceRuntimeException("Cannot start GlobalResourceLoader because no resource loaders have been added for the current ContextClassLoader :" + Thread.currentThread().getContextClassLoader());
            }
            internalResourceLoader.start();
        }
        finally {
            initializing = false;
        }
    }

    public static synchronized void addResourceLoader(ResourceLoader resourceLoader) {
        GlobalResourceLoader.initialize();
        if (resourceLoader == null) {
            throw new ResourceLoaderException("Attempted to add a null resource loader to the Global resource loader.");
        }
        LOG.info("Adding ResourceLoader " + resourceLoader.getName() + " to GlobalResourceLoader");
        GlobalResourceLoader.getResourceLoader().addResourceLoader(resourceLoader);
    }

    public static synchronized void addResourceLoaderFirst(ResourceLoader resourceLoader) {
        GlobalResourceLoader.initialize();
        if (resourceLoader == null) {
            throw new ResourceLoaderException("Attempted to add a null resource loader to the Global resource loader.");
        }
        LOG.info("Adding ResourceLoader " + resourceLoader.getName() + " to GlobalResourceLoader");
        GlobalResourceLoader.getResourceLoader().addResourceLoaderFirst(resourceLoader);
    }

    protected static synchronized void initialize() {
        if (GlobalResourceLoader.getResourceLoader(ClassLoaderUtils.getDefaultClassLoader()) == null) {
            LOG.info("Creating CompositeResourceLoader in GlobalResourceLoader");
            rootResourceLoaders.put(ClassLoaderUtils.getDefaultClassLoader(), new ResourceLoaderContainer(new QName(CoreConfigHelper.getApplicationId(), "ROOT_RESOURCE_LOADER_NAME")));
        }
    }

    public static synchronized ResourceLoader getResourceLoader(QName name) {
        return GlobalResourceLoader.getResourceLoader().getResourceLoader(name);
    }

    public static synchronized void stop() throws Exception {
        LOG.info("Stopping the GlobalResourceLoader...");
        if (GlobalResourceLoader.getResourceLoader(ClassLoaderUtils.getDefaultClassLoader()) != null) {
            LOG.info("Destroying GlobalResourceLoader");
            GlobalResourceLoader.getResourceLoader(ClassLoaderUtils.getDefaultClassLoader()).stop();
            rootResourceLoaders.remove(ClassLoaderUtils.getDefaultClassLoader());
        }
        LOG.info("...GlobalResourceLoader successfully stopped.");
    }

    public static <T> T getService(QName serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("The service name must be non-null.");
        }
        LOG.debug("GlobalResourceLoader fetching service " + serviceName);
        try {
            ResourceLoader resourceLoader = GlobalResourceLoader.getResourceLoader();
            return resourceLoader == null ? null : (T)resourceLoader.getService(serviceName);
        }
        catch (RiceRemoteServiceConnectionException ex) {
            LOG.warn(ex.getMessage());
            return null;
        }
    }

    public static <T> T getService(String localServiceName) {
        if (StringUtils.isEmpty((String)localServiceName)) {
            throw new IllegalArgumentException("The service name must be non-null.");
        }
        return GlobalResourceLoader.getService(new QName(localServiceName));
    }

    public static <T> T getObject(ObjectDefinition objectDefinition) {
        return GlobalResourceLoader.getResourceLoader().getObject(objectDefinition);
    }

    public static boolean isInitialized() {
        return GlobalResourceLoader.getResourceLoader() != null;
    }

    public static void logContents() {
        if (LOG.isInfoEnabled()) {
            LOG.info(GlobalResourceLoader.getResourceLoader().getContents("", false));
        }
    }

    public static void logAllContents() {
        if (LOG.isInfoEnabled()) {
            LOG.info("######################### Logging All Contents ###########################");
            for (ResourceLoader rl : rootResourceLoaders.values()) {
                LOG.info("Logging contents for ResourceLoader: " + rl.getName() + "\n" + rl.getContents("  ", true));
            }
            LOG.info("###################### Done Logging All Contents #########################");
        }
    }

    public static synchronized boolean isInitializing() {
        return initializing;
    }

    public static synchronized void setInitializing(boolean initializing) {
        GlobalResourceLoader.initializing = initializing;
    }
}

