/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.element.Pager;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="numberedPager", parent="Uif-NumberedPager")
public class NumberedPager
extends Pager {
    private static final long serialVersionUID = -6495003633052595157L;
    private int maxNumberedLinksShown;
    private boolean renderPrevNext;
    private boolean renderFirstLast;
    protected int pagesStart;
    protected int pagesEnd;
    private String firstText;
    private String lastText;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.maxNumberedLinksShown >= this.getNumberOfPages()) {
            this.pagesStart = 1;
            this.pagesEnd = this.getNumberOfPages();
        } else {
            int beforeAfterShown = (int)Math.floor((double)this.maxNumberedLinksShown / 2.0);
            this.pagesStart = this.getCurrentPage() - beforeAfterShown;
            this.pagesEnd = this.getCurrentPage() + beforeAfterShown;
            if (this.pagesEnd - this.pagesStart == this.maxNumberedLinksShown) {
                --this.pagesEnd;
            }
            if (this.pagesEnd > this.getNumberOfPages()) {
                this.pagesEnd = this.getNumberOfPages();
                this.pagesStart = this.getNumberOfPages() - this.maxNumberedLinksShown + 1;
            }
            if (this.pagesStart < 1) {
                this.pagesStart = 1;
                if (this.maxNumberedLinksShown < this.getNumberOfPages()) {
                    this.pagesEnd = this.maxNumberedLinksShown;
                }
            }
        }
    }

    @BeanTagAttribute
    public int getMaxNumberedLinksShown() {
        return this.maxNumberedLinksShown;
    }

    public void setMaxNumberedLinksShown(int maxNumberedLinksShown) {
        this.maxNumberedLinksShown = maxNumberedLinksShown;
    }

    @BeanTagAttribute
    public boolean isRenderFirstLast() {
        return this.renderFirstLast;
    }

    public void setRenderFirstLast(boolean renderFirstLast) {
        this.renderFirstLast = renderFirstLast;
    }

    @BeanTagAttribute
    public boolean isRenderPrevNext() {
        return this.renderPrevNext;
    }

    public void setRenderPrevNext(boolean renderPrevNext) {
        this.renderPrevNext = renderPrevNext;
    }

    public int getPagesStart() {
        return this.pagesStart;
    }

    public int getPagesEnd() {
        return this.pagesEnd;
    }

    @BeanTagAttribute
    public String getFirstText() {
        return this.firstText;
    }

    public void setFirstText(String firstText) {
        this.firstText = firstText;
    }

    @BeanTagAttribute
    public String getLastText() {
        return this.lastText;
    }

    public void setLastText(String lastText) {
        this.lastText = lastText;
    }
}

