/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TaskException;
import bitronix.tm.timer.TaskScheduler;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(RecoveryTask.class);
    private final Recoverer recoverer;

    public RecoveryTask(Recoverer recoverer, Date executionTime, TaskScheduler scheduler) {
        super(executionTime, scheduler);
        this.recoverer = recoverer;
    }

    public Object getObject() {
        return this.recoverer;
    }

    public void execute() throws TaskException {
        if (log.isDebugEnabled()) {
            log.debug("running recovery");
        }
        Thread recovery = new Thread(this.recoverer);
        recovery.setName("bitronix-recovery-thread");
        recovery.setDaemon(true);
        recovery.setPriority(4);
        recovery.start();
        Date nextExecutionDate = new Date(this.getExecutionTime().getTime() + (long)TransactionManagerServices.getConfiguration().getBackgroundRecoveryIntervalSeconds() * 1000L);
        if (log.isDebugEnabled()) {
            log.debug("rescheduling recovery for " + nextExecutionDate);
        }
        this.getTaskScheduler().scheduleRecovery(this.recoverer, nextExecutionDate);
    }

    public String toString() {
        return "a RecoveryTask scheduled for " + this.getExecutionTime();
    }
}

