/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.MessageProcessingException;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class MessageServiceInvoker
implements Runnable {
    protected static final Logger LOG = LogManager.getLogger(MessageServiceInvoker.class);
    private PersistedMessageBO message;

    public MessageServiceInvoker(PersistedMessageBO message) {
        this.message = message;
    }

    @Override
    public void run() {
        PersistedMessageBO messageFromDB;
        LOG.debug("calling service from persisted message " + this.getMessage().getRouteQueueId());
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("message.persistence").booleanValue() && (messageFromDB = KSBServiceLocator.getMessageQueueService().findByRouteQueueId(this.getMessage().getRouteQueueId())) == null) {
            LOG.warn("On message invocation, message payload not found for message " + this.getMessage());
            return;
        }
        try {
            KSBServiceLocator.getTransactionTemplate().execute(status -> {
                Object result1;
                AsynchronousCall methodCall = this.getMessage().getMethodCall();
                try {
                    result1 = this.invokeService(methodCall);
                    KSBServiceLocator.getMessageQueueService().delete(this.getMessage());
                }
                catch (Throwable t) {
                    LOG.warn("Caught throwable making async service call " + methodCall, t);
                    throw new MessageProcessingException(t);
                }
                return result1;
            });
        }
        catch (Throwable t) {
            boolean allowSyncExceptionRouting = Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty("rice.ksb.allowSyncExceptionRouting"));
            if (!allowSyncExceptionRouting && "synchronous".equals(ConfigContext.getCurrentContextConfig().getProperty("message.delivery"))) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RiceRuntimeException(t);
            }
            this.placeInExceptionRouting(t);
        }
    }

    protected void placeInExceptionRouting(Throwable t) {
        LOG.error("Error processing message: " + this.message, t);
        Throwable throwable = t instanceof MessageProcessingException ? t.getCause() : t;
        try {
            try {
                KSBServiceLocator.getExceptionRoutingService().placeInExceptionRouting(throwable, this.message);
            }
            catch (Throwable t1) {
                KSBServiceLocator.getExceptionRoutingService().placeInExceptionRoutingLastDitchEffort(throwable, this.message);
            }
        }
        catch (Throwable t2) {
            LOG.error("An error was encountered when invoking exception handler for message. Attempting to change message status to EXCEPTION.", t2);
            this.message.setQueueStatus("E");
            this.message.setQueueDate(new Timestamp(System.currentTimeMillis()));
            try {
                this.message = KSBServiceLocator.getMessageQueueService().save(this.message);
            }
            catch (Throwable t3) {
                LOG.fatal("Failed to flip status of message to EXCEPTION!!!", t3);
            }
        }
    }

    protected Object invokeService(AsynchronousCall methodCall) throws Exception {
        Object service;
        ServiceConfiguration serviceConfiguration = methodCall.getServiceConfiguration();
        QName serviceName = serviceConfiguration.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to call service " + serviceName);
        }
        if ((service = this.getService(serviceConfiguration)) == null) {
            throw new RiceRuntimeException("Failed to locate service endpoint for message: " + serviceConfiguration);
        }
        Method method = service.getClass().getMethod(methodCall.getMethodName(), methodCall.getParamTypes());
        return method.invoke(service, methodCall.getArguments());
    }

    protected Object getService(ServiceConfiguration serviceConfiguration) {
        Object service = serviceConfiguration.isQueue() ? this.getQueueService(serviceConfiguration) : this.getTopicService(serviceConfiguration);
        return service;
    }

    protected Object getTopicService(ServiceConfiguration serviceConfiguration) {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        Endpoint endpoint = serviceBus.getConfiguredEndpoint(serviceConfiguration);
        if (endpoint == null) {
            return null;
        }
        return endpoint.getService();
    }

    protected Object getQueueService(ServiceConfiguration serviceConfiguration) {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        return serviceBus.getService(serviceConfiguration.getServiceName(), serviceConfiguration.getApplicationId());
    }

    public PersistedMessageBO getMessage() {
        return this.message;
    }
}

