/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.suggest.document.CompletionFieldsConsumer;
import org.apache.lucene.search.suggest.document.CompletionFieldsProducer;

public abstract class CompletionPostingsFormat
extends PostingsFormat {
    static final int COMPLETION_CODEC_VERSION = 1;
    static final int COMPLETION_VERSION_CURRENT = 1;
    static final String INDEX_EXTENSION = "cmp";
    static final String DICT_EXTENSION = "lkp";
    private final FSTLoadMode fstLoadMode;

    public CompletionPostingsFormat(String name) {
        this(name, FSTLoadMode.ON_HEAP);
    }

    public CompletionPostingsFormat(String name, FSTLoadMode fstLoadMode) {
        super(name);
        this.fstLoadMode = fstLoadMode;
    }

    protected abstract PostingsFormat delegatePostingsFormat();

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        PostingsFormat delegatePostingsFormat = this.delegatePostingsFormat();
        if (delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new CompletionFieldsConsumer(this.getName(), delegatePostingsFormat, state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(this.getName(), state, this.fstLoadMode);
    }

    public static enum FSTLoadMode {
        OFF_HEAP,
        ON_HEAP,
        AUTO;

    }
}

