/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.parse.StringListConverter;
import org.kuali.rice.krad.datadictionary.parse.StringMapConverter;
import org.kuali.rice.krad.datadictionary.uif.ComponentBeanPostProcessor;
import org.kuali.rice.krad.uif.util.ExpressionFunctions;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class DataDictionaryPostProcessorUtils {
    private static final Logger LOG = LogManager.getLogger(DataDictionaryPostProcessorUtils.class);

    private DataDictionaryPostProcessorUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void setupProcessor(DefaultListableBeanFactory beans) {
        try {
            BeanPostProcessor idPostProcessor = (BeanPostProcessor)ComponentBeanPostProcessor.class.newInstance();
            beans.addBeanPostProcessor(idPostProcessor);
            beans.setBeanExpressionResolver((BeanExpressionResolver)new StandardBeanExpressionResolver(){

                protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
                    try {
                        evalContext.registerFunction("getService", ExpressionFunctions.class.getDeclaredMethod("getService", String.class));
                    }
                    catch (NoSuchMethodException me) {
                        LOG.error("Unable to register custom expression to data dictionary bean factory", (Throwable)me);
                    }
                }
            });
            GenericConversionService conversionService = new GenericConversionService();
            conversionService.addConverter((GenericConverter)new StringMapConverter());
            conversionService.addConverter((GenericConverter)new StringListConverter());
            beans.setConversionService((ConversionService)conversionService);
        }
        catch (Exception e1) {
            throw new DataDictionaryException("Cannot create component decorator post processor: " + e1.getMessage(), e1);
        }
    }
}

