/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.propdev.impl.attachment.AddNarrativeEvent;
import org.kuali.coeus.propdev.impl.attachment.AddNarrativeRule;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeRight;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.attachment.NewNarrativeUserRightsRule;
import org.kuali.coeus.propdev.impl.attachment.ReplaceNarrativeEvent;
import org.kuali.coeus.propdev.impl.attachment.ReplaceNarrativeRule;
import org.kuali.coeus.propdev.impl.attachment.SaveNarrativesEvent;
import org.kuali.coeus.propdev.impl.attachment.SaveNarrativesRule;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalDevelopmentNarrativeRule
extends KcTransactionalDocumentRuleBase
implements AddNarrativeRule,
ReplaceNarrativeRule,
SaveNarrativesRule,
NewNarrativeUserRightsRule {
    private static final String PROPOSAL = "Proposal";
    private static final String MODULE_STATUS_CODE_COMPLETED = "C";
    private static final String ERROR_PREFIX_FOR_ATTACHMENTS = "multipartFile";
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentNarrativeRule.class);
    private static final String NARRATIVE_TYPE = "narrativeType";
    private static final String MODULE_STATUS_CODE = "moduleStatusCode";
    private static final String NARRATIVE_TYPE_CODE = "narrativeTypeCode";
    private static final String MODULE_TITLE = "moduleTitle";
    private transient KcPersonService kcPersonService;
    private transient ParameterService parameterService;
    private transient KcAttachmentService kcAttachmentService;
    private transient KcAuthorizationService kcAuthorizationService;

    @Override
    public boolean processAddNarrativeBusinessRules(AddNarrativeEvent narrativeEvent) {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)narrativeEvent.getDocument();
        Narrative narrative = narrativeEvent.getNarrative();
        boolean rulePassed = true;
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship(NARRATIVE_TYPE);
        if (narrative.getNarrativeType() == null) {
            rulePassed = false;
        }
        if (!StringUtils.isBlank((CharSequence)narrative.getModuleStatusCode()) && narrative.getModuleStatusCode().equalsIgnoreCase(MODULE_STATUS_CODE_COMPLETED) && StringUtils.isBlank((CharSequence)narrative.getName())) {
            LOG.debug("error.proposalAttachment.moduleStatusCode.invalid");
            this.reportError(MODULE_STATUS_CODE, "error.proposalAttachment.moduleStatusCode.invalid", new String[0]);
            rulePassed = false;
        }
        rulePassed &= this.getDictionaryValidationService().isBusinessObjectValid((Object)narrative);
        rulePassed &= this.checkNarrative(document.getDevelopmentProposal().getNarratives(), narrative);
        rulePassed &= this.validFileNameCharacters(narrative);
        rulePassed &= this.validModuleTitle(narrative, document.getDevelopmentProposal());
        boolean isCompleteOrHasMultipartFile = narrative.getModuleStatusCode().equals(MODULE_STATUS_CODE_COMPLETED) || narrative.getMultipartFile() != null;
        boolean isS2S = document.getDevelopmentProposal().hasS2sOpportunity();
        if (isCompleteOrHasMultipartFile && isS2S && document.getDevelopmentProposal().isNIHSponsor()) {
            rulePassed &= this.getKcFileService().validPDFFile(narrative, this.getErrorReporter(), ERROR_PREFIX_FOR_ATTACHMENTS);
        }
        return rulePassed;
    }

    protected boolean validModuleTitle(Narrative narrative, DevelopmentProposal developmentProposal) {
        if (StringUtils.contains((CharSequence)narrative.getModuleTitle(), (int)38) && developmentProposal.hasS2sOpportunity() && narrative.getNarrativeType().isAllowMultiple()) {
            this.reportError(MODULE_TITLE, "error.proposalAttachment.description.illegalCharacters", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validFileNameCharacters(Narrative narrative) {
        String attachmentFileName = narrative.getName();
        KcAttachmentService attachmentService = this.getKcFileService();
        boolean rulePassed = true;
        String invalidCharacters = attachmentService.getInvalidCharacters(attachmentFileName);
        if (ObjectUtils.isNotNull((Object)invalidCharacters)) {
            String parameter = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "INVALID_FILE_NAME_CHECK");
            if ("2".equals(parameter)) {
                rulePassed = false;
                this.reportError(ERROR_PREFIX_FOR_ATTACHMENTS, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
            } else {
                rulePassed = true;
                this.reportWarning(ERROR_PREFIX_FOR_ATTACHMENTS, "error.institutionalProposal.notesAndAttachments.fileName.invalid", attachmentFileName, invalidCharacters);
            }
        }
        return rulePassed;
    }

    @Override
    public boolean processSaveNarrativesBusinessRules(SaveNarrativesEvent saveNarrativesEvent) {
        Narrative narrative = saveNarrativesEvent.getNarrative();
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship(NARRATIVE_TYPE);
        List<Narrative> narrativeList = saveNarrativesEvent.getNarratives();
        GlobalVariables.getMessageMap().getErrorPath().clear();
        GlobalVariables.getMessageMap().getErrorPath().add(saveNarrativesEvent.getErrorPathPrefix());
        boolean rulePassed = this.checkNarrative(narrativeList, saveNarrativesEvent.getNarrative());
        rulePassed &= this.validFileNameCharacters(narrative);
        rulePassed &= this.checkUserRights(saveNarrativesEvent);
        if (!StringUtils.isBlank((CharSequence)narrative.getModuleStatusCode()) && narrative.getModuleStatusCode().equalsIgnoreCase(MODULE_STATUS_CODE_COMPLETED) && StringUtils.isBlank((CharSequence)narrative.getName())) {
            LOG.debug("error.proposalAttachment.moduleStatusCode.invalid");
            this.reportError(MODULE_STATUS_CODE, "error.proposalAttachment.moduleStatusCode.invalid", new String[0]);
            rulePassed = false;
        }
        return rulePassed;
    }

    @Override
    public boolean processReplaceNarrativeBusinessRules(ReplaceNarrativeEvent replaceNarrativeEvent) {
        Narrative narrative = replaceNarrativeEvent.getNarrative();
        boolean rulePassed = true;
        this.getDataObjectService().wrap((Object)narrative).fetchRelationship(NARRATIVE_TYPE);
        MessageMap map = GlobalVariables.getMessageMap();
        if (narrative.getNarrativeType() == null) {
            rulePassed = false;
        }
        rulePassed &= this.validFileNameCharacters(narrative);
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)replaceNarrativeEvent.getDocument();
        boolean isS2S = document.getDevelopmentProposal().hasS2sOpportunity();
        if (isS2S && document.getDevelopmentProposal().isNIHSponsor()) {
            rulePassed &= this.getKcFileService().validPDFFile(narrative, this.getErrorReporter(), ERROR_PREFIX_FOR_ATTACHMENTS);
        }
        map.addToErrorPath(replaceNarrativeEvent.getErrorPathPrefix());
        map.removeFromErrorPath(replaceNarrativeEvent.getErrorPathPrefix());
        return rulePassed &= this.getDictionaryValidationService().isBusinessObjectValid((Object)narrative);
    }

    private boolean checkUserRights(SaveNarrativesEvent saveNarrativesEvent) {
        boolean isValid = true;
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        List<Narrative> narratives = saveNarrativesEvent.getNarratives();
        List<Narrative> originalNarratives = saveNarrativesEvent.getOriginalNarratives();
        for (Narrative origNarrative : originalNarratives) {
            Narrative narrative;
            NarrativeUserRights userRights = this.getUserRights(userId, origNarrative);
            if (userRights == null || !StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) && !StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)NarrativeRight.NO_NARRATIVE_RIGHT.getAccessType()) || origNarrative.equals(narrative = this.findNarrative(narratives, origNarrative))) continue;
            isValid = false;
            this.reportError(NARRATIVE_TYPE_CODE, "error.proposalAttachment.notAuthorized", origNarrative.getNarrativeType().getDescription());
        }
        return isValid;
    }

    private NarrativeUserRights getUserRights(String userId, Narrative narrative) {
        List<NarrativeUserRights> userRightsList = narrative.getNarrativeUserRights();
        for (NarrativeUserRights userRights : userRightsList) {
            String personId = userRights.getUserId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            if (!StringUtils.equals((CharSequence)userId, (CharSequence)person.getPersonId())) continue;
            return userRights;
        }
        return null;
    }

    private Narrative findNarrative(List<Narrative> narratives, Narrative origNarrative) {
        for (Narrative narrative : narratives) {
            if (!narrative.getModuleNumber().equals(origNarrative.getModuleNumber())) continue;
            return narrative;
        }
        return null;
    }

    private boolean checkNarrative(List<Narrative> narrativeList, Narrative narrative) {
        boolean rulePassed = true;
        if (StringUtils.isBlank((CharSequence)narrative.getNarrativeTypeCode())) {
            rulePassed = false;
            this.reportError(NARRATIVE_TYPE_CODE, "error.proposalAttachment.narrativeType.notSelected", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)narrative.getModuleStatusCode())) {
            rulePassed = false;
            this.reportError(MODULE_STATUS_CODE, "error.proposalAttachment.narrativeStatus.notSelected", new String[0]);
        }
        if (rulePassed) {
            String[] param = new String[]{PROPOSAL, narrative.getNarrativeType().getDescription()};
            if (!narrative.getNarrativeType().isAllowMultiple()) {
                int matches = 0;
                for (Narrative narr : narrativeList) {
                    if (narr == null || !StringUtils.equals((CharSequence)narr.getNarrativeTypeCode(), (CharSequence)narrative.getNarrativeTypeCode()) || ++matches <= 1) continue;
                    LOG.debug("error.proposalAttachment.narrativeType.allowMulitple");
                    this.reportError(NARRATIVE_TYPE_CODE, "error.proposalAttachment.narrativeType.allowMulitple", param);
                    rulePassed = false;
                    break;
                }
            } else if (StringUtils.isBlank((CharSequence)narrative.getModuleTitle())) {
                this.reportError(MODULE_TITLE, "error.proposalAttachment.description.required", param);
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    @Override
    public boolean processNewNarrativeUserRightsBusinessRules(ProposalDevelopmentDocument document, List<NarrativeUserRights> newNarrativeUserRights, int narrativeIndex) {
        boolean isValid = true;
        if (!this.hasNarrativeRight(newNarrativeUserRights, NarrativeRight.MODIFY_NARRATIVE_RIGHT)) {
            isValid = false;
            this.reportError("newNarrativeUserRight", "error.narrative.one.modify", new String[0]);
        }
        for (NarrativeUserRights userRights : newNarrativeUserRights) {
            if (this.hasPermission(userRights, document)) continue;
            isValid = false;
            String personId = userRights.getUserId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            this.reportError("newNarrativeUserRight", "error.narrative.no.permission", person.getFullName());
        }
        return isValid;
    }

    private boolean hasNarrativeRight(List<NarrativeUserRights> narrativeUserRights, NarrativeRight narrativeRight) {
        for (NarrativeUserRights userRights : narrativeUserRights) {
            if (!StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)narrativeRight.getAccessType())) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(NarrativeUserRights userRights, ProposalDevelopmentDocument doc) {
        String personId = userRights.getUserId();
        return !(StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)NarrativeRight.MODIFY_NARRATIVE_RIGHT.getAccessType()) ? !this.hasPermission(personId, doc, "Modify Narrative") : StringUtils.equals((CharSequence)userRights.getAccessType(), (CharSequence)NarrativeRight.VIEW_NARRATIVE_RIGHT.getAccessType()) && !this.hasPermission(personId, doc, "View Narratives"));
    }

    protected KcAttachmentService getKcFileService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected KcAuthorizationService getKcAuthorizationService() {
        if (this.kcAuthorizationService == null) {
            this.kcAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        }
        return this.kcAuthorizationService;
    }

    protected boolean hasPermission(String userId, Permissionable doc, String permissionName) {
        return this.getKcAuthorizationService().hasPermission(userId, doc, permissionName);
    }
}

