/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.w3c.dom.Element;

@XmlRootElement(name="documentActionParameters")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentActionParametersType", propOrder={"documentId", "principalId", "annotation", "documentUpdate", "documentContentUpdate", "_futureElements"})
public final class DocumentActionParameters
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -7589214734683758734L;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="principalId", required=true)
    private final String principalId;
    @XmlElement(name="annotation", required=false)
    private final String annotation;
    @XmlElement(name="documentUpdate", required=false)
    private final DocumentUpdate documentUpdate;
    @XmlElement(name="documentContentUpdate", required=false)
    private final DocumentContentUpdate documentContentUpdate;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentActionParameters() {
        this.documentId = null;
        this.principalId = null;
        this.annotation = null;
        this.documentUpdate = null;
        this.documentContentUpdate = null;
    }

    private DocumentActionParameters(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.principalId = builder.getPrincipalId();
        this.annotation = builder.getAnnotation();
        this.documentUpdate = builder.getDocumentUpdate();
        this.documentContentUpdate = builder.getDocumentContentUpdate();
    }

    public static DocumentActionParameters create(String documentId, String principalId) {
        return DocumentActionParameters.create(documentId, principalId, "");
    }

    public static DocumentActionParameters create(String documentId, String principalId, String annotation) {
        Builder builder = Builder.create(documentId, principalId);
        builder.setAnnotation(annotation);
        return builder.build();
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public DocumentUpdate getDocumentUpdate() {
        return this.documentUpdate;
    }

    public DocumentContentUpdate getDocumentContentUpdate() {
        return this.documentContentUpdate;
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String PRINCIPAL_ID = "principalId";
        static final String ANNOTATION = "annotation";
        static final String DOCUMENT_UPDATE = "documentUpdate";
        static final String DOCUMENT_CONTENT_UPDATE = "documentContentUpdate";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentActionParameters";
        static final String TYPE_NAME = "DocumentActionParametersType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder {
        private static final long serialVersionUID = -9209748637365086000L;
        private String documentId;
        private String principalId;
        private String annotation;
        private DocumentUpdate documentUpdate;
        private DocumentContentUpdate documentContentUpdate;

        private Builder(String documentId, String principalId) {
            this.setDocumentId(documentId);
            this.setPrincipalId(principalId);
        }

        public static Builder create(String documentId, String principalId) {
            return new Builder(documentId, principalId);
        }

        public DocumentActionParameters build() {
            return new DocumentActionParameters(this);
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            if (StringUtils.isBlank((String)principalId)) {
                throw new IllegalArgumentException("principalId was null or blank");
            }
            this.principalId = principalId;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public DocumentUpdate getDocumentUpdate() {
            return this.documentUpdate;
        }

        public void setDocumentUpdate(DocumentUpdate documentUpdate) {
            this.documentUpdate = documentUpdate;
        }

        public DocumentContentUpdate getDocumentContentUpdate() {
            return this.documentContentUpdate;
        }

        public void setDocumentContentUpdate(DocumentContentUpdate documentContentUpdate) {
            this.documentContentUpdate = documentContentUpdate;
        }
    }
}

