/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Signature;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kuali.rice.ksb.security.DigitalSigner;
import org.kuali.rice.ksb.security.ResponseHeaderDigitalSigner;
import org.kuali.rice.ksb.security.SignatureSigningOutputStream;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class SignatureSigningResponseWrapper
extends HttpServletResponseWrapper {
    private DigitalSigner signer;
    private ServletOutputStream outputStream;
    private PrintWriter writer;

    public SignatureSigningResponseWrapper(HttpServletResponse response) {
        super(response);
        try {
            Signature signature = KSBServiceLocator.getDigitalSignatureService().getSignatureForSigning();
            String alias = KSBServiceLocator.getJavaSecurityManagementService().getModuleKeyStoreAlias();
            this.signer = new ResponseHeaderDigitalSigner(signature, alias, response);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize digital signature verification.", e);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new SignatureSigningOutputStream(this.signer, (OutputStream)super.getOutputStream(), true);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)this.getOutputStream());
        }
        return this.writer;
    }
}

