/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment.document;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.excon.shipment.ExconIntlShipment;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ExconIntlShipmentDocumentRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule,
DocumentAuditRule {
    private static final String NEW_EXCON_INTL_SHIPMENT = "document.exconIntlShipmentList[0]";

    public boolean processAddExconProjectBusinessRules(ExconIntlShipment exconIntlShipment) {
        boolean rulePassed = true;
        return rulePassed &= this.processSaveExconIntlShipmentBusinessRules(exconIntlShipment, NEW_EXCON_INTL_SHIPMENT);
    }

    protected boolean processSaveExconIntlShipmentBusinessRules(ExconIntlShipment exconIntlShipment, String propertyPrefix) {
        boolean rulePassed = true;
        if (exconIntlShipment.getRestrictedExport() == null) {
            this.reportError(propertyPrefix + ".restrictedExport", "error.generic.required.field", "Restricted Export question");
            rulePassed = false;
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getShipmentDescription())) {
            this.reportError(propertyPrefix + ".shipmentDescription", "error.generic.required.field", "Shipment Description");
            rulePassed = false;
        }
        if (exconIntlShipment.getRestrictedCountry() == null) {
            this.reportError(propertyPrefix + ".restrictedCountry", "error.generic.required.field", "Restricted Country question");
            rulePassed = false;
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getCountryCode())) {
            this.reportError(propertyPrefix + ".countryCode", "error.generic.required.field", "Country");
            rulePassed = false;
        }
        if (exconIntlShipment.getRestrictedParty() == null) {
            this.reportError(propertyPrefix + ".restrictedParty", "error.generic.required.field", "Restricted Party question");
            rulePassed = false;
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getReceivingParty())) {
            this.reportError(propertyPrefix + ".receivingParty", "error.generic.required.field", "Receiving Party");
            rulePassed = false;
        }
        if (!exconIntlShipment.getCertificationInd().booleanValue()) {
            this.reportError(propertyPrefix + ".certificationInd", "error.excon.shipment.not.certified", new String[0]);
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getApplicantId())) {
            this.reportError(propertyPrefix + ".applicantId", "error.generic.required.field", "Applicant");
            rulePassed = false;
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getSupervisorId())) {
            this.reportError(propertyPrefix + ".supervisorId", "error.generic.required.field", "Supervisor");
            rulePassed = false;
        }
        if (StringUtils.isEmpty((CharSequence)exconIntlShipment.getUnitNumber())) {
            this.reportError(propertyPrefix + ".unitNumber", "error.generic.required.field", "Unit");
            rulePassed = false;
        }
        return rulePassed;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        return true;
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return document instanceof ExconIntlShipmentDocument;
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }
}

