/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.document;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.KEWPropertyConstants;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintenanceLock;

public class RoutingRuleMaintainable
extends KualiMaintainableImpl {
    private static final long serialVersionUID = -5920808902137192662L;

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        if (this.getNewRule(document) != null) {
            this.getNewRule(document).setRuleTemplate((RuleTemplateBo)((Object)this.getDataObjectService().find(RuleTemplateBo.class, (Object)this.getNewRule(document).getRuleTemplateId())));
        }
        if (this.getOldRule(document) != null) {
            this.getOldRule(document).setRuleTemplate((RuleTemplateBo)((Object)this.getDataObjectService().find(RuleTemplateBo.class, (Object)this.getOldRule(document).getRuleTemplateId())));
        }
        List sections = super.getSections(document, oldMaintainable);
        return WebRuleUtils.customizeSections(this.getThisRule(), sections, false);
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        WebRuleUtils.validateRuleTemplateAndDocumentType(this.getOldRule(document), this.getNewRule(document), parameters);
        WebRuleUtils.establishDefaultRuleValues(this.getNewRule(document));
        this.getNewRule(document).setDocumentId(document.getDocumentHeader().getDocumentNumber());
    }

    public void setGenerateBlankRequiredValues(String docTypeName) {
    }

    public void saveBusinessObject() {
        WebRuleUtils.clearKeysForSave(this.getThisRule());
        WebRuleUtils.translateResponsibilitiesForSave(this.getThisRule());
        WebRuleUtils.translateFieldValuesForSave(this.getThisRule());
        KEWServiceLocator.getRuleService().makeCurrent(this.getThisRule(), true);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        WebRuleUtils.processRuleForCopy(document.getDocumentNumber(), this.getOldRule(document), this.getNewRule(document));
        super.processAfterCopy(document, parameters);
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> parameters) {
        if (!this.getOldRule(document).getCurrentInd().booleanValue()) {
            throw new RiceRuntimeException("Cannot edit a non-current version of a rule.");
        }
        WebRuleUtils.populateForCopyOrEdit(this.getOldRule(document), this.getNewRule(document));
        this.getNewRule(document).setPreviousRuleId(this.getOldRule(document).getId());
        this.getNewRule(document).setDocumentId(document.getDocumentHeader().getDocumentNumber());
        super.processAfterEdit(document, parameters);
    }

    protected RuleBaseValues getNewRule(MaintenanceDocument document) {
        return (RuleBaseValues)document.getNewMaintainableObject().getBusinessObject();
    }

    protected RuleBaseValues getOldRule(MaintenanceDocument document) {
        return (RuleBaseValues)document.getOldMaintainableObject().getBusinessObject();
    }

    protected RuleBaseValues getThisRule() {
        return (RuleBaseValues)this.getBusinessObject();
    }

    public List<MaintenanceLock> generateMaintenanceLocks() {
        if (this.getThisRule().getPreviousRuleId() == null) {
            return Collections.emptyList();
        }
        return super.generateMaintenanceLocks();
    }

    public String getDocumentTitle(MaintenanceDocument document) {
        StringBuffer title = new StringBuffer();
        RuleBaseValues rule = this.getThisRule();
        if (rule.getPreviousRuleId() != null) {
            title.append("Editing Rule '").append(rule.getDescription()).append("'");
        } else {
            title.append("Adding Rule '").append(rule.getDescription()).append("'");
        }
        return title.toString();
    }

    protected void setNewCollectionLineDefaultValues(String collectionName, PersistableBusinessObject addLine) {
        RuleTemplateBo ruleTemplate;
        super.setNewCollectionLineDefaultValues(collectionName, addLine);
        if (KEWPropertyConstants.RESP_SECTION_NAME_SET.contains(collectionName) && (ruleTemplate = this.getThisRule().getRuleTemplate()).getDefaultActionRequestValue() != null && ruleTemplate.getDefaultActionRequestValue().getValue() != null) {
            ((RuleResponsibilityBo)addLine).setActionRequestedCd(ruleTemplate.getDefaultActionRequestValue().getValue());
        }
    }
}

