/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.krms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;

@Component(value="proposalDevelopmentFactBuilderService")
public class ProposalDevelopmentFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private static final String COMPLETE = "C";
    public static final String DOCUMENT_NUMBER = "//document/documentNumber";
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, DOCUMENT_NUMBER);
        try {
            ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, proposalDevelopmentDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        this.addBudgetFacts(factsBuilder, proposalDevelopmentDocument);
        this.addProposalFacts(factsBuilder, developmentProposal);
        factsBuilder.addFact("moduleCode", (Object)"3");
        factsBuilder.addFact("moduleItemKey", (Object)developmentProposal.getProposalNumber());
        factsBuilder.addFact("moduleSubItemKey", (Object)0);
    }

    private void addBudgetFacts(Facts.Builder factsBuilder, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalDevelopmentBudgetExt budget = proposalDevelopmentDocument.getDevelopmentProposal().getFinalBudget();
        this.addObjectMembersAsFacts(factsBuilder, budget, "KC-PD-CONTEXT", "KC-PD");
    }

    private void addProposalFacts(Facts.Builder factsBuilder, DevelopmentProposal developmentProposal) {
        this.addObjectMembersAsFacts(factsBuilder, developmentProposal, "KC-PD-CONTEXT", "KC-PD");
        factsBuilder.addFact("DevelopmentProposal", (Object)developmentProposal);
        factsBuilder.addFact("proposalNarrativesComplete", (Object)this.isProposalNarrativesComplete(developmentProposal));
    }

    protected boolean isProposalNarrativesComplete(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (narrative.getNarrativeStatus() == null || COMPLETE.equals(narrative.getNarrativeStatus().getCode())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getElementValue(String docContent, String xpathExpression) {
        String string;
        ByteArrayInputStream stream = new ByteArrayInputStream(docContent.getBytes());
        try {
            Document document = XmlHelper.trimXml((InputStream)stream);
            XPath xpath = XPathHelper.newXPath();
            string = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RiceRuntimeException((Throwable)e);
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

