/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.Cfda.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.cfda.CFDA;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.external.Cfda.CfdaDTO;
import org.kuali.kra.external.Cfda.service.CfdaNumberService;
import org.kuali.kra.external.HashMapElement;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class CfdaNumberServiceImpl
implements CfdaNumberService {
    private static final Logger LOG = LogManager.getLogger(CfdaNumberServiceImpl.class);
    private BusinessObjectService businessObjectService;

    @Override
    public List<CfdaDTO> getCfdaNumber(String financialAccountNumber, String financialChartOfAccounts) {
        List<Award> awards = this.getAwards(financialAccountNumber, financialChartOfAccounts);
        if (ObjectUtils.isNotNull(awards)) {
            return awards.stream().flatMap(award -> award.getAwardCfdas().stream()).map(awardCfda -> {
                CFDA cfda = (CFDA)this.businessObjectService.findByPrimaryKey(CFDA.class, Collections.singletonMap("cfdaNumber", awardCfda.getCfdaNumber()));
                if (ObjectUtils.isNotNull((Object)cfda)) {
                    CfdaDTO cfdaDTO = this.boToDTO(cfda);
                    cfdaDTO.setAwardId("" + awardCfda.getAwardId());
                    return cfdaDTO;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<CfdaDTO> lookupCfda(List<HashMapElement> criteria) {
        ArrayList cfdaNumbers;
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        if (ObjectUtils.isNull(criteria)) {
            cfdaNumbers = new ArrayList(this.businessObjectService.findAll(CFDA.class));
        } else {
            for (HashMapElement element : criteria) {
                searchCriteria.put(element.getKey(), element.getValue());
            }
            cfdaNumbers = new ArrayList(this.businessObjectService.findMatching(CFDA.class, searchCriteria));
        }
        ArrayList<CfdaDTO> cfdaDTOs = new ArrayList<CfdaDTO>();
        for (CFDA cfda : cfdaNumbers) {
            cfdaDTOs.add(this.boToDTO(cfda));
        }
        return cfdaDTOs;
    }

    protected CfdaDTO boToDTO(CFDA cfda) {
        CfdaDTO cfdaDTO = new CfdaDTO();
        cfdaDTO.setCfdaMaintenanceTypeId(cfda.getCfdaMaintenanceTypeId());
        cfdaDTO.setCfdaNumber(cfda.getCfdaNumber());
        cfdaDTO.setCfdaProgramTitleName(cfda.getCfdaProgramTitleName());
        cfdaDTO.setActive(cfda.getActive());
        return cfdaDTO;
    }

    protected List<Award> getAwards(String financialAccountNumber, String chartOfAccounts) {
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("accountNumber", financialAccountNumber);
        searchCriteria.put("financialChartOfAccountsCode", chartOfAccounts);
        ArrayList<Award> awards = new ArrayList<Award>(this.businessObjectService.findMatching(Award.class, searchCriteria));
        if (ObjectUtils.isNotNull(awards) && !awards.isEmpty()) {
            return awards;
        }
        LOG.warn("No award found for the account number " + financialAccountNumber + " and chart chartOfAccounts");
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

