/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.criteria;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kuali.rice.core.api.criteria.CriteriaValue;

@XmlRootElement(name="decimalValue")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CriteriaDecimalValueType")
public final class CriteriaDecimalValue
implements CriteriaValue<BigDecimal> {
    @XmlValue
    private final BigDecimal value;

    CriteriaDecimalValue() {
        this.value = null;
    }

    CriteriaDecimalValue(BigDecimal value) {
        CriteriaDecimalValue.validateValue(value);
        this.value = CriteriaDecimalValue.safeInstance(value);
    }

    CriteriaDecimalValue(Number value) {
        CriteriaDecimalValue.validateValue(value);
        this.value = BigDecimal.valueOf(value.doubleValue());
    }

    private static void validateValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
    }

    private static BigDecimal safeInstance(BigDecimal val) {
        if (val.getClass() != BigDecimal.class) {
            return new BigDecimal(val.toPlainString());
        }
        return val;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "decimalValue";
        static final String TYPE_NAME = "CriteriaDecimalValueType";

        Constants() {
        }
    }
}

