/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.UserAlias;

public abstract class SelectionCriteria
implements Serializable {
    static final long serialVersionUID = -5194901539702756536L;
    protected static final String EQUAL = " = ";
    protected static final String NOT_EQUAL = " <> ";
    protected static final String GREATER = " > ";
    protected static final String NOT_GREATER = " <= ";
    protected static final String LESS = " < ";
    protected static final String NOT_LESS = " >= ";
    protected static final String LIKE = " LIKE ";
    protected static final String NOT_LIKE = " NOT LIKE ";
    protected static final String IS_NULL = " IS NULL ";
    protected static final String NOT_IS_NULL = " IS NOT NULL ";
    protected static final String BETWEEN = " BETWEEN ";
    protected static final String NOT_BETWEEN = " NOT BETWEEN ";
    protected static final String IN = " IN ";
    protected static final String NOT_IN = " NOT IN ";
    private Object m_attribute;
    private Object m_value;
    private boolean m_bound = false;
    private int m_numberOfExtentsToBind = 0;
    private String m_alias = null;
    private UserAlias m_userAlias = null;
    private boolean m_translateAttribute = true;
    private Criteria m_criteria;

    SelectionCriteria(Object object, Object object2, String string) {
        if (!(object instanceof String) && !(object instanceof Query)) {
            throw new IllegalArgumentException("An attribute must be a String or a Query !");
        }
        this.m_attribute = object;
        this.m_value = object2;
        this.m_bound = !this.isBindable();
        this.m_alias = string;
        this.m_userAlias = this.m_alias == null ? null : new UserAlias(this.m_alias, (String)this.getAttribute(), true);
    }

    SelectionCriteria(Object object, Object object2, UserAlias userAlias) {
        if (!(object instanceof String) && !(object instanceof Query)) {
            throw new IllegalArgumentException("An attribute must be a String or a Query !");
        }
        this.m_attribute = object;
        this.m_value = object2;
        this.m_bound = !this.isBindable();
        this.m_userAlias = userAlias;
        this.m_alias = this.m_userAlias == null ? null : this.m_userAlias.getName();
    }

    public abstract String getClause();

    public void bind(Object object) {
        this.setValue(object);
        this.setBound(true);
    }

    public Object getValue() {
        return this.m_value;
    }

    public Object getAttribute() {
        return this.m_attribute;
    }

    public String toString() {
        return this.m_attribute + this.getClause() + this.m_value;
    }

    public boolean isBound() {
        return this.m_bound;
    }

    protected void setBound(boolean bl) {
        this.m_bound = bl;
    }

    protected void setValue(Object object) {
        this.m_value = object;
    }

    protected boolean isBindable() {
        return this.getValue() == null;
    }

    public int getNumberOfExtentsToBind() {
        return this.m_numberOfExtentsToBind;
    }

    public void setNumberOfExtentsToBind(int n) {
        this.m_numberOfExtentsToBind = n;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String string) {
        this.m_alias = string;
        String string2 = (String)this.getAttribute();
        boolean bl = true;
        this.m_userAlias = new UserAlias(string, string2, bl);
    }

    public void setAlias(String string, String string2) {
        this.m_alias = string;
        this.m_userAlias = new UserAlias(string, (String)this.getAttribute(), string2);
    }

    public void setAlias(UserAlias userAlias) {
        this.m_alias = userAlias.getName();
        this.m_userAlias = userAlias;
    }

    public UserAlias getUserAlias() {
        return this.m_userAlias;
    }

    public boolean isTranslateAttribute() {
        return this.m_translateAttribute;
    }

    void setTranslateAttribute(boolean bl) {
        this.m_translateAttribute = bl;
    }

    public Criteria getCriteria() {
        return this.m_criteria;
    }

    void setCriteria(Criteria criteria) {
        this.m_criteria = criteria;
    }

    public QueryByCriteria getQuery() {
        if (this.getCriteria() != null) {
            return this.getCriteria().getQuery();
        }
        return null;
    }

    public Map getPathClasses() {
        return this.getCriteria().getPathClasses();
    }

    public List getClassesForPath(String string) {
        return this.getCriteria().getClassesForPath(string);
    }
}

