/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.element.BreadcrumbItem;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTag(name="breadcrumbOptions", parent="Uif-BreadcrumbOptions")
public class BreadcrumbOptions
implements Serializable,
Copyable {
    private static final long serialVersionUID = -6705552809624394000L;
    private List<BreadcrumbItem> homewardPathBreadcrumbs;
    private List<BreadcrumbItem> preViewBreadcrumbs;
    private List<BreadcrumbItem> prePageBreadcrumbs;
    private List<BreadcrumbItem> breadcrumbOverrides;

    public void setupBreadcrumbs(Object model) {
        View view = ViewLifecycle.getView();
        if (model != null && model instanceof UifFormBase) {
            boolean usingFlow;
            UifFormBase form = (UifFormBase)model;
            boolean bl = usingFlow = StringUtils.isNotBlank((String)form.getFlowKey()) || view.getBreadcrumbs() != null && view.getBreadcrumbs().isUsePathBasedBreadcrumbs();
            if (usingFlow && form.getHistoryManager() != null) {
                HistoryFlow historyFlow;
                String formKey = form.getRequestedFormKey();
                if (StringUtils.isBlank((String)formKey)) {
                    formKey = form.getFormKey();
                    form.setRequestedFormKey(formKey);
                }
                if ((historyFlow = form.getHistoryManager().process(form.getFlowKey(), formKey, form.getRequestUrl())) != null) {
                    form.setHistoryFlow(historyFlow);
                    form.setFlowKey(historyFlow.getFlowKey());
                }
            }
            view.getBreadcrumbs().setUsePathBasedBreadcrumbs(usingFlow);
            if (view.getBreadcrumbs() != null && view.getBreadcrumbs().isUsePathBasedBreadcrumbs() && form.getHistoryFlow() != null && form.getHistoryFlow().getPastItems() != null) {
                List<BreadcrumbItem> pastItems = form.getHistoryFlow().getPastItems();
                ComponentUtils.clearAndAssignIds(pastItems);
                view.setPathBasedBreadcrumbs(pastItems);
            }
        }
    }

    public void finalizeBreadcrumbs(Object model, Container parent, BreadcrumbItem breadcrumbItem) {
        View view = ViewLifecycle.getView();
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel()) && view.getHeader() != null && !StringUtils.isBlank((String)view.getHeader().getHeaderText()) && model instanceof UifFormBase) {
            breadcrumbItem.setLabel(KRADUtils.generateUniqueViewTitle((UifFormBase)model, view));
        }
        if (StringUtils.isBlank((String)breadcrumbItem.getLabel())) {
            breadcrumbItem.setRender(false);
        }
        this.finalizeBreadcrumbsUrl(model, parent, breadcrumbItem);
        if (breadcrumbItem.getUrl().getPageId() == null && !view.getBreadcrumbs().isUsePathBasedBreadcrumbs()) {
            if (view.getEntryPageId() != null) {
                breadcrumbItem.getUrl().setPageId(view.getEntryPageId());
            } else if (view.isSinglePageView() && view.getPage() != null) {
                breadcrumbItem.getUrl().setPageId(view.getPage().getId());
            } else if (!view.getItems().isEmpty() && view.getItems().get(0) != null) {
                breadcrumbItem.getUrl().setPageId(view.getItems().get(0).getId());
            }
        }
        if (model instanceof UifFormBase && ((UifFormBase)model).getHistoryFlow() != null) {
            ContextUtils.cleanContextDeep(view.getBreadcrumbItem());
            ((UifFormBase)model).getHistoryFlow().setCurrentViewItem(view.getBreadcrumbItem());
        }
    }

    protected void finalizeBreadcrumbsUrl(Object model, Container parent, BreadcrumbItem breadcrumbItem) {
        if (breadcrumbItem.getUrl().getControllerMapping() == null && breadcrumbItem.getUrl().getViewId() == null && model instanceof UifFormBase && breadcrumbItem.getUrl().getRequestParameters() == null && ((UifFormBase)model).getInitialRequestParameters() != null) {
            Map<String, String[]> requestParameters = ((UifFormBase)model).getInitialRequestParameters();
            requestParameters.remove("ajaxReturnType");
            requestParameters.remove("ajaxRequest");
            requestParameters.remove("pageId");
            breadcrumbItem.getUrl().setRequestParameters(KRADUtils.translateRequestParameterMap(requestParameters));
        }
        if (breadcrumbItem.getUrl().getFormKey() == null && model instanceof UifFormBase && ((UifFormBase)model).getFormKey() != null) {
            breadcrumbItem.getUrl().setFormKey(((UifFormBase)model).getFormKey());
        }
        if (breadcrumbItem.getUrl().getControllerMapping() == null && model instanceof UifFormBase) {
            breadcrumbItem.getUrl().setControllerMapping(((UifFormBase)model).getControllerMapping());
        }
        if (breadcrumbItem.getUrl().getViewId() == null) {
            breadcrumbItem.getUrl().setViewId(ViewLifecycle.getView().getId());
        }
    }

    @BeanTagAttribute(name="homewardPathBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getHomewardPathBreadcrumbs() {
        return this.homewardPathBreadcrumbs;
    }

    public void setHomewardPathBreadcrumbs(List<BreadcrumbItem> homewardPathBreadcrumbs) {
        this.homewardPathBreadcrumbs = homewardPathBreadcrumbs;
    }

    @BeanTagAttribute(name="preViewBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getPreViewBreadcrumbs() {
        return this.preViewBreadcrumbs;
    }

    public void setPreViewBreadcrumbs(List<BreadcrumbItem> preViewBreadcrumbs) {
        this.preViewBreadcrumbs = preViewBreadcrumbs;
    }

    @BeanTagAttribute(name="prePageBreadcrumbs", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getPrePageBreadcrumbs() {
        return this.prePageBreadcrumbs;
    }

    public void setPrePageBreadcrumbs(List<BreadcrumbItem> prePageBreadcrumbs) {
        this.prePageBreadcrumbs = prePageBreadcrumbs;
    }

    @BeanTagAttribute(name="breadcrumbOverrides", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<BreadcrumbItem> getBreadcrumbOverrides() {
        return this.breadcrumbOverrides;
    }

    public void setBreadcrumbOverrides(List<BreadcrumbItem> breadcrumbOverrides) {
        this.breadcrumbOverrides = breadcrumbOverrides;
    }

    @Override
    public BreadcrumbOptions clone() throws CloneNotSupportedException {
        return (BreadcrumbOptions)super.clone();
    }
}

