/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import com.carrotsearch.hppc.BitMixer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

class CardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private final int precision;
    private final ValuesSource valuesSource;
    @Nullable
    private HyperLogLogPlusPlus counts;
    private Collector collector;

    CardinalityAggregator(String name, ValuesSource valuesSource, int precision, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.counts = valuesSource == null ? null : new HyperLogLogPlusPlus(precision, context.bigArrays(), 1L);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    private Collector pickCollector(LeafReaderContext ctx) throws IOException {
        if (this.valuesSource == null) {
            return new EmptyCollector();
        }
        if (this.valuesSource instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric source = (ValuesSource.Numeric)this.valuesSource;
            MurmurHash3Values hashValues = source.isFloatingPoint() ? MurmurHash3Values.hash(source.doubleValues(ctx)) : MurmurHash3Values.hash(source.longValues(ctx));
            return new DirectCollector(this.counts, hashValues);
        }
        if (this.valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
            long countsMemoryUsage;
            ValuesSource.Bytes.WithOrdinals source = (ValuesSource.Bytes.WithOrdinals)this.valuesSource;
            SortedSetDocValues ordinalValues = source.ordinalsValues(ctx);
            long maxOrd = ordinalValues.getValueCount();
            if (maxOrd == 0L) {
                return new EmptyCollector();
            }
            long ordinalsMemoryUsage = OrdinalsCollector.memoryOverhead(maxOrd);
            if (ordinalsMemoryUsage < (countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(this.precision)) / 4L) {
                return new OrdinalsCollector(this.counts, ordinalValues, this.context.bigArrays());
            }
        }
        return new DirectCollector(this.counts, MurmurHash3Values.hash(this.valuesSource.bytesValues(ctx)));
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        this.postCollectLastCollector();
        this.collector = this.pickCollector(ctx);
        return this.collector;
    }

    private void postCollectLastCollector() throws IOException {
        if (this.collector != null) {
            try {
                this.collector.postCollect();
                this.collector.close();
            }
            finally {
                this.collector = null;
            }
        }
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.postCollectLastCollector();
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts == null ? 0.0 : (double)this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxBucket() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        HyperLogLogPlusPlus copy = new HyperLogLogPlusPlus(this.precision, BigArrays.NON_RECYCLING_INSTANCE, 1L);
        copy.merge(0L, this.counts, owningBucketOrdinal);
        return new InternalCardinality(this.name, copy, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null, this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.counts, this.collector);
    }

    private static class EmptyCollector
    extends Collector {
        private EmptyCollector() {
        }

        @Override
        public void collect(int doc, long bucketOrd) {
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() {
        }
    }

    static abstract class MurmurHash3Values {
        MurmurHash3Values() {
        }

        public abstract boolean advanceExact(int var1) throws IOException;

        public abstract int count();

        public abstract long nextValue() throws IOException;

        public static MurmurHash3Values hash(SortedNumericDoubleValues values) {
            return new Double(values);
        }

        public static MurmurHash3Values hash(SortedNumericDocValues values) {
            return new Long(values);
        }

        public static MurmurHash3Values hash(SortedBinaryDocValues values) {
            return new Bytes(values);
        }

        private static class Double
        extends MurmurHash3Values {
            private final SortedNumericDoubleValues values;

            Double(SortedNumericDoubleValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)java.lang.Double.doubleToLongBits(this.values.nextValue()));
            }
        }

        private static class Long
        extends MurmurHash3Values {
            private final SortedNumericDocValues values;

            Long(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                return BitMixer.mix64((long)this.values.nextValue());
            }
        }

        private static class Bytes
        extends MurmurHash3Values {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            private final SortedBinaryDocValues values;

            Bytes(SortedBinaryDocValues values) {
                this.values = values;
            }

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return this.values.advanceExact(docId);
            }

            @Override
            public int count() {
                return this.values.docValueCount();
            }

            @Override
            public long nextValue() throws IOException {
                BytesRef bytes = this.values.nextValue();
                MurmurHash3.hash128(bytes.bytes, bytes.offset, bytes.length, 0L, this.hash);
                return this.hash.h1;
            }
        }
    }

    private static class DirectCollector
    extends Collector {
        private final MurmurHash3Values hashes;
        private final HyperLogLogPlusPlus counts;

        DirectCollector(HyperLogLogPlusPlus counts, MurmurHash3Values values) {
            this.counts = counts;
            this.hashes = values;
        }

        @Override
        public void collect(int doc, long bucketOrd) throws IOException {
            if (this.hashes.advanceExact(doc)) {
                int valueCount = this.hashes.count();
                for (int i = 0; i < valueCount; ++i) {
                    this.counts.collect(bucketOrd, this.hashes.nextValue());
                }
            }
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() {
        }
    }

    private static class OrdinalsCollector
    extends Collector {
        private static final long SHALLOW_FIXEDBITSET_SIZE = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
        private final BigArrays bigArrays;
        private final SortedSetDocValues values;
        private final int maxOrd;
        private final HyperLogLogPlusPlus counts;
        private ObjectArray<FixedBitSet> visitedOrds;

        public static long memoryOverhead(long maxOrd) {
            return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + SHALLOW_FIXEDBITSET_SIZE + (maxOrd + 7L) / 8L;
        }

        OrdinalsCollector(HyperLogLogPlusPlus counts, SortedSetDocValues values, BigArrays bigArrays) {
            if (values.getValueCount() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.maxOrd = (int)values.getValueCount();
            this.bigArrays = bigArrays;
            this.counts = counts;
            this.values = values;
            this.visitedOrds = bigArrays.newObjectArray(1L);
        }

        @Override
        public void collect(int doc, long bucketOrd) throws IOException {
            this.visitedOrds = this.bigArrays.grow(this.visitedOrds, bucketOrd + 1L);
            FixedBitSet bits = this.visitedOrds.get(bucketOrd);
            if (bits == null) {
                bits = new FixedBitSet(this.maxOrd);
                this.visitedOrds.set(bucketOrd, bits);
            }
            if (this.values.advanceExact(doc)) {
                long ord = this.values.nextOrd();
                while (ord != -1L) {
                    bits.set((int)ord);
                    ord = this.values.nextOrd();
                }
            }
        }

        @Override
        public void postCollect() throws IOException {
            FixedBitSet allVisitedOrds = new FixedBitSet(this.maxOrd);
            for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                FixedBitSet bits = this.visitedOrds.get(bucket);
                if (bits == null) continue;
                allVisitedOrds.or(bits);
            }
            MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            try (LongArray hashes = this.bigArrays.newLongArray(this.maxOrd, false);){
                int ord = allVisitedOrds.nextSetBit(0);
                while (ord < Integer.MAX_VALUE) {
                    BytesRef value = this.values.lookupOrd((long)ord);
                    MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, hash);
                    hashes.set(ord, hash.h1);
                    ord = ord + 1 < this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1) : Integer.MAX_VALUE;
                }
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    FixedBitSet bits = this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    int ord2 = bits.nextSetBit(0);
                    while (ord2 < Integer.MAX_VALUE) {
                        this.counts.collect(bucket, hashes.get(ord2));
                        ord2 = ord2 + 1 < this.maxOrd ? bits.nextSetBit(ord2 + 1) : Integer.MAX_VALUE;
                    }
                }
            }
        }

        @Override
        public void close() {
            Releasables.close(this.visitedOrds);
        }
    }

    private static abstract class Collector
    extends LeafBucketCollector
    implements Releasable {
        private Collector() {
        }

        public abstract void postCollect() throws IOException;
    }
}

